/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.renderer.Blueprint;
import genj.renderer.Options;
import genj.renderer.PropertyRenderer;
import genj.util.Dimension2d;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Dimension2D;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DocumentParser;
import javax.swing.text.html.parser.ParserDelegator;

public class EntityRenderer {
    private static final int PROP_IMAGE_WIDTH;
    private static final int PROP_IMAGE_HEIGHT;
    private static final Segment EMPTY_SEGMENT;
    private RootView root;
    private HTMLDocument doc = new MyHTMLDocument();
    private MyHTMLFactory factory = new MyHTMLFactory();
    private static DTD dtd;
    private FontRenderContext context;
    private Entity entity;
    private List propViews = new ArrayList(16);
    private List tableViews = new ArrayList(4);
    private boolean isDebug = false;
    private Point dpi = new Point(96, 96);
    private boolean isScaleFonts = false;

    public EntityRenderer(Blueprint bp) {
        this(bp, Options.getInstance().getDefaultFont());
    }

    public EntityRenderer(Blueprint bp, Font font) {
        StringBuffer html = new StringBuffer();
        html.append("<html><head><style type=\"text/css\">");
        if (font != null) {
            html.append(" body { font-family: \"" + font.getFamily() + "\"; font-size: " + font.getSize() + "pt; } ");
        }
        html.append(" table { border-style: solid;}");
        html.append(" td  { border-style: solid;  }");
        html.append("</style></head><body>");
        html.append(bp.getHTML());
        html.append("</body></html>");
        try {
            MyHTMLReader reader = new MyHTMLReader(this.doc);
            new MyDocumentParser(DTD.getDTD("html32")).parse(new StringReader(html.toString()), reader, false);
            reader.flush();
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.root = new RootView(this.factory.create(this.doc.getDefaultRootElement()));
    }

    public EntityRenderer setResolution(Point set) {
        this.dpi = new Point(set);
        return this;
    }

    public EntityRenderer setResolution(Dimension set) {
        this.dpi = new Point(set.width, set.height);
        return this;
    }

    public EntityRenderer setScaleFonts(boolean set) {
        this.isScaleFonts = set;
        return this;
    }

    public void render(Graphics g, Entity e, Rectangle r) {
        this.entity = e;
        this.context = ((Graphics2D)g).getFontRenderContext();
        Iterator pv = this.propViews.iterator();
        while (pv.hasNext()) {
            ((PropertyView)pv.next()).invalidate();
        }
        Iterator tv = this.tableViews.iterator();
        while (tv.hasNext()) {
            try {
                ((View)tv.next()).replace(0, 0, null);
            }
            catch (Throwable t) {}
        }
        this.root.setSize((float)r.getWidth(), (float)r.getHeight());
        Rectangle oc = g.getClipBounds();
        g.clipRect(r.x, r.y, r.width, r.height);
        this.root.paint(g, r);
        g.setClip(oc.x, oc.y, oc.width, oc.height);
    }

    public void setDebug(boolean set) {
        this.isDebug = set;
    }

    static {
        new ParserDelegator();
        PROP_IMAGE_WIDTH = Indi.IMG_MALE.getIconWidth() + 4;
        PROP_IMAGE_HEIGHT = Indi.IMG_MALE.getIconHeight();
        EMPTY_SEGMENT = new Segment();
        dtd = null;
    }

    private class PropertyView
    extends MyView {
        private int preference;
        private TagPath path;
        private Property cachedProperty;
        private int min;
        private int max;
        private boolean isValid;

        PropertyView(Element elem) {
            super(elem);
            this.path = null;
            this.cachedProperty = null;
            this.isValid = false;
            Object p = elem.getAttributes().getAttribute("path");
            if (p != null) {
                try {
                    this.path = new TagPath(p.toString());
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            this.preference = 10;
            AttributeSet atts = elem.getAttributes();
            if ("yes".equals(atts.getAttribute("img"))) {
                this.preference = "no".equals(atts.getAttribute("txt")) ? 1 : (this.preference |= 1);
            }
            this.min = this.getInt(atts, "min", 1, 100, 1);
            this.max = this.getInt(atts, "max", 1, 100, 100);
        }

        private int getInt(AttributeSet atts, String key, int min, int max, int def) {
            Object val = atts.getAttribute(key);
            if (val != null) {
                try {
                    return Math.max(min, Math.min(max, Integer.parseInt(val.toString())));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            return def;
        }

        private Property getProperty() {
            if (!this.isValid) {
                this.cachedProperty = this.path != null ? EntityRenderer.this.entity.getProperty(this.path) : null;
                this.isValid = true;
            }
            return this.cachedProperty;
        }

        private PropertyRenderer getRenderer(Property prop) {
            PropertyRenderer result = PropertyRenderer.get(this.path, prop);
            if (prop == null && !result.isNullRenderer()) {
                return null;
            }
            return result;
        }

        public void paint(Graphics g, Shape allocation) {
            Rectangle r;
            Graphics2D graphics = (Graphics2D)g;
            Property property = this.getProperty();
            PropertyRenderer renderer = this.getRenderer(property);
            if (renderer == null) {
                return;
            }
            g.setColor(super.getForeground());
            g.setFont(super.getFont());
            Rectangle rectangle = r = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
            if (EntityRenderer.this.isDebug) {
                graphics.draw(r);
            }
            Shape old = graphics.getClip();
            graphics.clip(r);
            renderer.render(graphics, r, property, this.preference, EntityRenderer.this.dpi);
            g.setClip(old);
        }

        protected Dimension2D getPreferredSpan() {
            Property property = this.getProperty();
            PropertyRenderer renderer = this.getRenderer(property);
            if (renderer == null) {
                return new Dimension(0, 0);
            }
            Dimension2D d = renderer.getSize(this.getFont(), EntityRenderer.this.context, property, this.preference, EntityRenderer.this.dpi);
            d = new Dimension2d(Math.min(d.getWidth(), (double)(EntityRenderer.this.root.width * (float)this.max / 100.0f)), d.getHeight());
            return d;
        }

        public float getMinimumSpan(int axis) {
            float pref = this.getPreferredSpan(axis);
            if (axis == 1) {
                return pref;
            }
            return Math.min(pref, EntityRenderer.this.root.width * (float)this.min / 100.0f);
        }

        protected void invalidate() {
            this.isValid = false;
            super.invalidate();
        }
    }

    private class I18NView
    extends MyView {
        private String txt;

        private I18NView(Element elem) {
            super(elem);
            this.txt = "?";
            Object o = elem.getAttributes().getAttribute("tag");
            if (o != null) {
                this.txt = Gedcom.getName(o.toString());
            } else {
                o = elem.getAttributes().getAttribute("entity");
                if (o != null) {
                    this.txt = Gedcom.getName(o.toString());
                }
            }
        }

        public void paint(Graphics g, Shape allocation) {
            Rectangle r = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
            g.setFont(this.getFont());
            g.setColor(this.getForeground());
            PropertyRenderer.DEFAULT_RENDERER.renderImpl((Graphics2D)g, r, this.txt, 10);
        }

        protected Dimension2D getPreferredSpan() {
            return PropertyRenderer.DEFAULT_RENDERER.getSizeImpl(this.getFont(), EntityRenderer.this.context, null, this.txt, 10, EntityRenderer.this.dpi);
        }
    }

    private class RootView
    extends MyView {
        private View view;
        private float width;
        private float height;

        RootView(View view) {
            super(null);
            this.view = view;
            try {
                view.setParent(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public void paint(Graphics g, Shape allocation) {
            try {
                this.view.paint(g, allocation);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public Document getDocument() {
            return EntityRenderer.this.doc;
        }

        public void setSize(float wIdth, float heIght) {
            this.width = wIdth;
            this.height = heIght;
            try {
                this.view.setSize(this.width, this.height);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        protected Dimension2D getPreferredSpan() {
            return new Dimension2d((int)this.view.getPreferredSpan(0), (int)this.view.getPreferredSpan(1));
        }
    }

    private abstract class MyView
    extends View {
        private Font font;
        private Color foreground;
        private Dimension2D preferredSpan;

        MyView(Element elem) {
            super(elem);
            this.font = null;
            this.foreground = null;
            this.preferredSpan = null;
        }

        public int viewToModel(float arg0, float arg1, Shape arg2, Position.Bias[] arg3) {
            throw new RuntimeException("viewToModel() is not supported");
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            throw new RuntimeException("modelToView() is not supported");
        }

        public int getBreakWeight(int axis, float pos, float len) {
            if (axis == 1) {
                return 0;
            }
            if (len > this.getPreferredSpan(0)) {
                return 1000;
            }
            return 0;
        }

        public View breakView(int axis, int offset, float pos, float len) {
            return this;
        }

        public float getPreferredSpan(int axis) {
            if (this.preferredSpan == null) {
                this.preferredSpan = this.getPreferredSpan();
            }
            return (float)(axis == 0 ? this.preferredSpan.getWidth() : this.preferredSpan.getHeight());
        }

        public float getMaximumSpan(int axis) {
            return this.getPreferredSpan(axis);
        }

        public float getAlignment(int axis) {
            if (0 == axis) {
                return super.getAlignment(axis);
            }
            float height = (float)this.getPreferredSpan().getHeight();
            LineMetrics lm = this.getFont().getLineMetrics("", EntityRenderer.this.context);
            float h = lm.getHeight();
            float d = lm.getDescent();
            return (h - d) / height;
        }

        protected abstract Dimension2D getPreferredSpan();

        protected Font getFont() {
            if (this.font == null) {
                this.font = EntityRenderer.this.doc.getFont(EntityRenderer.this.doc.getStyleSheet().getViewAttributes(this));
            }
            return this.font;
        }

        protected Color getForeground() {
            if (this.foreground == null) {
                this.foreground = EntityRenderer.this.doc.getForeground(EntityRenderer.this.doc.getStyleSheet().getViewAttributes(this));
            }
            return this.foreground;
        }

        protected void invalidate() {
            this.preferredSpan = null;
            super.preferenceChanged(this, true, true);
        }

        public ViewFactory getViewFactory() {
            return EntityRenderer.this.factory;
        }
    }

    private class MyHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        private MyHTMLFactory() {
        }

        public View create(Element elem) {
            String name = elem.getName();
            if ("prop".equals(name)) {
                PropertyView result = new PropertyView(elem);
                EntityRenderer.this.propViews.add(result);
                return result;
            }
            if ("name".equals(name) || "i18n".equals(name)) {
                return new I18NView(elem);
            }
            View result = super.create(elem);
            if ("table".equals(elem.getName())) {
                EntityRenderer.this.tableViews.add(result);
            }
            return result;
        }
    }

    private static class MyHTMLReader
    extends HTMLDocument.HTMLReader {
        private boolean skipContent;

        protected MyHTMLReader(HTMLDocument doc) {
            HTMLDocument hTMLDocument = doc;
            hTMLDocument.getClass();
            super(hTMLDocument, 0);
            this.skipContent = false;
        }

        protected void blockClose(HTML.Tag t) {
            this.skipContent = true;
            super.blockClose(t);
            this.skipContent = false;
        }

        protected void addContent(char[] data, int offs, int length, boolean generateImpliedPIfNecessary) {
            if (!this.skipContent) {
                super.addContent(data, offs, length, generateImpliedPIfNecessary);
            }
        }
    }

    private class MyDocumentParser
    extends DocumentParser {
        private MyDocumentParser(DTD dtd) {
            super(dtd);
            this.strict = true;
        }
    }

    private class MyHTMLDocument
    extends HTMLDocument {
        private MyHTMLDocument() {
        }

        public Font getFont(AttributeSet attr) {
            Font font = super.getFont(attr);
            if (EntityRenderer.this.isScaleFonts) {
                float factor = (float)((EntityRenderer)EntityRenderer.this).dpi.y / 72.0f;
                font = font.deriveFont(factor * font.getSize2D());
            }
            return font;
        }
    }
}

