/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.gedcom.Gedcom;
import genj.renderer.Blueprint;
import genj.util.EnvironmentChecker;
import genj.util.Origin;
import genj.util.Registry;
import genj.util.Resources;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlueprintManager {
    private static final String SUFFIX = ".html";
    static final Logger LOG = Logger.getLogger("genj.renderer");
    private Map tag2blueprints = new HashMap();
    private static BlueprintManager instance;
    private Resources resources = Resources.get(BlueprintManager.class);

    public static BlueprintManager getInstance() {
        if (instance == null) {
            instance = new BlueprintManager();
        }
        return instance;
    }

    private BlueprintManager() {
        for (int t = 0; t < Gedcom.ENTITIES.length; ++t) {
            String tag = Gedcom.ENTITIES[t];
            StringTokenizer names = new StringTokenizer(this.resources.getString("blueprints." + tag, ""));
            while (names.hasMoreTokens()) {
                String name = names.nextToken();
                String html = this.resources.getString("blueprints." + tag + "." + name);
                try {
                    this.addBlueprint(new Blueprint(tag, name, html.toString(), true));
                }
                catch (IOException e) {}
            }
        }
        Registry registry = Registry.lookup("genj", null);
        for (int t = 0; t < Gedcom.ENTITIES.length; ++t) {
            String tag = Gedcom.ENTITIES[t];
            StringTokenizer names = new StringTokenizer(registry.get("options.blueprints." + tag, ""));
            while (names.hasMoreTokens()) {
                String name = names.nextToken();
                String html = registry.get("options.blueprints." + tag + "." + name, (String)null);
                if (html == null || html.length() <= 0) continue;
                try {
                    this.addBlueprint(new Blueprint(tag, name, html, false));
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "converting old-style blueprint '" + name + "' failed", e);
                }
            }
        }
        registry.remove("options.blueprints");
        this.loadBlueprints();
    }

    private File getBlueprintDirectory() {
        return new File(EnvironmentChecker.getProperty((Object)this, "user.home.genj/blueprints", "?", "Looking for blueprints"));
    }

    private File getBlueprintFile(Blueprint blueprint) throws IOException {
        if (blueprint.getName().indexOf(34) >= 0) {
            throw new IOException("Quotes are not allowed in blueprint names");
        }
        return new File(this.getBlueprintDirectory(), "/" + blueprint.getTag() + "/" + blueprint.getName() + SUFFIX).getCanonicalFile();
    }

    void saveBlueprint(Blueprint blueprint) throws IOException {
        if (!blueprint.isDirty()) {
            return;
        }
        File file = this.getBlueprintFile(blueprint);
        File parent = file.getParentFile();
        parent.mkdirs();
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException("Cannot create folder for blueprint " + blueprint.getName());
        }
        this.readwrite(new StringReader(blueprint.getHTML()), new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        blueprint.clearDirty();
        LOG.log(Level.INFO, "saved blueprint " + file);
    }

    private void loadBlueprints() {
        File dir = this.getBlueprintDirectory();
        try {
            if (!dir.isDirectory() || !dir.exists()) {
                return;
            }
            for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
                this.loadBlueprints(dir, Gedcom.ENTITIES[i]);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "unexpected throwable loading blueprints from " + dir, t);
        }
    }

    private void loadBlueprints(File dir, String tag) throws IOException {
        if (!(dir = new File(dir, tag)).isDirectory() || !dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int b = 0; b < files.length; ++b) {
            File file = files[b];
            String name = file.getName();
            if (!name.endsWith(SUFFIX) || file.isDirectory()) continue;
            name = name.substring(0, name.length() - SUFFIX.length());
            Blueprint blueprint = this.loadBlueprint(new FileInputStream(file), tag, name, false);
            blueprint.clearDirty();
            this.addBlueprint(blueprint);
        }
    }

    private Blueprint loadBlueprint(InputStream in, String tag, String name, boolean readOnly) throws IOException {
        StringWriter html = new StringWriter(512);
        this.readwrite(new InputStreamReader(in, "UTF8"), html);
        in.close();
        return new Blueprint(tag, name, html.toString(), readOnly);
    }

    private void readwrite(Reader in, Writer out) throws IOException {
        String line;
        BufferedReader bin = new BufferedReader(in);
        BufferedWriter bout = new BufferedWriter(out);
        while ((line = bin.readLine()) != null) {
            bout.write(line);
            bout.newLine();
        }
        bin.close();
        bout.close();
    }

    public Blueprint getBlueprint(Origin origin, String tag, String name) {
        if (name.length() == 0) {
            name = "Default";
        }
        List bps = this.getBlueprints(tag);
        for (int i = 0; i < bps.size(); ++i) {
            Blueprint bp = (Blueprint)bps.get(i);
            if (!bp.getName().equals(name)) continue;
            return bp;
        }
        String local = "blueprints/" + tag + "/" + name + SUFFIX;
        try {
            return this.loadBlueprint(origin.open(local), tag, name, true);
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Failed to load blueprint " + local + " from " + origin + " (" + e.getMessage() + ")");
            return (Blueprint)bps.get(0);
        }
    }

    public List getBlueprints(String tag) {
        return Collections.unmodifiableList(this.getBlueprintsInternal(tag));
    }

    private List getBlueprintsInternal(String tag) {
        ArrayList result = (ArrayList)this.tag2blueprints.get(tag);
        if (result == null) {
            result = new ArrayList();
            this.tag2blueprints.put(tag, result);
        }
        return result;
    }

    public Blueprint addBlueprint(Blueprint blueprint) throws IOException {
        if (!blueprint.isReadOnly()) {
            this.getBlueprintFile(blueprint);
        }
        List blueprints = this.getBlueprintsInternal(blueprint.getTag());
        ListIterator it = blueprints.listIterator();
        while (it.hasNext()) {
            Blueprint other = (Blueprint)it.next();
            if (!other.getName().equalsIgnoreCase(blueprint.getName())) continue;
            if (other.isReadOnly()) {
                throw new IOException("Can't override read-only blueprint");
            }
            it.remove();
            break;
        }
        if (!blueprint.isReadOnly()) {
            this.saveBlueprint(blueprint);
        }
        blueprints.add(blueprint);
        return blueprint;
    }

    public void delBlueprint(Blueprint blueprint) throws IOException {
        if (blueprint.isReadOnly()) {
            throw new IOException("Can't delete read-only Blueprint");
        }
        if (!blueprint.isReadOnly() && !this.getBlueprintFile(blueprint).delete()) {
            throw new IOException("Couldn't delete blueprint " + blueprint);
        }
        this.getBlueprintsInternal(blueprint.getTag()).remove(blueprint);
    }
}

