/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.gedcom.Gedcom;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintEditor;
import genj.renderer.BlueprintManager;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.HeadlessLabel;
import genj.window.WindowManager;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import swingx.tree.AbstractTreeModel;

public class BlueprintList
extends JSplitPane {
    private Map selection = new HashMap();
    private BlueprintEditor editor;
    private JTree treeBlueprints;
    private Add add = new Add();
    private Del del = new Del();
    private static final Resources resources = Resources.get(BlueprintEditor.class);
    private Gedcom gedcom;
    private Model model = new Model();

    public BlueprintList(BlueprintManager bpMgr) {
        this.editor = new BlueprintEditor(bpMgr);
        this.treeBlueprints = new JTree(this.model);
        this.treeBlueprints.setRootVisible(false);
        this.treeBlueprints.setShowsRootHandles(true);
        this.treeBlueprints.setCellRenderer(new Renderer());
        this.treeBlueprints.getSelectionModel().setSelectionMode(1);
        this.treeBlueprints.getSelectionModel().addTreeSelectionListener(new SelectionListener());
        Box left = new Box(1);
        JScrollPane scroll = new JScrollPane(this.treeBlueprints);
        scroll.setAlignmentX(0.0f);
        left.add(scroll);
        ButtonHelper bh = new ButtonHelper().setContainer(left);
        bh.create(this.add);
        bh.create(this.del);
        this.setLeftComponent(left);
        this.setRightComponent(this.editor);
    }

    public void setGedcom(Gedcom geDcom) {
        this.gedcom = geDcom;
    }

    public Map getSelection() {
        this.editor.commit();
        return this.selection;
    }

    public void setSelection(Map selEction) {
        this.selection = selEction;
        this.treeBlueprints.repaint();
    }

    private class Model
    extends AbstractTreeModel {
        private Model() {
        }

        protected void fireStructureChanged() {
            this.fireTreeStructureChanged(this, new Object[]{this}, null, null);
        }

        public boolean isLeaf(Object node) {
            return node instanceof Blueprint;
        }

        public int getIndexOfChild(Object parent, Object child) {
            if (child instanceof Blueprint) {
                Blueprint bp = (Blueprint)child;
                return BlueprintManager.getInstance().getBlueprints(bp.getTag()).indexOf(bp);
            }
            String tag = (String)child;
            for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
                if (!Gedcom.ENTITIES[i].equals(tag)) continue;
                return i;
            }
            throw new IllegalArgumentException();
        }

        protected Object getParent(Object node) {
            if (node == this) {
                return null;
            }
            if (node instanceof Blueprint) {
                return ((Blueprint)node).getTag();
            }
            return this;
        }

        public Object getChild(Object parent, int index) {
            if (parent == this) {
                return Gedcom.ENTITIES[index];
            }
            String tag = (String)parent;
            return BlueprintManager.getInstance().getBlueprints(tag).get(index);
        }

        public int getChildCount(Object parent) {
            if (parent == this) {
                return Gedcom.ENTITIES.length;
            }
            if (parent instanceof Blueprint) {
                return 0;
            }
            String tag = (String)parent;
            return BlueprintManager.getInstance().getBlueprints(tag).size();
        }

        public Object getRoot() {
            return this;
        }
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            BlueprintList.this.editor.commit();
            if (e.getNewLeadSelectionPath() != null) {
                Object node = e.getNewLeadSelectionPath().getLastPathComponent();
                if (node instanceof Blueprint) {
                    Blueprint bp = (Blueprint)node;
                    BlueprintList.this.selection.put(bp.getTag(), bp);
                    BlueprintList.this.treeBlueprints.repaint();
                    BlueprintList.this.add.setEnabled(true);
                    BlueprintList.this.del.setEnabled(!bp.isReadOnly());
                    BlueprintList.this.editor.set(BlueprintList.this.gedcom, bp, !bp.isReadOnly());
                    return;
                }
                BlueprintList.this.add.setEnabled(true);
                BlueprintList.this.del.setEnabled(false);
            } else {
                BlueprintList.this.add.setEnabled(false);
                BlueprintList.this.del.setEnabled(false);
            }
            BlueprintList.this.editor.set(null, null, false);
        }
    }

    private class Renderer
    implements TreeCellRenderer {
        private HeadlessLabel label = new HeadlessLabel();
        private Color cSelection = new DefaultTreeCellRenderer().getBackgroundSelectionColor();
        private JRadioButton button = new JRadioButton();

        private Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof Blueprint) {
                Blueprint bp = (Blueprint)value;
                this.button.setOpaque(selected);
                this.button.setBackground(this.cSelection);
                this.button.setText(bp.getName());
                this.button.setSelected(BlueprintList.this.selection.get(bp.getTag()) == bp);
                return this.button;
            }
            if (value instanceof String) {
                String tag = (String)value;
                this.label.setOpaque(selected);
                this.label.setBackground(this.cSelection);
                this.label.setText(Gedcom.getName(tag, true));
                this.label.setIcon(Gedcom.getEntityImage(tag));
            }
            return this.label;
        }
    }

    private class Del
    extends Action2 {
        private Del() {
            super.setText(resources, "blueprint.del");
            super.setEnabled(false);
        }

        protected void execute() {
            TreePath path = BlueprintList.this.treeBlueprints.getSelectionPath();
            if (path == null) {
                return;
            }
            Object node = path.getLastPathComponent();
            if (!(node instanceof Blueprint)) {
                return;
            }
            Blueprint blueprint = (Blueprint)node;
            int rc = WindowManager.getInstance(BlueprintList.this).openDialog(null, null, 3, resources.getString("blueprint.del.confirm", blueprint.getName()), Action2.okCancel(), (Component)BlueprintList.this);
            if (rc != 0) {
                return;
            }
            BlueprintList.this.selection.remove(blueprint.getTag());
            try {
                BlueprintManager.getInstance().delBlueprint(blueprint);
            }
            catch (IOException e) {
                // empty catch block
            }
            BlueprintList.this.model.fireStructureChanged();
        }
    }

    private class Add
    extends Action2 {
        private Add() {
            super.setText(resources, "blueprint.add");
            super.setEnabled(false);
        }

        protected void execute() {
            TreePath path = BlueprintList.this.treeBlueprints.getSelectionPath();
            if (path == null) {
                return;
            }
            Object node = path.getLastPathComponent();
            String name = WindowManager.getInstance(BlueprintList.this).openDialog(null, null, 3, resources.getString("blueprint.add.confirm"), "", (Component)BlueprintList.this);
            if (name == null || name.length() == 0) {
                return;
            }
            String html = node instanceof Blueprint ? ((Blueprint)node).getHTML() : "";
            try {
                Blueprint blueprint = BlueprintManager.getInstance().addBlueprint(new Blueprint(node instanceof Blueprint ? ((Blueprint)node).getTag() : (String)node, name, html, false));
                BlueprintList.this.model.fireStructureChanged();
                BlueprintList.this.treeBlueprints.setSelectionPath(new TreePath(BlueprintList.this.model.getPathToRoot(blueprint)));
                BlueprintList.this.editor.setHTMLVisible(true);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

