/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.common.PathTreeWidget;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertySimpleReadOnly;
import genj.gedcom.TagPath;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.EntityRenderer;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BlueprintEditor
extends JSplitPane {
    private JTextArea html;
    private Preview preview;
    private static final Resources resources = Resources.get(BlueprintEditor.class);
    private Gedcom gedcom;
    private Blueprint blueprint;
    private AbstractButton bInsert;
    private Example example = new Example();
    private boolean isChanged = false;
    private BlueprintManager blueprintManager;
    static /* synthetic */ Class class$genj$gedcom$Property;
    static /* synthetic */ Class class$genj$gedcom$PropertyXRef;

    public BlueprintEditor(BlueprintManager bpMgr) {
        this.blueprintManager = bpMgr;
        this.preview = new Preview();
        this.preview.setBorder(BorderFactory.createTitledBorder(resources.getString("blueprint.preview")));
        JPanel edit = new JPanel(new BorderLayout());
        this.html = new JTextArea(3, 32);
        this.html.setFont(new Font("Monospaced", 0, 12));
        JScrollPane scroll = new JScrollPane(this.html);
        scroll.setBorder(BorderFactory.createTitledBorder("HTML"));
        this.bInsert = new JButton(new ActionInsert());
        edit.setMinimumSize(new Dimension(0, 0));
        edit.add((Component)scroll, "Center");
        edit.add((Component)this.bInsert, "South");
        this.setLeftComponent(this.preview);
        this.setRightComponent(edit);
        this.setDividerLocation(Integer.MAX_VALUE);
        this.setOrientation(0);
        this.setOneTouchExpandable(true);
        this.html.getDocument().addDocumentListener(this.preview);
        this.set(null, null, false);
    }

    public int getLastDividerLocation() {
        return this.getSize().height / 2;
    }

    public void set(Gedcom geDcom, Blueprint scHeme, boolean editable) {
        this.gedcom = geDcom;
        if (scHeme == null) {
            this.blueprint = null;
            this.html.setText("");
            editable = false;
        } else {
            this.blueprint = scHeme;
            this.html.setText(this.blueprint.getHTML());
            this.html.setCaretPosition(0);
        }
        this.bInsert.setEnabled(editable && this.gedcom != null);
        this.html.setEditable(editable);
        this.html.setToolTipText(editable || this.blueprint == null ? null : resources.getString("blueprint.readonly", this.blueprint.getName()));
        this.isChanged = false;
        this.preview.repaint();
        if (this.blueprint != null && !this.blueprint.isReadOnly()) {
            this.setHTMLVisible(true);
        }
    }

    public void commit() {
        if (this.blueprint != null && this.isChanged) {
            this.blueprint.setHTML(this.html.getText());
            try {
                this.blueprintManager.saveBlueprint(this.blueprint);
                this.isChanged = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setHTMLVisible(boolean v) {
        this.setDividerLocation(v ? 0.5 : 1.0);
    }

    private class Example
    extends Entity {
        private Map tag2value = new HashMap();

        private Example() {
            this.tag2value.put("NAME", "John /Doe/");
            this.tag2value.put("SEX", "M");
            this.tag2value.put("DATE", "01 JAN 1900");
            this.tag2value.put("PLAC", "Nice Place");
            this.tag2value.put("ADDR", "Long Address");
            this.tag2value.put("CITY", "Big City");
            this.tag2value.put("POST", "12345");
        }

        public String getId() {
            String prefix = BlueprintEditor.this.blueprint == null ? "X" : Gedcom.getEntityPrefix(BlueprintEditor.this.blueprint.getTag());
            return prefix + "999";
        }

        public String getTag() {
            return BlueprintEditor.this.blueprint == null ? "INDI" : BlueprintEditor.this.blueprint.getTag();
        }

        public Property getProperty(TagPath path) {
            MetaProperty meta;
            if (!path.get(0).equals(this.getTag())) {
                return null;
            }
            if (path.length() == 1) {
                return this;
            }
            Object value = this.tag2value.get(path.getLast());
            if (value == null) {
                value = "Something";
            }
            if ((class$genj$gedcom$PropertyXRef == null ? (class$genj$gedcom$PropertyXRef = BlueprintEditor.class$("genj.gedcom.PropertyXRef")) : class$genj$gedcom$PropertyXRef).isAssignableFrom((meta = BlueprintEditor.this.gedcom.getGrammar().getMeta(path, false)).getType())) {
                value = "@...@";
            }
            try {
                return meta.create(value.toString());
            }
            catch (GedcomException e) {
                return new PropertySimpleReadOnly(path.getLast(), value.toString());
            }
        }
    }

    private class ActionInsert
    extends Action2 {
        private ActionInsert() {
            super.setText(resources.getString("prop.insert"));
            super.setTip(resources.getString("prop.insert.tip"));
            super.setTarget(BlueprintEditor.this);
        }

        protected void execute() {
            if (BlueprintEditor.this.gedcom == null) {
                return;
            }
            PathTreeWidget tree = new PathTreeWidget();
            TagPath[] paths = BlueprintEditor.this.gedcom.getGrammar().getAllPaths(BlueprintEditor.this.blueprint.getTag(), class$genj$gedcom$Property == null ? (class$genj$gedcom$Property = BlueprintEditor.class$("genj.gedcom.Property")) : class$genj$gedcom$Property);
            tree.setPaths(paths, new TagPath[0]);
            int option = WindowManager.getInstance(this.getTarget()).openDialog(null, resources.getString("prop.insert.tip"), 3, tree, Action2.okCancel(), (Component)BlueprintEditor.this);
            if (option != 0) {
                return;
            }
            paths = tree.getSelection();
            for (int p = 0; p < paths.length; ++p) {
                BlueprintEditor.this.html.insert("<prop path=" + paths[p].toString() + ">" + (p == paths.length - 1 ? "" : "\n"), BlueprintEditor.this.html.getCaretPosition());
            }
            BlueprintEditor.this.html.requestFocusInWindow();
        }
    }

    private class Preview
    extends JComponent
    implements DocumentListener {
        private Preview() {
        }

        public void changedUpdate(DocumentEvent e) {
            BlueprintEditor.this.isChanged = true;
            this.repaint();
        }

        public void insertUpdate(DocumentEvent e) {
            BlueprintEditor.this.isChanged = true;
            this.repaint();
        }

        public void removeUpdate(DocumentEvent e) {
            BlueprintEditor.this.isChanged = true;
            this.repaint();
        }

        protected void paintComponent(Graphics g) {
            if (BlueprintEditor.this.html.getText().length() == 0) {
                return;
            }
            Rectangle bounds = this.getBounds();
            Insets insets = this.getInsets();
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
            g.setColor(Color.white);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            EntityRenderer renderer = new EntityRenderer(new Blueprint(BlueprintEditor.this.html.getText()), this.getFont());
            renderer.setDebug(BlueprintEditor.this.isChanged);
            renderer.render(g, BlueprintEditor.this.example, bounds);
        }
    }
}

