/*
 * Decompiled with CFR 0.152.
 */
package genj.print;

import genj.option.Option;
import genj.option.OptionListener;
import genj.option.OptionsWidget;
import genj.option.PropertyOption;
import genj.print.PrintTask;
import genj.print.Printer;
import genj.renderer.Options;
import genj.util.Dimension2d;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.UnitGraphics;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.print.PrintService;
import javax.print.ServiceUI;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;

public class PrintWidget
extends JTabbedPane
implements OptionListener {
    private PrintTask task;
    private ChoiceWidget services;
    private Preview preview;

    public PrintWidget(PrintTask task) {
        this.task = task;
        this.add(PrintTask.RESOURCES.getString("printer"), this.createFirstPage());
        this.add(PrintTask.RESOURCES.getString("settings"), this.createSecondPage());
    }

    private JPanel createFirstPage() {
        String LAYOUT_TEMPLATE = "<col><row><lprinter/><printers wx=\"1\"/><settings/></row><row><lpreview/></row><row><preview wx=\"1\" wy=\"1\"/></row></col>";
        JPanel page = new JPanel(new NestedBlockLayout(LAYOUT_TEMPLATE));
        page.add("lprinter", new JLabel(PrintTask.RESOURCES.getString("printer")));
        this.services = new ChoiceWidget(this.task.getServices(), this.task.getService());
        this.services.setEditable(false);
        this.services.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    PrintWidget.this.task.setService((PrintService)PrintWidget.this.services.getSelectedItem());
                }
            }
        });
        page.add("printers", this.services);
        page.add("settings", new JButton(new Settings()));
        page.add("lpreview", new JLabel(PrintTask.RESOURCES.getString("preview")));
        this.preview = new Preview();
        page.add("preview", new JScrollPane(this.preview));
        return page;
    }

    private JComponent createSecondPage() {
        List options = PropertyOption.introspect(this.task.getRenderer());
        for (int i = 0; i < options.size(); ++i) {
            ((Option)options.get(i)).addOptionListener(this);
        }
        return new OptionsWidget(PrintTask.RESOURCES.getString("printer"), options);
    }

    public void optionChanged(Option option) {
        this.task.invalidate();
    }

    private class Settings
    extends Action2 {
        private Settings() {
            super.setText(PrintTask.RESOURCES.getString("settings"));
            super.setTarget(PrintWidget.this);
        }

        protected void execute() {
            Point pos = PrintWidget.this.task.getOwner().getLocationOnScreen();
            PrintService choice = ServiceUI.printDialog(null, pos.x, pos.y, PrintWidget.this.task.getServices(), PrintWidget.this.task.getService(), null, PrintWidget.this.task.getAttributes());
            if (choice != null) {
                PrintWidget.this.services.setSelectedItem(choice);
                PrintWidget.this.task.invalidate();
            }
            PrintWidget.this.preview.revalidate();
            PrintWidget.this.preview.repaint();
        }
    }

    private class Preview
    extends JComponent
    implements Scrollable {
        private float padd = 0.1f;
        private float zoom = 0.25f;
        private Point dpiScreen = Options.getInstance().getDPI();

        private Preview() {
        }

        public Dimension getPreferredSize() {
            Dimension pages = PrintWidget.this.task.getPages();
            Rectangle2D page = PrintWidget.this.task.getPage(pages.width - 1, pages.height - 1, this.padd);
            return new Dimension((int)(page.getMaxX() * (double)this.dpiScreen.x * (double)this.zoom), (int)(page.getMaxY() * (double)this.dpiScreen.y * (double)this.zoom));
        }

        protected void paintComponent(Graphics g) {
            g.setColor(Color.gray);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.white);
            Printer renderer = PrintWidget.this.task.getRenderer();
            Dimension pages = PrintWidget.this.task.getPages();
            UnitGraphics ug = new UnitGraphics(g, (float)this.dpiScreen.x * this.zoom, (float)this.dpiScreen.y * this.zoom);
            Rectangle2D clip = ug.getClip();
            for (int y = 0; y < pages.height; ++y) {
                for (int x = 0; x < pages.width; ++x) {
                    Rectangle2D page = PrintWidget.this.task.getPage(x, y, this.padd);
                    Rectangle2D imageable = PrintWidget.this.task.getPrintable(page);
                    if (!clip.intersects(page)) continue;
                    ug.setColor(Color.white);
                    ug.draw(page, 0.0, 0.0, true);
                    ug.setColor(Color.gray);
                    ug.draw(String.valueOf(x + y * pages.width + 1), page.getCenterX(), page.getCenterY(), 0.5, 0.5);
                    ug.pushTransformation();
                    ug.pushClip(imageable);
                    ug.translate(imageable.getMinX(), imageable.getMinY());
                    ug.getGraphics().scale(this.zoom, this.zoom);
                    renderer.renderPage(ug.getGraphics(), new Point(x, y), new Dimension2d(imageable), this.dpiScreen, true);
                    ug.popTransformation();
                    ug.popClip();
                }
            }
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(0, 0);
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return orientation == 1 ? visibleRect.height : visibleRect.width;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 1;
        }
    }
}

