/*
 * Decompiled with CFR 0.152.
 */
package genj.print;

import genj.print.PrintRegistry;
import genj.print.PrintWidget;
import genj.print.Printer;
import genj.util.Dimension2d;
import genj.util.EnvironmentChecker;
import genj.util.Resources;
import genj.util.Trackable;
import genj.util.WordBuffer;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import genj.util.swing.ProgressWidget;
import genj.util.swing.UnitGraphics;
import genj.window.WindowManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.Action;
import javax.swing.JComponent;

public class PrintTask
extends Action2
implements Printable,
Trackable {
    static final DocFlavor FLAVOR = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
    static final Resources RESOURCES = Resources.get(PrintTask.class);
    static final Logger LOG = Logger.getLogger("genj.print");
    private JComponent owner;
    private PrintService service;
    private Printer renderer;
    private int page = 0;
    private Throwable throwable;
    private String title;
    private PrintRegistry registry;
    private String progress;
    private PrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
    private Dimension cachedPages;

    public PrintTask(Printer setRenderer, String setTitle, JComponent setOwner, PrintRegistry setRegistry) throws PrintException {
        this.setImage(new ImageIcon(this, "images/Print.gif"));
        this.renderer = setRenderer;
        this.owner = setOwner;
        this.title = RESOURCES.getString("title", setTitle);
        this.registry = setRegistry;
        this.setAsync(1);
        PrintService service = this.registry.get(this.getDefaultService());
        if (!service.isDocFlavorSupported(FLAVOR)) {
            service = this.getDefaultService();
        }
        this.setService(service);
        this.attributes.add(new JobName(this.title, null));
        this.registry.get(this.attributes);
    }

    protected PrintService getDefaultService() throws PrintException {
        PrintService service = PrintServiceLookup.lookupDefaultPrintService();
        if (service == null) {
            throw new PrintException("Couldn't find suitable printer");
        }
        if (service.isDocFlavorSupported(FLAVOR)) {
            return service;
        }
        PrintService[] suitables = PrintServiceLookup.lookupPrintServices(FLAVOR, null);
        if (suitables.length == 0) {
            throw new PrintException("Couldn't find suitable printer");
        }
        return suitables[0];
    }

    protected PrintService[] getServices() {
        return PrintServiceLookup.lookupPrintServices(FLAVOR, null);
    }

    PrintRequestAttributeSet getAttributes() {
        return this.attributes;
    }

    JComponent getOwner() {
        return this.owner;
    }

    void invalidate() {
        this.cachedPages = null;
    }

    void setService(PrintService set) {
        if (this.service == set) {
            return;
        }
        this.service = set;
        this.registry.put(this.service);
        this.invalidate();
    }

    PrintService getService() {
        return this.service;
    }

    Point getResolution() {
        return new Point(72, 72);
    }

    Rectangle2D getPrintable() {
        OrientationRequested orientation = (OrientationRequested)this.getAttribute(OrientationRequested.class);
        MediaPrintableArea printable = (MediaPrintableArea)this.getAttribute(MediaPrintableArea.class);
        Rectangle2D.Float result = new Rectangle2D.Float();
        if (orientation == OrientationRequested.LANDSCAPE || orientation == OrientationRequested.REVERSE_LANDSCAPE) {
            Dimension2D size = this.getPageSize();
            ((Rectangle2D)result).setRect(size.getWidth() - (double)printable.getHeight(25400) - (double)printable.getY(25400), printable.getX(25400), printable.getHeight(25400), printable.getWidth(25400));
        } else {
            ((Rectangle2D)result).setRect(printable.getX(25400), printable.getY(25400), printable.getWidth(25400), printable.getHeight(25400));
        }
        return result;
    }

    Rectangle2D getPrintable(Rectangle2D page) {
        Rectangle2D printable = this.getPrintable();
        return new Rectangle2D.Double(page.getMinX() + printable.getX(), page.getMinY() + printable.getY(), printable.getWidth(), printable.getHeight());
    }

    Rectangle2D getPage(int x, int y, float pad) {
        Dimension2D size = this.getPageSize();
        return new Rectangle2D.Double((double)pad + (double)x * (size.getWidth() + (double)pad), (double)pad + (double)y * (size.getHeight() + (double)pad), size.getWidth(), size.getHeight());
    }

    Dimension2D getPageSize() {
        OrientationRequested orientation = (OrientationRequested)this.getAttribute(OrientationRequested.class);
        MediaSize media = MediaSize.getMediaSizeForName((MediaSizeName)this.getAttribute(Media.class));
        Dimension2d result = new Dimension2d();
        if (orientation == OrientationRequested.LANDSCAPE || orientation == OrientationRequested.REVERSE_LANDSCAPE) {
            ((Dimension2D)result).setSize(media.getY(25400), media.getX(25400));
        } else {
            ((Dimension2D)result).setSize(media.getX(25400), media.getY(25400));
        }
        return result;
    }

    Dimension getPages() {
        if (this.cachedPages == null) {
            this.cachedPages = this.renderer.calcSize(new Dimension2d(this.getPrintable()), this.getResolution());
        }
        return this.cachedPages;
    }

    Printer getRenderer() {
        return this.renderer;
    }

    private String toString(PrintRequestAttributeSet atts) {
        WordBuffer buf = new WordBuffer(",");
        Attribute[] array = this.attributes.toArray();
        for (int i = 0; i < array.length; ++i) {
            buf.append(array[i].getClass().getName() + "=" + array[i].toString());
        }
        return buf.toString();
    }

    private PrintRequestAttribute getAttribute(Class category) {
        if (!PrintRequestAttribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException("only PrintRequestAttributes allowed");
        }
        Object result = (PrintRequestAttribute)this.attributes.get(category);
        if (result instanceof PrintRequestAttribute) {
            return result;
        }
        if (!Media.class.isAssignableFrom(category)) {
            this.getAttribute(Media.class);
        }
        if ((result = this.service.getDefaultAttributeValue(category)) == null) {
            result = this.service.getSupportedAttributeValues(category, null, this.attributes);
            if (result != null && result.getClass().isArray() && result.getClass().getComponentType() == category) {
                result = ((Object[])result)[0];
            } else {
                result = null;
                LOG.warning("No default " + category + " with " + this.toString(this.attributes));
            }
        }
        if (result != null) {
            this.attributes.add((PrintRequestAttribute)result);
        }
        return (PrintRequestAttribute)result;
    }

    protected boolean preExecute() {
        PrintWidget widget = new PrintWidget(this);
        Action[] actions = new Action[]{new Action2(RESOURCES, "print"), Action2.cancel()};
        int choice = WindowManager.getInstance(this.owner).openDialog("print", this.title, 3, widget, actions, (Component)this.owner);
        this.registry.put(this.attributes);
        if (choice != 0 || this.getPages().width == 0 || this.getPages().height == 0) {
            return false;
        }
        String file = EnvironmentChecker.getProperty((Object)this, "genj.print.file", null, "Print file output");
        if (file != null) {
            this.attributes.add(new Destination(new File(file).toURI()));
        }
        this.progress = WindowManager.getInstance(this.owner).openNonModalDialog(null, this.title, 1, new ProgressWidget(this, this.getThread()), Action2.cancelOnly(), this.owner);
        return true;
    }

    protected void execute() {
        try {
            this.service.createPrintJob().print(new SimpleDoc(this, FLAVOR, null), this.attributes);
        }
        catch (PrintException e) {
            this.throwable = e;
        }
    }

    protected void postExecute(boolean preExecuteResult) {
        WindowManager.getInstance(this.owner).close(this.progress);
        if (this.throwable != null) {
            LOG.log(Level.WARNING, "print() threw error", this.throwable);
        }
    }

    public void cancelTrackable() {
        this.cancel(true);
    }

    public int getProgress() {
        return (int)((float)this.page / (float)(this.getPages().width * this.getPages().height) * 100.0f);
    }

    public String getState() {
        return RESOURCES.getString("progress", new String[]{"" + (this.page + 1), "" + this.getPages().width * this.getPages().height});
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Dimension pages = this.getPages();
        int row = pageIndex / pages.width;
        int col = pageIndex % pages.width;
        if (col >= pages.width || row >= pages.height) {
            return 1;
        }
        this.page = pageIndex;
        Point dpi = this.getResolution();
        Rectangle2D printable = this.getPrintable();
        UnitGraphics ug = new UnitGraphics(graphics, dpi.x, dpi.y);
        ug.pushClip(0.0, 0.0, printable);
        ug.translate(printable.getX(), printable.getY());
        this.renderer.renderPage((Graphics2D)graphics, new Point(col, row), new Dimension2d(printable), dpi, false);
        return 0;
    }
}

