/*
 * Decompiled with CFR 0.152.
 */
package genj.option;

import genj.option.MultipleChoiceOption;
import genj.option.Option;
import genj.option.OptionUI;
import genj.option.OptionsWidget;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.FileChooserWidget;
import genj.util.swing.FontChooser;
import genj.util.swing.TextFieldWidget;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public abstract class PropertyOption
extends Option {
    protected String property;
    protected Object instance;
    static /* synthetic */ Class class$java$awt$Font;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static List introspect(Object instance) {
        ArrayList<Option> result = new ArrayList<Option>();
        HashSet<String> beanattrs = new HashSet<String>();
        try {
            BeanInfo info = Introspector.getBeanInfo(instance.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            for (int p = 0; p < properties.length; ++p) {
                PropertyDescriptor property = properties[p];
                try {
                    if (property.getReadMethod() == null || property.getWriteMethod() == null || !Impl.isSupportedArgument(property.getPropertyType())) continue;
                    property.getReadMethod().invoke(instance, null);
                    Option option = BeanPropertyImpl.create(instance, property);
                    result.add(option);
                    beanattrs.add(property.getName());
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
        Field[] fields = instance.getClass().getFields();
        for (int f = 0; f < fields.length; ++f) {
            int mod;
            Field field = fields[f];
            Class<?> type = field.getType();
            if (beanattrs.contains(field.getName()) || Modifier.isFinal(mod = field.getModifiers()) || Modifier.isStatic(mod)) continue;
            try {
                field.get(instance);
            }
            catch (Throwable t) {
                continue;
            }
            if (!Impl.isSupportedArgument(type)) continue;
            Option option = FieldImpl.create(instance, field);
            result.add(option);
        }
        return result;
    }

    protected PropertyOption(Object instance, String property) {
        this.instance = instance;
        this.property = property;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract void setName(String var1);

    public abstract void setToolTip(String var1);

    public String getProperty() {
        return this.property;
    }

    public String getCategory() {
        Resources resources;
        String result = super.getCategory();
        if (result == null && (result = (resources = Resources.get(this.instance)).getString("options", false)) != null) {
            super.setCategory(result);
        }
        return result;
    }

    private static class FontMapper
    extends Mapper {
        private static final String FAMILY = "family=";
        private static final String STYLE = "style=";
        private static final String SIZE = "size=";

        private FontMapper() {
        }

        protected Object toObject(Object object, Class expected) {
            if (expected != (class$java$awt$Font == null ? (class$java$awt$Font = PropertyOption.class$("java.awt.Font")) : class$java$awt$Font) || object == null || object.getClass() != (class$java$lang$String == null ? (class$java$lang$String = PropertyOption.class$("java.lang.String")) : class$java$lang$String)) {
                return super.toObject(object, expected);
            }
            String string = (String)object;
            HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
            String family = this.getAttribute(string, FAMILY);
            if (family == null) {
                family = "SansSerif";
            }
            map.put(TextAttribute.FAMILY, family);
            try {
                map.put(TextAttribute.SIZE, new Float(this.getAttribute(string, SIZE)));
            }
            catch (Throwable t) {
                map.put(TextAttribute.SIZE, new Float(11.0f));
            }
            return new Font(map);
        }

        protected String getAttribute(String string, String key) {
            char c;
            int j;
            int i = string.indexOf(key);
            if (i < 0) {
                return null;
            }
            for (j = i += key.length(); j < string.length() && (Character.isLetterOrDigit(c = string.charAt(j)) || Character.isWhitespace(c)); ++j) {
            }
            return j < i ? null : string.substring(i, j);
        }
    }

    private static class Mapper {
        private Mapper() {
        }

        private static Class box(Class type) {
            if (type == Boolean.TYPE) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertyOption.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (type == Byte.TYPE) {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyOption.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            if (type == Character.TYPE) {
                return class$java$lang$Character == null ? (class$java$lang$Character = PropertyOption.class$("java.lang.Character")) : class$java$lang$Character;
            }
            if (type == Short.TYPE) {
                return class$java$lang$Short == null ? (class$java$lang$Short = PropertyOption.class$("java.lang.Short")) : class$java$lang$Short;
            }
            if (type == Integer.TYPE) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyOption.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (type == Long.TYPE) {
                return class$java$lang$Long == null ? (class$java$lang$Long = PropertyOption.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (type == Float.TYPE) {
                return class$java$lang$Float == null ? (class$java$lang$Float = PropertyOption.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (type == Double.TYPE) {
                return class$java$lang$Double == null ? (class$java$lang$Double = PropertyOption.class$("java.lang.Double")) : class$java$lang$Double;
            }
            return type;
        }

        protected String toString(Object object) {
            return object != null ? object.toString() : "";
        }

        protected Object toObject(Object object, Class expected) {
            expected = Mapper.box(expected);
            if (object == null || object.getClass() == expected) {
                return object;
            }
            try {
                return expected.getConstructor(object.getClass()).newInstance(object);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("can't map " + object + " to expected");
            }
        }
    }

    private static class BeanPropertyImpl
    extends Impl {
        PropertyDescriptor descriptor;

        protected static Option create(Object instance, PropertyDescriptor descriptor) {
            BeanPropertyImpl result = new BeanPropertyImpl(instance, descriptor);
            if (descriptor.getPropertyType() == Integer.TYPE) {
                try {
                    final Method choices = instance.getClass().getMethod(descriptor.getReadMethod().getName() + "s", null);
                    if (choices.getReturnType().isArray()) {
                        return new MultipleChoiceOption(result){

                            public Object[] getChoicesImpl() throws Throwable {
                                return (Object[])choices.invoke(this.instance, null);
                            }
                        };
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return result;
        }

        private BeanPropertyImpl(Object instance, PropertyDescriptor property) {
            super(instance, property.getName(), property.getPropertyType());
            this.descriptor = property;
        }

        protected Object getValueImpl() throws Throwable {
            return this.descriptor.getReadMethod().invoke(this.instance, null);
        }

        protected void setValueImpl(Object value) throws Throwable {
            this.descriptor.getWriteMethod().invoke(this.instance, value);
        }
    }

    private static class FieldImpl
    extends Impl {
        protected Field field;

        protected static Option create(Object instance, Field field) {
            FieldImpl result = new FieldImpl(instance, field);
            if (field.getType() == Integer.TYPE) {
                try {
                    final Field choices = instance.getClass().getField(field.getName() + "s");
                    if (choices.getType().isArray()) {
                        return new MultipleChoiceOption(result){

                            public Object[] getChoicesImpl() throws Throwable {
                                return (Object[])choices.get(this.instance);
                            }
                        };
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return result;
        }

        private FieldImpl(Object instance, Field field) {
            super(instance, field.getName(), field.getType());
            this.field = field;
        }

        protected Object getValueImpl() throws Throwable {
            return this.field.get(this.instance);
        }

        protected void setValueImpl(Object value) throws Throwable {
            this.field.set(this.instance, value);
        }
    }

    private static abstract class Impl
    extends PropertyOption {
        protected Class type;
        private String name;
        private String toolTip;
        private Mapper mapper;

        protected Impl(Object instance, String property, Class type) {
            super(instance, property);
            this.type = type;
            this.mapper = type == (class$java$awt$Font == null ? (class$java$awt$Font = PropertyOption.class$("java.awt.Font")) : class$java$awt$Font) ? new FontMapper() : new Mapper();
        }

        public String getName() {
            if (this.name == null) {
                Resources resources = Resources.get(this.instance);
                this.name = resources.getString("option." + this.property, false);
                if (this.name == null) {
                    this.name = resources.getString(this.property, false);
                    if (this.name == null) {
                        this.name = this.property;
                    }
                }
            }
            return this.name;
        }

        public void setName(String set) {
            this.name = set;
        }

        public String getToolTip() {
            if (this.toolTip == null) {
                Resources resources = Resources.get(this.instance);
                this.toolTip = resources.getString("option." + this.property + ".tip", false);
                if (this.toolTip == null) {
                    this.toolTip = resources.getString(this.property + ".tip", false);
                }
            }
            return this.toolTip;
        }

        public void setToolTip(String set) {
            this.toolTip = set;
        }

        public void restore(Registry registry) {
            String value = registry.get(this.instance.getClass().getName() + '.' + this.getProperty(), (String)null);
            if (value != null) {
                this.setValue(value);
            }
        }

        public void persist(Registry registry) {
            Object value = this.getValue();
            if (value != null) {
                registry.put(this.instance.getClass().getName() + '.' + this.getProperty(), value.toString());
            }
        }

        public OptionUI getUI(OptionsWidget widget) {
            if ((class$java$awt$Font == null ? (class$java$awt$Font = PropertyOption.class$("java.awt.Font")) : class$java$awt$Font).isAssignableFrom(this.type)) {
                return new FontUI(this);
            }
            if (this.type == Boolean.TYPE) {
                return new BooleanUI(this);
            }
            if (this.type == (class$java$io$File == null ? (class$java$io$File = PropertyOption.class$("java.io.File")) : class$java$io$File)) {
                return new FileUI(this);
            }
            return new SimpleUI(this);
        }

        public final Object getValue() {
            try {
                return this.getValueImpl();
            }
            catch (Throwable t) {
                return null;
            }
        }

        protected abstract Object getValueImpl() throws Throwable;

        public final void setValue(Object value) {
            try {
                Object old = this.getValueImpl();
                if (old == value) {
                    return;
                }
                if (old != null && value != null && old.equals(value)) {
                    return;
                }
                this.setValueImpl(this.mapper.toObject(value, this.type));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.fireChangeNotification();
        }

        protected abstract void setValueImpl(Object var1) throws Throwable;

        private static boolean isSupportedArgument(Class type) {
            return (class$java$awt$Font == null ? (class$java$awt$Font = PropertyOption.class$("java.awt.Font")) : class$java$awt$Font).isAssignableFrom(type) || (class$java$io$File == null ? (class$java$io$File = PropertyOption.class$("java.io.File")) : class$java$io$File).isAssignableFrom(type) || (class$java$lang$String == null ? (class$java$lang$String = PropertyOption.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type);
        }
    }

    private static class SimpleUI
    extends TextFieldWidget
    implements OptionUI {
        private PropertyOption option;

        SimpleUI(PropertyOption option) {
            this.option = option;
            Object value = option.getValue();
            this.setText(value != null ? value.toString() : "");
            this.setSelectAllOnFocus(true);
            this.setColumns(12);
        }

        public String getTextRepresentation() {
            return this.getText();
        }

        public JComponent getComponentRepresentation() {
            return this;
        }

        public void endRepresentation() {
            this.option.setValue(this.getText());
        }
    }

    private static class BooleanUI
    extends JCheckBox
    implements OptionUI {
        private PropertyOption option;

        BooleanUI(PropertyOption option) {
            this.option = option;
            this.setOpaque(false);
            this.setHorizontalAlignment(2);
            Boolean value = (Boolean)option.getValue();
            if (value.booleanValue()) {
                this.setSelected(true);
            }
        }

        public String getTextRepresentation() {
            return null;
        }

        public JComponent getComponentRepresentation() {
            return this;
        }

        public void endRepresentation() {
            this.option.setValue(this.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private static class FileUI
    implements OptionUI {
        private FileChooserWidget chooser = new FileChooserWidget();
        private PropertyOption option;

        FileUI(PropertyOption option) {
            this.option = option;
            this.chooser.setFile((File)option.getValue());
        }

        public String getTextRepresentation() {
            return this.chooser.getFile().toString();
        }

        public JComponent getComponentRepresentation() {
            return this.chooser;
        }

        public void endRepresentation() {
            this.option.setValue(this.chooser.getFile());
        }
    }

    private static class FontUI
    implements OptionUI {
        private FontChooser chooser = new FontChooser();
        private PropertyOption option;

        FontUI(PropertyOption option) {
            this.option = option;
        }

        public String getTextRepresentation() {
            Font font = (Font)this.option.getValue();
            return font == null ? "..." : font.getFamily() + "," + font.getSize();
        }

        public JComponent getComponentRepresentation() {
            this.chooser.setSelectedFont((Font)this.option.getValue());
            return this.chooser;
        }

        public void endRepresentation() {
            this.option.setValue(this.chooser.getSelectedFont());
        }
    }
}

