/*
 * Decompiled with CFR 0.152.
 */
package genj.option;

import genj.option.Option;
import genj.option.OptionUI;
import genj.util.swing.ImageIcon;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import swingx.tree.AbstractTreeModel;

public class OptionsWidget
extends JPanel {
    public static final ImageIcon IMAGE = new ImageIcon(OptionsWidget.class, "images/Options.gif");
    private JTree tree;
    private Model model = new Model();
    private int widthOf1stColumn = 32;
    private String title;

    public OptionsWidget(String title) {
        this(title, null);
    }

    public OptionsWidget(String title, List options) {
        this.title = title;
        this.tree = new JTree(this.model){

            public boolean isPathEditable(TreePath path) {
                return path.getLastPathComponent() instanceof Option;
            }
        };
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new Cell());
        this.tree.setCellEditor(new Cell());
        this.tree.setEditable(true);
        this.tree.setInvokesStopCellEditing(true);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.tree));
        if (options != null) {
            this.setOptions(options);
        }
    }

    public void removeNotify() {
        this.stopEditing();
        super.removeNotify();
    }

    public void stopEditing() {
        this.tree.stopEditing();
    }

    public void setOptions(List set) {
        int i;
        this.stopEditing();
        this.tree.clearSelection();
        ListIterator it = set.listIterator();
        while (it.hasNext()) {
            Option option = (Option)it.next();
            if (option.getUI(this) != null) continue;
            it.remove();
        }
        FontRenderContext ctx = new FontRenderContext(null, false, false);
        Font font = this.tree.getFont();
        this.widthOf1stColumn = 0;
        for (i = 0; i < set.size(); ++i) {
            Option option = (Option)set.get(i);
            this.widthOf1stColumn = Math.max(this.widthOf1stColumn, 4 + (int)Math.ceil(font.getStringBounds(option.getName(), ctx).getWidth()));
        }
        this.model.setOptions(set);
        for (i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.doLayout();
    }

    public WindowManager getWindowManager() {
        return WindowManager.getInstance(this);
    }

    private class Model
    extends AbstractTreeModel {
        private List categories = new ArrayList();
        private Map cat2options = new HashMap();

        private Model() {
        }

        protected Object getParent(Object node) {
            throw new IllegalArgumentException();
        }

        private List getCategory(String cat) {
            ArrayList result;
            if (cat == null) {
                cat = OptionsWidget.this.title;
            }
            if ((result = (ArrayList)this.cat2options.get(cat)) == null) {
                result = new ArrayList();
                this.cat2options.put(cat, result);
                this.categories.add(cat);
            }
            return result;
        }

        private void setOptions(List set) {
            this.cat2options.clear();
            this.categories.clear();
            for (int i = 0; i < set.size(); ++i) {
                Option option = (Option)set.get(i);
                this.getCategory(option.getCategory()).add(option);
            }
            this.fireTreeStructureChanged(this, new Object[]{this}, null, null);
        }

        public Object getRoot() {
            return this;
        }

        public int getChildCount(Object parent) {
            if (parent == this) {
                return this.categories.size();
            }
            return this.getCategory((String)parent).size();
        }

        public boolean isLeaf(Object node) {
            return node instanceof Option;
        }

        public Object getChild(Object parent, int index) {
            if (parent == this) {
                return this.categories.get(index);
            }
            return this.getCategory((String)parent).get(index);
        }

        public int getIndexOfChild(Object parent, Object child) {
            throw new IllegalArgumentException();
        }
    }

    private class Cell
    extends AbstractCellEditor
    implements TreeCellRenderer,
    TreeCellEditor {
        private OptionUI optionUi;
        private JPanel panel = new JPanel(){

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (ks.getKeyCode() == 10) {
                    Cell.this.stopCellEditing();
                }
                if (ks.getKeyCode() == 27) {
                    Cell.this.cancelCellEditing();
                }
                return true;
            }
        };
        private JLabel labelForName = new JLabel();
        private JLabel labelForValue = new JLabel();

        private Cell() {
            this.panel.setOpaque(false);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.labelForName, "West");
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof Option) {
                return this.assemblePanel((Option)value, false);
            }
            return new JLabel(value.toString());
        }

        private JPanel assemblePanel(Option option, boolean forceUI) {
            JComponent compForValue;
            if (this.panel.getComponentCount() > 1) {
                this.panel.remove(1);
            }
            this.optionUi = option.getUI(OptionsWidget.this);
            this.labelForName.setText(option.getName());
            this.labelForName.setPreferredSize(new Dimension(OptionsWidget.this.widthOf1stColumn, 16));
            String text = this.optionUi.getTextRepresentation();
            if (text != null && !forceUI) {
                this.labelForValue.setText(text);
                compForValue = this.labelForValue;
            } else {
                compForValue = this.optionUi.getComponentRepresentation();
            }
            this.panel.add((Component)compForValue, "Center");
            this.panel.setToolTipText(option.getToolTip());
            return this.panel;
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            return this.assemblePanel((Option)value, true);
        }

        public Object getCellEditorValue() {
            return null;
        }

        public void cancelCellEditing() {
            this.optionUi = null;
            super.cancelCellEditing();
        }

        public boolean stopCellEditing() {
            if (this.optionUi != null) {
                this.optionUi.endRepresentation();
            }
            return super.stopCellEditing();
        }
    }
}

