/*
 * Decompiled with CFR 0.152.
 */
package genj.nav;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Indi;
import genj.util.GridBagHelper;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import genj.util.swing.PopupWidget;
import genj.view.ContextSelectionEvent;
import genj.view.ViewContext;
import genj.window.WindowBroadcastEvent;
import genj.window.WindowBroadcastListener;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import spin.Spin;

public class NavigatorView
extends JPanel
implements WindowBroadcastListener {
    private static Resources resources = Resources.get(NavigatorView.class);
    private static final String FATHER = "father";
    private static final String MOTHER = "mother";
    private static final String YSIBLING = "ysibling";
    private static final String OSIBLING = "osibling";
    private static final String PARTNER = "partner";
    private static final String CHILD = "child";
    private static final ImageIcon imgYSiblings = new ImageIcon(NavigatorView.class, "YSiblings.gif");
    private static final ImageIcon imgOSiblings = new ImageIcon(NavigatorView.class, "OSiblings.gif");
    private static final ImageIcon imgChildren = new ImageIcon(NavigatorView.class, "Children.gif");
    private static final ImageIcon imgFather = Indi.IMG_MALE;
    private static final ImageIcon imgMother = Indi.IMG_FEMALE;
    private static final ImageIcon imgMPartner = Indi.IMG_MALE;
    private static final ImageIcon imgFPartner = Indi.IMG_FEMALE;
    private GedcomListener callback = new GedcomListenerAdapter(){

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (NavigatorView.this.current == entity) {
                NavigatorView.this.setCurrentEntity(gedcom.getFirstEntity("INDI"));
            } else {
                NavigatorView.this.setCurrentEntity(NavigatorView.this.current);
            }
        }
    };
    private JLabel labelCurrent;
    private JLabel labelSelf;
    private Indi current;
    private Map key2jumps = new HashMap();
    private Map key2popup = new HashMap();
    private Gedcom gedcom;
    private Registry registry;

    public NavigatorView(String title, Gedcom gedcom, Registry registry) {
        this.gedcom = gedcom;
        this.registry = registry;
        this.setLayout(new BorderLayout());
        this.labelCurrent = new JLabel();
        this.labelCurrent.setBorder(BorderFactory.createTitledBorder(Gedcom.getName("INDI", false)));
        this.add((Component)this.labelCurrent, "North");
        this.add((Component)new JScrollPane(this.createPopupPanel()), "Center");
        Entity entity = gedcom.getEntity(registry.get("entity", (String)null));
        if (entity == null) {
            entity = gedcom.getFirstEntity("INDI");
        }
        if (entity != null) {
            this.setCurrentEntity(entity);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.gedcom.addGedcomListener((GedcomListener)Spin.over(this.callback));
    }

    public void removeNotify() {
        this.gedcom.removeGedcomListener((GedcomListener)Spin.over(this.callback));
        if (this.current != null) {
            this.registry.put("entity", this.current.getId());
        }
        super.removeNotify();
    }

    public Dimension getPreferredSize() {
        return new Dimension(140, 200);
    }

    public boolean handleBroadcastEvent(WindowBroadcastEvent event) {
        ContextSelectionEvent cse = ContextSelectionEvent.narrow(event, this.gedcom);
        this.setCurrentEntity(cse.getContext().getEntity());
        return true;
    }

    public void setCurrentEntity(Entity e) {
        if (e == this.current || e != null && !(e instanceof Indi)) {
            return;
        }
        this.key2jumps.clear();
        this.current = (Indi)e;
        if (this.current == null) {
            this.setJump(FATHER, null);
            this.setJump(MOTHER, null);
            this.setJump(OSIBLING, null);
            this.setJumps(PARTNER, null);
            this.setJump(YSIBLING, null);
            this.setJumps(CHILD, null);
            this.labelCurrent.setText("n/a");
            this.labelCurrent.setIcon(null);
        } else {
            this.setJump(FATHER, this.current.getBiologicalFather());
            this.setJump(MOTHER, this.current.getBiologicalMother());
            this.setJumps(OSIBLING, this.current.getOlderSiblings());
            this.setJumps(PARTNER, this.current.getPartners());
            this.setJumps(YSIBLING, this.current.getYoungerSiblings());
            this.setJumps(CHILD, this.current.getChildren());
            this.labelCurrent.setText(this.current.toString());
            this.labelCurrent.setIcon(this.current.getImage(false));
            PopupWidget partner = this.getPopup(PARTNER);
            switch (this.current.getSex()) {
                case 2: {
                    this.labelSelf.setIcon(imgFPartner);
                    partner.setIcon(imgMPartner);
                    break;
                }
                case 1: {
                    this.labelSelf.setIcon(imgMPartner);
                    partner.setIcon(imgFPartner);
                }
            }
        }
    }

    private PopupWidget getPopup(String key) {
        return (PopupWidget)this.key2popup.get(key);
    }

    private void setJump(String key, Indi i) {
        Indi[] indiArray;
        if (i == null) {
            indiArray = new Indi[]{};
        } else {
            Indi[] indiArray2 = new Indi[1];
            indiArray = indiArray2;
            indiArray2[0] = i;
        }
        this.setJumps(key, indiArray);
    }

    private void setJumps(String key, Indi[] is) {
        PopupWidget popup = this.getPopup(key);
        ArrayList<Jump> jumps = new ArrayList<Jump>();
        if (is == null || is.length == 0) {
            popup.setEnabled(false);
        } else {
            popup.setEnabled(true);
            for (int i = 0; i < is.length; ++i) {
                jumps.add(new Jump(is[i]));
            }
        }
        popup.setActions(jumps);
    }

    private JComponent createPopup(String key, ImageIcon i) {
        PopupWidget result = new PopupWidget();
        result.setIcon(i);
        result.setFocusPainted(false);
        result.setFireOnClick(true);
        result.setFocusable(false);
        result.setEnabled(false);
        result.setToolTipText(resources.getString("tip." + key));
        this.key2popup.put(key, result);
        return result;
    }

    private JPanel createPopupPanel() {
        String title = resources.getString("nav.navigate.title");
        TitledBorder border = BorderFactory.createTitledBorder(title);
        PopupPanel result = new PopupPanel();
        result.setBorder(border);
        GridBagHelper gh = new GridBagHelper(result);
        JComponent popFather = this.createPopup(FATHER, imgFather);
        JComponent popMother = this.createPopup(MOTHER, imgMother);
        JComponent popOSibling = this.createPopup(OSIBLING, imgOSiblings);
        JComponent popPartner = this.createPopup(PARTNER, imgMPartner);
        JComponent popYSibling = this.createPopup(YSIBLING, imgYSiblings);
        JComponent popChildren = this.createPopup(CHILD, imgChildren);
        this.labelSelf = new JLabel(Gedcom.getEntityImage("INDI"), 0);
        popPartner.setPreferredSize(popOSibling.getPreferredSize());
        popFather.setPreferredSize(popOSibling.getPreferredSize());
        popMother.setPreferredSize(popOSibling.getPreferredSize());
        this.labelSelf.setPreferredSize(popOSibling.getPreferredSize());
        gh.add(popFather, 4, 1, 1, 1);
        gh.add(popMother, 5, 1, 1, 1);
        gh.add(popOSibling, 1, 2, 2, 1, 0, new Insets(12, 0, 12, 12));
        gh.add(this.labelSelf, 4, 2, 1, 1);
        gh.add(popPartner, 5, 2, 1, 1);
        gh.add(popYSibling, 7, 2, 2, 1, 0, new Insets(12, 12, 12, 0));
        gh.add(popChildren, 4, 3, 2, 1);
        return result;
    }

    private class Jump
    extends Action2 {
        private Indi target;

        private Jump(Indi taRget) {
            this.target = taRget;
            this.setText(this.target.toString());
            this.setImage(this.target.getImage(false));
        }

        protected void execute() {
            NavigatorView.this.setCurrentEntity(this.target);
            WindowManager.broadcast(new ContextSelectionEvent(new ViewContext(this.target), NavigatorView.this));
        }
    }

    private class PopupPanel
    extends JPanel {
        private PopupPanel() {
        }

        protected void paintChildren(Graphics g) {
            g.setColor(Color.lightGray);
            this.line(g, NavigatorView.this.getPopup(NavigatorView.MOTHER), NavigatorView.this.getPopup(NavigatorView.OSIBLING));
            this.line(g, NavigatorView.this.getPopup(NavigatorView.MOTHER), NavigatorView.this.getPopup(NavigatorView.YSIBLING));
            this.line(g, NavigatorView.this.getPopup(NavigatorView.MOTHER), NavigatorView.this.labelSelf);
            this.line(g, NavigatorView.this.getPopup(NavigatorView.PARTNER), NavigatorView.this.getPopup(NavigatorView.CHILD));
            super.paintChildren(g);
        }

        private void line(Graphics g, JComponent c1, JComponent c2) {
            Rectangle a = c1.getBounds();
            Rectangle b = c2.getBounds();
            int y = (a.y + a.height + b.y) / 2;
            int x = a.x;
            g.drawLine(x, a.y + a.height, x, y);
            x = b.x + b.width / 2;
            g.drawLine(x, y, x, b.y);
            g.drawLine(a.x, y, x, y);
        }
    }
}

