/*
 * Decompiled with CFR 0.152.
 */
package genj.lnf;

import genj.util.EnvironmentChecker;
import genj.util.Registry;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class LnF {
    private static Logger LOG = Logger.getLogger("genj.lnf");
    private static final String LNF_PROPERTIES = "lnf.properties";
    private static final String LNF_DIR = "./lnf";
    private static LnF[] instances;
    private String name;
    private String type;
    private String archive;
    private String url;
    private String version;
    private String theme;
    private ClassLoader cl;
    private LookAndFeel instance;

    public static LnF[] getLnFs() {
        if (instances != null) {
            return instances;
        }
        ArrayList<LnF> result = new ArrayList<LnF>();
        result.add(new LnF("System Default", UIManager.getSystemLookAndFeelClassName(), "", "", null, null));
        try {
            Registry r = new Registry(new FileInputStream(new File(LnF.getLnFDir(), LNF_PROPERTIES)));
            int num = r.get("lnf.count", 0);
            for (int d = 0; d < num; ++d) {
                String[] ts;
                String prefix = "lnf." + (d + 1);
                String name = r.get(prefix + ".name", "");
                String type = r.get(prefix + ".type", "");
                String url = r.get(prefix + ".url", "");
                String version = r.get(prefix + ".version", "");
                String archive = r.get(prefix + ".jar", (String)null);
                if (name.length() == 0) continue;
                int i = name.indexOf(40);
                if (i > 0) {
                    name = name.substring(0, i);
                }
                if ((ts = r.get(prefix + ".themes", new String[0])).length > 0) {
                    for (int t = 0; t < ts.length; ++t) {
                        result.add(new LnF(name, type, url, version, archive, ts[t]));
                    }
                    continue;
                }
                result.add(new LnF(name, type, url, version, archive, null));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        instances = result.toArray(new LnF[result.size()]);
        return instances;
    }

    private static String getLnFDir() {
        return EnvironmentChecker.getProperty((Object)LnF.class, new String[]{"genj.lnf.dir"}, LNF_DIR, "read lnf.properties");
    }

    private LnF(String name, String type, String url, String version, String archive, String theme) {
        this.name = name;
        this.type = type;
        this.url = url;
        this.version = version;
        this.archive = archive;
        this.theme = theme;
        LOG.info("Found Look&Feel " + name + " version=" + version + " url=" + url + " archive=" + archive + " theme=" + theme);
    }

    private LookAndFeel getInstance() throws Exception {
        if (this.instance == null) {
            this.instance = (LookAndFeel)this.cl.loadClass(this.type).newInstance();
        }
        if (this.instance.getClass() == MetalLookAndFeel.class) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        }
        if (this.theme != null) {
            String themejar = new File(LnF.getLnFDir(), this.getTheme()).getAbsolutePath();
            System.setProperty("skinlf.themepack", themejar);
        }
        return this.instance;
    }

    private ClassLoader getCL() throws MalformedURLException {
        if (this.cl != null) {
            return this.cl;
        }
        if (this.archive == null) {
            this.cl = this.getClass().getClassLoader();
        } else {
            URL urlArchive = new URL("file", "", new File(LnF.getLnFDir(), this.archive).getAbsolutePath());
            this.cl = new URLClassLoader(new URL[]{urlArchive}, this.getClass().getClassLoader());
        }
        return this.cl;
    }

    public String toString() {
        if (this.theme == null) {
            return this.name;
        }
        String s = this.theme;
        int i = s.lastIndexOf(47);
        if (i > 0) {
            s = s.substring(i + 1);
        }
        return this.name + '(' + s + ')';
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getArchive() {
        return this.archive;
    }

    public String getTheme() {
        return this.theme;
    }

    public boolean apply(final List rootComponents) {
        String prefix = "Look and feel #" + this + " of type " + this.type;
        try {
            UIManager.getLookAndFeelDefaults().put("ClassLoader", this.getCL());
            UIManager.getDefaults().put("ClassLoader", this.getCL());
            UIManager.setLookAndFeel(this.getInstance());
        }
        catch (ClassNotFoundException cnfe) {
            LOG.warning(prefix + " is not accessible (ClassNotFoundException)");
            return false;
        }
        catch (ClassCastException cce) {
            LOG.warning(prefix + " is not a valid LookAndFeel (ClassCastException)");
            return false;
        }
        catch (MalformedURLException mue) {
            LOG.warning(prefix + " doesn't point to a valid archive (MalformedURLException)");
            return false;
        }
        catch (UnsupportedLookAndFeelException e) {
            LOG.warning(prefix + " is not supported on this platform (UnsupportedLookAndFeelException)");
            return false;
        }
        catch (Throwable t) {
            LOG.warning(prefix + " couldn't be set (" + t.getClass() + ")");
            return false;
        }
        if (rootComponents != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Iterator e = rootComponents.iterator();
                    while (e.hasNext()) {
                        try {
                            SwingUtilities.updateComponentTreeUI((Component)e.next());
                        }
                        catch (Throwable throwable) {}
                    }
                }
            });
        }
        return true;
    }
}

