/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.gedcom.Entity;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class PropertyWriter {
    boolean useIndents = false;
    private int lines = 0;
    private BufferedWriter out;

    public PropertyWriter(Writer out, boolean useIndents) {
        this.out = new BufferedWriter(out);
        this.useIndents = useIndents;
    }

    public int write(int level, Property prop) throws IOException {
        this.writeProperty(level, prop);
        this.out.flush();
        return this.lines;
    }

    public int getLines() {
        return this.lines;
    }

    protected String getValue(Property prop) throws IOException {
        return prop.getValue();
    }

    protected void writeProperty(int level, Property prop) throws IOException {
        if (prop.isTransient()) {
            return;
        }
        if (prop instanceof MultiLineProperty) {
            this.writeMultiLine(level, prop);
        } else {
            this.writeLine(level, this.getTag(prop), this.getValue(prop));
        }
        int num = prop.getNoOfProperties();
        for (int i = 0; i < num; ++i) {
            this.writeProperty(level + 1, prop.getProperty(i));
        }
    }

    protected String getTag(Property prop) {
        String xref;
        if (prop instanceof Entity && (xref = ((Entity)prop).getId()).length() > 0) {
            return '@' + xref + "@ " + prop.getTag();
        }
        return prop.getTag();
    }

    private void writeMultiLine(int level, Property prop) throws IOException {
        MultiLineProperty.Iterator lines = ((MultiLineProperty)((Object)prop)).getLineIterator();
        lines.setValue(this.getValue(prop));
        this.writeLine(level + lines.getIndent(), this.getTag(prop), lines.getValue());
        while (lines.next()) {
            this.writeLine(level + lines.getIndent(), lines.getTag(), lines.getValue());
        }
    }

    private void writeLine(int level, String tag, String value) throws IOException {
        if (this.useIndents) {
            for (int i = 0; i < level; ++i) {
                this.out.write(32);
            }
        } else {
            this.out.write(Integer.toString(level));
            this.out.write(32);
        }
        this.out.write(tag);
        if (value != null && value.length() > 0) {
            this.out.write(32);
            this.out.write(value);
        }
        this.out.newLine();
        ++this.lines;
    }
}

