/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.gedcom.GedcomException;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.io.GedcomFormatException;
import genj.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PropertyReader {
    protected static final Resources RESOURCES = Resources.get("genj.io");
    protected boolean useIndents = false;
    protected int lines = 0;
    protected String line = null;
    protected Collection collectXRefs;
    protected boolean isMerge = false;
    protected int level;
    protected String tag;
    protected String xref;
    protected String value;
    protected BufferedReader in;

    public PropertyReader(Reader in, Collection collectXRefs, boolean useIndents) {
        this(new BufferedReader(in), collectXRefs, useIndents);
    }

    public PropertyReader(BufferedReader in, Collection collectXRefs, boolean useIndents) {
        this.in = in;
        this.useIndents = useIndents;
        this.collectXRefs = collectXRefs;
    }

    public int getLines() {
        return this.lines;
    }

    public void read(Property prop) throws IOException {
        this.read(prop, -1);
    }

    public void read(Property prop, int index) throws IOException {
        this.readProperties(prop, 0, index);
        if (this.line != null) {
            this.line = null;
            this.in.reset();
        }
    }

    public void setMerge(boolean set) {
        this.isMerge = set;
    }

    protected void readProperties(Property prop, int currentLevel, int pos) throws IOException {
        if (prop instanceof MultiLineProperty) {
            MultiLineProperty.Collector collector = ((MultiLineProperty)((Object)prop)).getLineCollector();
            while (this.readLine(false) && this.level >= currentLevel + 1 && collector.append(this.level - currentLevel, this.tag, this.value)) {
                this.line = null;
            }
            prop.setValue(collector.getValue());
        }
        while (this.readLine(false)) {
            if (this.level < currentLevel + 1) {
                return;
            }
            this.line = null;
            if (this.level > currentLevel + 1) {
                this.trackBadLevel(this.level, prop);
                while (this.level - 1 > currentLevel++) {
                    prop = prop.addProperty("_TAG", "");
                }
            }
            int lineNoForChild = this.lines;
            Property child = this.addProperty(prop, this.tag, this.value, pos);
            this.readProperties(child, currentLevel + 1, 0);
            if (child instanceof PropertyXRef) {
                this.link((PropertyXRef)child, lineNoForChild);
            }
            if (pos < 0) continue;
            ++pos;
        }
        return;
    }

    protected Property addProperty(Property prop, String tag, String value, int pos) {
        Property child;
        if (this.isMerge && (child = prop.getProperty(tag, false)) != null && prop.getMetaProperty().getNested(tag, false).isSingleton() && !(child instanceof PropertyXRef)) {
            child.setValue(value);
            return child;
        }
        try {
            return prop.addProperty(tag, value, pos);
        }
        catch (GedcomException e) {
            Property fallback = prop.addSimpleProperty(tag, value, pos);
            this.trackBadProperty(fallback, e.getMessage());
            return fallback;
        }
    }

    protected boolean readLine(boolean consume) throws IOException {
        if (this.line == null) {
            this.in.mark(256);
            while (this.line == null) {
                this.line = this.in.readLine();
                if (this.line == null) {
                    return false;
                }
                ++this.lines;
                if (this.line.trim().length() != 0) continue;
                this.trackEmptyLine();
                this.line = null;
            }
            StringTokenizer tokens = new StringTokenizer(this.line, " \t");
            try {
                try {
                    if (this.useIndents) {
                        this.level = 0;
                        while (this.line.charAt(this.level) == ' ') {
                            ++this.level;
                        }
                        ++this.level;
                    } else {
                        this.level = Integer.parseInt(tokens.nextToken(), 10);
                    }
                }
                catch (StringIndexOutOfBoundsException sioobe) {
                    throw new GedcomFormatException(RESOURCES.getString("read.error.emptyline"), this.lines);
                }
                catch (NumberFormatException nfe) {
                    throw new GedcomFormatException(RESOURCES.getString("read.error.nonumber"), this.lines);
                }
                this.tag = tokens.hasMoreTokens() ? tokens.nextToken() : "_TAG";
                if (this.level == 0 && this.tag.startsWith("@")) {
                    if (!this.tag.endsWith("@") || this.tag.length() <= 2) {
                        throw new GedcomFormatException(RESOURCES.getString("read.error.invalidid"), this.lines);
                    }
                    this.xref = this.tag.substring(1, this.tag.length() - 1);
                    this.tag = tokens.nextToken();
                } else {
                    this.xref = "";
                }
                if (tokens.hasMoreElements()) {
                    this.value = tokens.nextToken("\n");
                    if (this.value.startsWith(" ")) {
                        this.value = this.value.substring(1);
                    }
                } else {
                    this.value = "";
                }
            }
            catch (NoSuchElementException ex) {
                throw new GedcomFormatException(RESOURCES.getString("read.error.cantparse"), this.lines);
            }
            this.tag = this.tag.intern();
        }
        if (consume) {
            this.line = null;
        }
        return true;
    }

    protected void link(PropertyXRef xref, int line) {
        if (this.collectXRefs != null) {
            this.collectXRefs.add(xref);
        } else {
            try {
                xref.link();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void trackEmptyLine() {
    }

    protected void trackBadLevel(int level, Property parent) {
    }

    protected void trackBadProperty(Property property, String message) {
    }
}

