/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.Version;
import genj.crypto.Enigma;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.time.PointInTime;
import genj.io.AnselCharset;
import genj.io.Filter;
import genj.io.GedcomEncodingException;
import genj.io.GedcomIOException;
import genj.io.PropertyWriter;
import genj.util.Trackable;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class GedcomWriter
implements Trackable {
    private static Logger LOG = Logger.getLogger("genj.io");
    private Gedcom gedcom;
    private BufferedWriter out;
    private String file;
    private String date;
    private String time;
    private int total;
    private int line;
    private int entity;
    private boolean cancel = false;
    private Filter[] filters = new Filter[0];
    private Enigma enigma = null;
    private String password;
    private String encoding;

    public GedcomWriter(Gedcom ged, String name, String enc, OutputStream stream) {
        Calendar now = Calendar.getInstance();
        this.gedcom = ged;
        this.password = this.gedcom.getPassword();
        this.encoding = enc != null ? enc : ged.getEncoding();
        this.file = name;
        this.line = 0;
        this.date = PointInTime.getNow().getValue();
        this.time = new SimpleDateFormat("HH:mm:ss").format(now.getTime());
        CharsetEncoder encoder = this.getCharset(this.encoding).newEncoder();
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.out = new BufferedWriter(new OutputStreamWriter(stream, encoder));
    }

    private Charset getCharset(String encoding) {
        try {
            if ("UNICODE".equals(encoding)) {
                return Charset.forName("UTF-16BE");
            }
            if ("UTF-8".equals(encoding)) {
                return Charset.forName("UTF-8");
            }
            if ("ASCII".equals(encoding)) {
                return Charset.forName("ISO-8859-1");
            }
            if ("LATIN1".equals(encoding)) {
                return Charset.forName("ISO-8859-1");
            }
            if ("ANSI".equals(encoding)) {
                return Charset.forName("Windows-1252");
            }
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        if (!"ANSEL".equals(encoding)) {
            encoding = null;
            LOG.warning("Couldn't resolve charset for encoding " + encoding);
        }
        return new AnselCharset();
    }

    public void cancelTrackable() {
        this.cancel = true;
    }

    public int getProgress() {
        if (this.entity == 0) {
            return 0;
        }
        return this.entity * 100 / this.total;
    }

    public String getState() {
        return this.line + " Lines & " + this.entity + " Entities";
    }

    public void setFilters(Filter[] fs) {
        if (fs == null) {
            fs = new Filter[]{};
        }
        this.filters = fs;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    public int getLines() {
        return this.line;
    }

    public void write() throws GedcomIOException {
        if (this.gedcom == null) {
            throw new IllegalStateException("can't call write() twice");
        }
        List ents = this.gedcom.getEntities();
        this.total = ents.size();
        try {
            this.writeHeader();
            this.writeEntities(ents);
            this.writeTail();
            this.out.close();
        }
        catch (GedcomIOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            throw new GedcomIOException("Error while writing / " + ex.getMessage(), this.line);
        }
        finally {
            this.gedcom = null;
        }
    }

    private void writeLine(String line) throws IOException {
        this.out.write(line);
        this.out.newLine();
        ++this.line;
    }

    private void writeHeader() throws IOException {
        this.writeLine("0 HEAD");
        this.writeLine("1 SOUR GENJ");
        this.writeLine("2 VERS " + Version.getInstance());
        this.writeLine("2 NAME GenealogyJ");
        this.writeLine("2 CORP Nils Meier");
        this.writeLine("3 ADDR http://genj.sourceforge.net");
        this.writeLine("1 DEST ANY");
        this.writeLine("1 DATE " + this.date);
        this.writeLine("2 TIME " + this.time);
        if (this.gedcom.getSubmitter() != null) {
            this.writeLine("1 SUBM @" + this.gedcom.getSubmitter().getId() + '@');
        }
        this.writeLine("1 FILE " + this.file);
        this.writeLine("1 GEDC");
        this.writeLine("2 VERS " + this.gedcom.getGrammar().getVersion());
        this.writeLine("2 FORM Lineage-Linked");
        this.writeLine("1 CHAR " + this.encoding);
        if (this.gedcom.getLanguage() != null) {
            this.writeLine("1 LANG " + this.gedcom.getLanguage());
        }
        if (this.gedcom.getPlaceFormat().length() > 0) {
            this.writeLine("1 PLAC");
            this.writeLine("2 FORM " + this.gedcom.getPlaceFormat());
        }
    }

    private void writeEntities(Collection ents) throws IOException {
        Iterator it = ents.iterator();
        while (it.hasNext()) {
            if (this.cancel) {
                throw new GedcomIOException("Operation cancelled", this.line);
            }
            Entity e = (Entity)it.next();
            try {
                this.line += new EntityWriter().write(0, e);
            }
            catch (UnmappableCharacterException unme) {
                throw new GedcomEncodingException(e, this.gedcom.getEncoding());
            }
            ++this.entity;
        }
    }

    private void writeTail() throws IOException {
        this.writeLine("0 TRLR");
    }

    private class EntityWriter
    extends PropertyWriter {
        EntityWriter() {
            super(GedcomWriter.this.out, false);
        }

        protected void writeProperty(int level, Property prop) throws IOException {
            PropertyXRef p;
            Entity target = null;
            if (prop instanceof PropertyXRef && (p = ((PropertyXRef)prop).getTarget()) != null) {
                target = p.getEntity();
            }
            for (int f = 0; f < GedcomWriter.this.filters.length; ++f) {
                if (!GedcomWriter.this.filters[f].checkFilter(prop)) {
                    return;
                }
                if (target == null || GedcomWriter.this.filters[f].checkFilter(target)) continue;
                return;
            }
            super.writeProperty(level, prop);
        }

        protected String getValue(Property prop) throws IOException {
            return prop.isPrivate() ? this.encrypt(prop.getValue()) : super.getValue(prop);
        }

        private String encrypt(String value) throws IOException {
            if (value.length() == 0) {
                return value;
            }
            if (GedcomWriter.this.enigma == null) {
                if (GedcomWriter.this.password == "PASSWORD_UNKNOWN") {
                    return value;
                }
                if (GedcomWriter.this.password.length() == 0) {
                    return value;
                }
                if (GedcomWriter.this.password == "PASSWORD_NOT_SET") {
                    throw new IOException("Password not set - needed for encryption");
                }
                GedcomWriter.this.enigma = Enigma.getInstance(GedcomWriter.this.password);
                if (GedcomWriter.this.enigma == null) {
                    throw new IOException("Encryption not available");
                }
            }
            return GedcomWriter.this.enigma.encrypt(value);
        }
    }
}

