/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.crypto.Enigma;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Submitter;
import genj.io.AnselCharset;
import genj.io.GedcomEncryptionException;
import genj.io.GedcomFormatException;
import genj.io.GedcomIOException;
import genj.io.PropertyReader;
import genj.util.EnvironmentChecker;
import genj.util.Origin;
import genj.util.Resources;
import genj.util.Trackable;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GedcomReader
implements Trackable {
    private static final Resources RESOURCES = Resources.get("genj.io");
    private static Logger LOG = Logger.getLogger("genj.io");
    private static final int ENTITY_AVG_SIZE = 150;
    private static final int READHEADER = 0;
    private static final int READENTITIES = 1;
    private static final int LINKING = 2;
    private Gedcom gedcom;
    private int progress;
    private int entity = 0;
    private int state;
    private int length;
    private String gedcomLine;
    private ArrayList lazyLinks = new ArrayList();
    private String tempSubmitter;
    private boolean cancel = false;
    private Thread worker;
    private Object lock = new Object();
    private EntityReader reader;
    private MeteredInputStream meter;
    private Enigma enigma;
    private List warnings = new ArrayList(128);
    static /* synthetic */ Class class$genj$gedcom$Entity;

    public GedcomReader(InputStream in) throws IOException {
        this.init(new Gedcom(), in);
    }

    public GedcomReader(Origin origin) throws IOException {
        LOG.info("Initializing reader for " + origin);
        this.init(new Gedcom(origin), origin.open());
    }

    private void init(Gedcom ged, InputStream in) throws IOException {
        String charsetName;
        SniffedInputStream sniffer = new SniffedInputStream(in);
        Charset charset = sniffer.getCharset();
        String encoding = sniffer.getEncoding();
        if (sniffer.warning != null) {
            this.warnings.add(new Warning(0, sniffer.warning, ged));
        }
        if ((charsetName = EnvironmentChecker.getProperty((Object)this, "genj.gedcom.charset", null, "checking for forced charset for read of " + ged.getName())) != null) {
            try {
                charset = Charset.forName(charsetName);
                encoding = "UTF-8";
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Can't force charset " + charset, t);
            }
        }
        this.init(ged, sniffer, charset, encoding);
    }

    private void init(Gedcom ged, InputStream in, Charset charset, String encoding) throws IOException {
        this.length = in.available();
        this.gedcom = ged;
        this.gedcom.setEncoding(encoding);
        this.meter = new MeteredInputStream(in);
        this.reader = new EntityReader(new InputStreamReader((InputStream)this.meter, charset));
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException("Password can't be NULL");
        }
        this.gedcom.setPassword(password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTrackable() {
        this.cancel = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.worker != null) {
                this.worker.interrupt();
            }
        }
    }

    public int getProgress() {
        if (this.state == 1 && this.length > 0) {
            this.progress = (int)Math.min(100L, this.meter.getCount() * 100L / (long)this.length);
        }
        return this.progress;
    }

    public String getState() {
        switch (this.state) {
            case 0: {
                return RESOURCES.getString("progress.read.header");
            }
            default: {
                return RESOURCES.getString("progress.read.entities", new String[]{"" + this.reader.getLines(), "" + this.entity});
            }
            case 2: 
        }
        return RESOURCES.getString("progress.read.linking");
    }

    public List getWarnings() {
        return this.warnings;
    }

    public int getLines() {
        return this.reader.getLines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Gedcom read() throws GedcomIOException, GedcomFormatException {
        if (this.gedcom == null) {
            throw new IllegalStateException("can't call read() twice");
        }
        Object object = this.lock;
        synchronized (object) {
            this.worker = Thread.currentThread();
        }
        try {
            this.readGedcom();
            object = this.gedcom;
            return object;
        }
        catch (GedcomIOException gex) {
            throw gex;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "unexpected throwable", t);
            throw new GedcomIOException(t.toString(), this.reader.getLines());
        }
        finally {
            try {
                this.reader.in.close();
            }
            catch (Throwable t) {}
            Object object2 = this.lock;
            synchronized (object2) {
                this.worker = null;
            }
            this.gedcom = null;
            this.lazyLinks.clear();
        }
    }

    private void readGedcom() throws IOException {
        long start = System.currentTimeMillis();
        this.readHeader();
        ++this.state;
        long header = System.currentTimeMillis();
        while (this.reader.readEntity() != null) {
        }
        long records = System.currentTimeMillis();
        ++this.state;
        if (this.tempSubmitter.length() > 0) {
            try {
                Submitter sub = (Submitter)this.gedcom.getEntity("SUBM", this.tempSubmitter.replace('@', ' ').trim());
                this.gedcom.setSubmitter(sub);
            }
            catch (IllegalArgumentException t) {
                this.warnings.add(new Warning(0, RESOURCES.getString("read.warn.setsubmitter", this.tempSubmitter), this.gedcom));
            }
        }
        this.linkReferences();
        long linking = System.currentTimeMillis();
        Collections.sort(this.warnings);
        long total = System.currentTimeMillis();
        LOG.log(Level.FINE, this.gedcom.getName() + " loaded in " + (total - start) / 1000L + "s (header " + (header - start) / 1000L + "s, records " + (records - header) / 1000L + "s, linking " + (linking - records) / 1000L + "s)");
    }

    private void linkReferences() {
        int n = this.lazyLinks.size();
        for (int i = 0; i < n; ++i) {
            LazyLink lazyLink = (LazyLink)this.lazyLinks.get(i);
            try {
                if (lazyLink.xref.getTarget() == null) {
                    lazyLink.xref.link();
                }
                this.progress = Math.min(100, i * 200 / n);
                continue;
            }
            catch (GedcomException ex) {
                this.warnings.add(new Warning(lazyLink.line, ex.getMessage(), lazyLink.xref));
            }
        }
    }

    private boolean readHeader() throws IOException {
        Property plac;
        Property vers;
        String source;
        Entity header = this.reader.readEntity();
        if (header == null || !header.getTag().equals("HEAD")) {
            throw new GedcomFormatException(RESOURCES.getString("read.error.noheader"), 0);
        }
        this.tempSubmitter = header.getPropertyValue("SUBM");
        if (this.tempSubmitter.length() == 0) {
            this.warnings.add(new Warning(0, RESOURCES.getString("read.warn.nosubmitter"), this.gedcom));
        }
        if ((source = header.getPropertyValue("SOUR")).length() == 0) {
            this.warnings.add(new Warning(0, RESOURCES.getString("read.warn.nosourceid"), this.gedcom));
        }
        if ((vers = header.getPropertyByPath("HEAD:GEDC:VERS")) == null || header.getPropertyByPath("HEAD:GEDC:FORM") == null) {
            this.warnings.add(new Warning(0, RESOURCES.getString("read.warn.badgedc"), this.gedcom));
        } else {
            String v = vers.getValue();
            if ("5.5".equals(v)) {
                this.gedcom.setGrammar(Grammar.V55);
                LOG.info("Found VERS " + v + " - Gedcom version is 5.5");
            } else if ("5.5.1".equals(v)) {
                this.gedcom.setGrammar(Grammar.V551);
                LOG.info("Found VERS " + v + " - Gedcom version is 5.5.1");
            } else {
                String s = RESOURCES.getString("read.warn.badversion", new String[]{v, this.gedcom.getGrammar().getVersion()});
                this.warnings.add(new Warning(0, RESOURCES.getString("read.warn.badversion", new String[]{v, this.gedcom.getGrammar().getVersion()}), this.gedcom));
                LOG.warning(s);
            }
        }
        String lang = header.getPropertyValue("LANG");
        if (lang.length() > 0) {
            this.gedcom.setLanguage(lang);
            LOG.info("Found LANG " + lang + " - Locale is " + this.gedcom.getLocale());
        }
        if (header.getPropertyValue("CHAR").equals("ASCII")) {
            this.warnings.add(new Warning(0, RESOURCES.getString("read.warn.ascii"), this.gedcom));
        }
        if ((plac = header.getProperty("PLAC")) != null) {
            String form = plac.getPropertyValue("FORM");
            this.gedcom.setPlaceFormat(form);
            LOG.info("Found Place.Format " + form);
        }
        this.gedcom.deleteEntity(header);
        return true;
    }

    private static class MeteredInputStream
    extends InputStream {
        private long meter = 0L;
        private long marked = -1L;
        private InputStream in;

        MeteredInputStream(InputStream in) {
            this.in = in;
        }

        public long getCount() {
            return this.meter;
        }

        public int available() throws IOException {
            return this.in.available();
        }

        public void close() throws IOException {
            this.in.close();
        }

        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
            this.marked = this.meter;
        }

        public boolean markSupported() {
            return this.in.markSupported();
        }

        public int read() throws IOException {
            ++this.meter;
            return this.in.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.in.read(b, off, len);
            this.meter += (long)read;
            return read;
        }

        public int read(byte[] b) throws IOException {
            int read = this.in.read(b);
            this.meter += (long)read;
            return read;
        }

        public synchronized void reset() throws IOException {
            if (this.marked < 0L) {
                throw new IOException("reset() without mark()");
            }
            this.in.reset();
            this.meter = this.marked;
        }

        public long skip(long n) throws IOException {
            int skipped = (int)super.skip(n);
            this.meter += (long)skipped;
            return skipped;
        }
    }

    private static class Warning
    extends Context
    implements Comparable {
        private int lineNumber;

        private Warning(int lineNumber, Property property) {
            super(property);
            this.lineNumber = lineNumber;
        }

        private Warning(int lineNumber, String text, Gedcom gedcom) {
            super(gedcom);
            super.setText(RESOURCES.getString("read.warn", new Object[]{Integer.toString(lineNumber), text}));
            this.lineNumber = lineNumber;
        }

        private Warning(int lineNumber, String text, Property property) {
            super(property);
            super.setText(RESOURCES.getString("read.warn", new Object[]{Integer.toString(lineNumber), text}));
            this.lineNumber = lineNumber;
        }

        public int compareTo(Object o) {
            Warning that = (Warning)o;
            return this.lineNumber - that.lineNumber;
        }

        public Context setText(String text) {
            super.setText(RESOURCES.getString("read.warn", new Object[]{Integer.toString(this.lineNumber), text}));
            return this;
        }
    }

    private static class LazyLink {
        private PropertyXRef xref;
        private int line;

        LazyLink(PropertyXRef xref, int line) {
            this.xref = xref;
            this.line = line;
        }
    }

    private class EntityReader
    extends PropertyReader {
        private boolean warnedAboutPassword;

        EntityReader(Reader in) {
            super(in, null, false);
            this.warnedAboutPassword = false;
        }

        Entity readEntity() throws IOException {
            Entity result;
            if (!this.readLine(true)) {
                throw new GedcomFormatException(RESOURCES.getString("read.error.norecord"), this.lines);
            }
            if (this.level != 0) {
                throw new GedcomFormatException(RESOURCES.getString("read.error.nonumber"), this.lines);
            }
            if (this.tag.equals("TRLR")) {
                return null;
            }
            try {
                result = GedcomReader.this.gedcom.createEntity(this.tag, this.xref);
                if (result.getClass() != (class$genj$gedcom$Entity == null ? (class$genj$gedcom$Entity = GedcomReader.class$("genj.gedcom.Entity")) : class$genj$gedcom$Entity) && this.xref.length() == 0) {
                    GedcomReader.this.warnings.add(new Warning(this.getLines(), RESOURCES.getString("read.warn.recordnoid", Gedcom.getName(this.tag)), result));
                }
                result.setValue(this.value);
                this.readProperties(result, 0, 0);
            }
            catch (GedcomException ex) {
                throw new GedcomIOException(ex.getMessage(), this.lines);
            }
            if (this.tag.equals("TRLR")) {
                GedcomReader.this.entity++;
            }
            return result;
        }

        protected void readProperties(Property prop, int currentLevel, int pos) throws IOException {
            super.readProperties(prop, currentLevel, pos);
            this.decryptLazy(prop);
        }

        private void decryptLazy(Property prop) throws GedcomEncryptionException {
            if (prop instanceof PropertyXRef) {
                return;
            }
            if (prop instanceof PropertyDate && prop.isValid()) {
                return;
            }
            String value = prop.getValue();
            if (!Enigma.isEncrypted(value)) {
                return;
            }
            prop.setPrivate(true, false);
            String password = GedcomReader.this.gedcom.getPassword();
            if (password == "PASSWORD_UNKNOWN") {
                if (!this.warnedAboutPassword) {
                    this.warnedAboutPassword = true;
                    GedcomReader.this.warnings.add(new Warning(this.getLines(), RESOURCES.getString("crypt.password.unknown"), prop));
                }
                return;
            }
            if (password == "PASSWORD_NOT_SET") {
                throw new GedcomEncryptionException(RESOURCES.getString("crypt.password.required"), this.lines);
            }
            if (GedcomReader.this.enigma == null) {
                GedcomReader.this.enigma = Enigma.getInstance(password);
                if (GedcomReader.this.enigma == null) {
                    if (!this.warnedAboutPassword) {
                        this.warnedAboutPassword = true;
                        GedcomReader.this.warnings.add(new Warning(this.getLines(), RESOURCES.getString("crypt.password.mismatch"), prop));
                    }
                    GedcomReader.this.gedcom.setPassword("PASSWORD_UNKNOWN");
                    return;
                }
            }
            try {
                prop.setValue(GedcomReader.this.enigma.decrypt(value));
            }
            catch (IOException e) {
                throw new GedcomEncryptionException(RESOURCES.getString("crypt.password.invalid"), this.lines);
            }
        }

        protected void link(PropertyXRef xref, int line) {
            GedcomReader.this.lazyLinks.add(new LazyLink(xref, line));
        }

        protected void trackEmptyLine() {
            GedcomReader.this.warnings.add(new Warning(this.getLines(), RESOURCES.getString("read.error.emptyline"), GedcomReader.this.gedcom));
        }

        protected void trackBadLevel(int level, Property parent) {
            GedcomReader.this.warnings.add(new Warning(this.getLines(), RESOURCES.getString("read.warn.badlevel", "" + level), parent));
        }

        protected void trackBadProperty(Property property, String message) {
            GedcomReader.this.warnings.add(new Warning(this.getLines(), message, property));
        }
    }

    private class SniffedInputStream
    extends BufferedInputStream {
        private final byte[] BOM_UTF8;
        private final byte[] BOM_UTF16BE;
        private final byte[] BOM_UTF16LE;
        private String encoding;
        private Charset charset;
        private String header;
        String warning;

        private SniffedInputStream(InputStream in) throws IOException {
            super(in, 4096);
            this.BOM_UTF8 = new byte[]{-17, -69, -65};
            this.BOM_UTF16BE = new byte[]{-2, -1};
            this.BOM_UTF16LE = new byte[]{-1, -2};
            super.mark(4096);
            super.read();
            super.reset();
            if (this.matchPrefix(this.BOM_UTF8)) {
                LOG.info("Found BOM_UTF8 - trying encoding UTF-8");
                this.charset = Charset.forName("UTF-8");
                this.encoding = "UTF-8";
                return;
            }
            if (this.matchPrefix(this.BOM_UTF16BE)) {
                LOG.info("Found BOM_UTF16BE - trying encoding UTF-16BE");
                this.charset = Charset.forName("UTF-16BE");
                this.encoding = "UNICODE";
                return;
            }
            if (this.matchPrefix(this.BOM_UTF16LE)) {
                LOG.info("Found BOM_UTF16LE - trying encoding UTF-16LE");
                this.charset = Charset.forName("UTF-16LE");
                this.encoding = "UNICODE";
                return;
            }
            if (this.matchCHAR("UTF-8") || this.matchCHAR("UTF8")) {
                LOG.info("Found UTF-8 - trying encoding UTF-8");
                this.charset = Charset.forName("UTF-8");
                this.encoding = "UTF-8";
                return;
            }
            if (this.matchCHAR("UNICODE")) {
                LOG.info("Found single byte UNICODE - trying encoding UTF-8");
                this.charset = Charset.forName("UTF-8");
                this.encoding = "UNICODE";
                return;
            }
            if (this.matchCHAR("UNICODE", "UTF-16BE")) {
                LOG.info("Found UNICODE/big endian - trying encoding UTF-16BE");
                this.charset = Charset.forName("UTF-16BE");
                this.encoding = "UNICODE";
                return;
            }
            if (this.matchCHAR("UNICODE", "UTF-16LE")) {
                LOG.info("Found UNICODE/little endian - trying encoding UTF-16LE");
                this.charset = Charset.forName("UTF-16LE");
                this.encoding = "UNICODE";
                return;
            }
            if (this.matchCHAR("ASCII")) {
                LOG.info("Found ASCII - trying encoding ISO-8859-1");
                this.charset = Charset.forName("ISO-8859-1");
                this.encoding = "ASCII";
                return;
            }
            if (this.matchCHAR("ANSEL")) {
                LOG.info("Found ANSEL - trying encoding ANSEL");
                this.charset = new AnselCharset();
                this.encoding = "ANSEL";
                return;
            }
            if (this.matchCHAR("ANSI")) {
                LOG.info("Found ANSI - trying encoding Windows-1252");
                this.charset = Charset.forName("Windows-1252");
                this.encoding = "ANSI";
                return;
            }
            if (this.matchCHAR("LATIN1") || this.matchCHAR("IBMPC")) {
                LOG.info("Found LATIN1 or IBMPC - trying encoding ISO-8859-1");
                this.charset = Charset.forName("ISO-8859-1");
                this.encoding = "LATIN1";
                return;
            }
            this.warning = RESOURCES.getString("read.warn.nochar");
            LOG.info("Could not sniff encoding - trying ANSEL");
            this.charset = new AnselCharset();
            this.encoding = "ANSEL";
        }

        private boolean matchCHAR(String line) {
            return this.matchCHAR(line, null);
        }

        private boolean matchCHAR(String value, String charset) {
            try {
                String header = charset != null ? new String(this.buf, this.pos, this.count, charset) : new String(this.buf, this.pos, this.count);
                return header.indexOf("1 CHAR " + value) >= 0;
            }
            catch (UnsupportedEncodingException e) {
                LOG.log(Level.WARNING, "Couldn't parse header in charset " + charset, e);
                return false;
            }
        }

        private boolean matchPrefix(byte[] prefix) throws IOException {
            if (this.count < prefix.length) {
                return false;
            }
            for (int i = 0; i < prefix.length; ++i) {
                if (this.buf[this.pos + i] == prefix[i]) continue;
                return false;
            }
            super.skip(prefix.length);
            return true;
        }

        Charset getCharset() {
            return this.charset;
        }

        String getEncoding() {
            return this.encoding;
        }
    }
}

