/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.logging.Logger;

class AnselCharset
extends Charset {
    private static final Logger LOG = Logger.getLogger("genj.io");

    public AnselCharset() {
        super("Ansel", new String[]{"ANSEL"});
    }

    public boolean contains(Charset cs) {
        return false;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private class Decoder
    extends CharsetDecoder {
        private Decoder(AnselCharset ansel) {
            super(ansel, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            if (!in.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (in.position() == 0 && in.remaining() == 1) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                out.put((char)this.ansel1byte2unicode(in.get() & 0xFF));
                return CoderResult.UNDERFLOW;
            }
            CoderResult rc = CoderResult.UNDERFLOW;
            int pos = in.position();
            int limit = in.limit();
            while (pos < limit && limit - pos >= 2) {
                int b;
                if (!out.hasRemaining()) {
                    rc = CoderResult.OVERFLOW;
                    break;
                }
                int a = in.get(pos) & 0xFF;
                int unicode = this.ansel2byte2unicode(a << 8 | (b = in.get(pos + 1) & 0xFF));
                if (unicode > 0) {
                    out.put((char)unicode);
                    pos += 2;
                    continue;
                }
                out.put((char)this.ansel1byte2unicode(a));
                ++pos;
            }
            in.position(pos);
            return rc;
        }

        private int ansel1byte2unicode(int ansel) {
            switch (ansel) {
                case 141: {
                    return 8205;
                }
                case 142: {
                    return 8204;
                }
                case 161: {
                    return 321;
                }
                case 162: {
                    return 216;
                }
                case 163: {
                    return 208;
                }
                case 164: {
                    return 222;
                }
                case 165: {
                    return 198;
                }
                case 166: {
                    return 338;
                }
                case 167: {
                    return 697;
                }
                case 168: {
                    return 183;
                }
                case 169: {
                    return 9837;
                }
                case 170: {
                    return 174;
                }
                case 171: {
                    return 177;
                }
                case 172: {
                    return 416;
                }
                case 173: {
                    return 431;
                }
                case 174: {
                    return 702;
                }
                case 176: {
                    return 703;
                }
                case 177: {
                    return 322;
                }
                case 178: {
                    return 248;
                }
                case 179: {
                    return 273;
                }
                case 180: {
                    return 254;
                }
                case 181: {
                    return 230;
                }
                case 182: {
                    return 339;
                }
                case 183: {
                    return 698;
                }
                case 184: {
                    return 305;
                }
                case 185: {
                    return 163;
                }
                case 186: {
                    return 240;
                }
                case 188: {
                    return 417;
                }
                case 189: {
                    return 432;
                }
                case 192: {
                    return 176;
                }
                case 193: {
                    return 8467;
                }
                case 194: {
                    return 8471;
                }
                case 195: {
                    return 169;
                }
                case 196: {
                    return 9839;
                }
                case 197: {
                    return 191;
                }
                case 198: {
                    return 161;
                }
                case 207: {
                    return 223;
                }
                case 224: {
                    return 777;
                }
                case 225: {
                    return 768;
                }
                case 226: {
                    return 769;
                }
                case 227: {
                    return 770;
                }
                case 228: {
                    return 771;
                }
                case 229: {
                    return 772;
                }
                case 230: {
                    return 774;
                }
                case 231: {
                    return 775;
                }
                case 233: {
                    return 780;
                }
                case 234: {
                    return 778;
                }
                case 235: {
                    return 65056;
                }
                case 236: {
                    return 65057;
                }
                case 237: {
                    return 789;
                }
                case 238: {
                    return 779;
                }
                case 239: {
                    return 784;
                }
                case 240: {
                    return 807;
                }
                case 241: {
                    return 808;
                }
                case 242: {
                    return 803;
                }
                case 243: {
                    return 804;
                }
                case 244: {
                    return 805;
                }
                case 245: {
                    return 819;
                }
                case 246: {
                    return 818;
                }
                case 247: {
                    return 806;
                }
                case 248: {
                    return 796;
                }
                case 249: {
                    return 814;
                }
                case 250: {
                    return 65058;
                }
                case 251: {
                    return 65059;
                }
                case 254: {
                    return 787;
                }
            }
            return (byte)ansel;
        }

        private int ansel2byte2unicode(int ansel) {
            switch (ansel) {
                case 57409: {
                    return 7842;
                }
                case 57413: {
                    return 7866;
                }
                case 57417: {
                    return 7880;
                }
                case 57423: {
                    return 7886;
                }
                case 57429: {
                    return 7910;
                }
                case 57433: {
                    return 7926;
                }
                case 57441: {
                    return 7843;
                }
                case 57445: {
                    return 7867;
                }
                case 57449: {
                    return 7881;
                }
                case 57455: {
                    return 7887;
                }
                case 57461: {
                    return 7911;
                }
                case 57465: {
                    return 7927;
                }
                case 57665: {
                    return 192;
                }
                case 57669: {
                    return 200;
                }
                case 57673: {
                    return 204;
                }
                case 57679: {
                    return 210;
                }
                case 57685: {
                    return 217;
                }
                case 57687: {
                    return 7808;
                }
                case 57689: {
                    return 7922;
                }
                case 57697: {
                    return 224;
                }
                case 57701: {
                    return 232;
                }
                case 57705: {
                    return 236;
                }
                case 57711: {
                    return 242;
                }
                case 57717: {
                    return 249;
                }
                case 57719: {
                    return 7809;
                }
                case 57721: {
                    return 7923;
                }
                case 57921: {
                    return 193;
                }
                case 57923: {
                    return 262;
                }
                case 57925: {
                    return 201;
                }
                case 57927: {
                    return 500;
                }
                case 57929: {
                    return 205;
                }
                case 57931: {
                    return 7728;
                }
                case 57932: {
                    return 313;
                }
                case 57933: {
                    return 7742;
                }
                case 57934: {
                    return 323;
                }
                case 57935: {
                    return 211;
                }
                case 57936: {
                    return 7764;
                }
                case 57938: {
                    return 340;
                }
                case 57939: {
                    return 346;
                }
                case 57941: {
                    return 218;
                }
                case 57943: {
                    return 7810;
                }
                case 57945: {
                    return 221;
                }
                case 57946: {
                    return 377;
                }
                case 57953: {
                    return 225;
                }
                case 57955: {
                    return 263;
                }
                case 57957: {
                    return 233;
                }
                case 57959: {
                    return 501;
                }
                case 57961: {
                    return 237;
                }
                case 57963: {
                    return 7729;
                }
                case 57964: {
                    return 314;
                }
                case 57965: {
                    return 7743;
                }
                case 57966: {
                    return 324;
                }
                case 57967: {
                    return 243;
                }
                case 57968: {
                    return 7765;
                }
                case 57970: {
                    return 341;
                }
                case 57971: {
                    return 347;
                }
                case 57973: {
                    return 250;
                }
                case 57975: {
                    return 7811;
                }
                case 57977: {
                    return 253;
                }
                case 57978: {
                    return 378;
                }
                case 58021: {
                    return 508;
                }
                case 58037: {
                    return 509;
                }
                case 58177: {
                    return 194;
                }
                case 58179: {
                    return 264;
                }
                case 58181: {
                    return 202;
                }
                case 58183: {
                    return 284;
                }
                case 58184: {
                    return 292;
                }
                case 58185: {
                    return 206;
                }
                case 58186: {
                    return 308;
                }
                case 58191: {
                    return 212;
                }
                case 58195: {
                    return 348;
                }
                case 58197: {
                    return 219;
                }
                case 58199: {
                    return 372;
                }
                case 58201: {
                    return 374;
                }
                case 58202: {
                    return 7824;
                }
                case 58209: {
                    return 226;
                }
                case 58211: {
                    return 265;
                }
                case 58213: {
                    return 234;
                }
                case 58215: {
                    return 285;
                }
                case 58216: {
                    return 293;
                }
                case 58217: {
                    return 238;
                }
                case 58218: {
                    return 309;
                }
                case 58223: {
                    return 244;
                }
                case 58227: {
                    return 349;
                }
                case 58229: {
                    return 251;
                }
                case 58231: {
                    return 373;
                }
                case 58233: {
                    return 375;
                }
                case 58234: {
                    return 7825;
                }
                case 58433: {
                    return 195;
                }
                case 58437: {
                    return 7868;
                }
                case 58441: {
                    return 296;
                }
                case 58446: {
                    return 209;
                }
                case 58447: {
                    return 213;
                }
                case 58453: {
                    return 360;
                }
                case 58454: {
                    return 7804;
                }
                case 58457: {
                    return 7928;
                }
                case 58465: {
                    return 227;
                }
                case 58469: {
                    return 7869;
                }
                case 58473: {
                    return 297;
                }
                case 58478: {
                    return 241;
                }
                case 58479: {
                    return 245;
                }
                case 58485: {
                    return 361;
                }
                case 58486: {
                    return 7805;
                }
                case 58489: {
                    return 7929;
                }
                case 58689: {
                    return 256;
                }
                case 58693: {
                    return 274;
                }
                case 58695: {
                    return 7712;
                }
                case 58697: {
                    return 298;
                }
                case 58703: {
                    return 332;
                }
                case 58709: {
                    return 362;
                }
                case 58721: {
                    return 257;
                }
                case 58725: {
                    return 275;
                }
                case 58727: {
                    return 7713;
                }
                case 58729: {
                    return 299;
                }
                case 58735: {
                    return 333;
                }
                case 58741: {
                    return 363;
                }
                case 58789: {
                    return 482;
                }
                case 58805: {
                    return 483;
                }
                case 58945: {
                    return 258;
                }
                case 58949: {
                    return 276;
                }
                case 58951: {
                    return 286;
                }
                case 58953: {
                    return 300;
                }
                case 58959: {
                    return 334;
                }
                case 58965: {
                    return 364;
                }
                case 58977: {
                    return 259;
                }
                case 58981: {
                    return 277;
                }
                case 58983: {
                    return 287;
                }
                case 58985: {
                    return 301;
                }
                case 58991: {
                    return 335;
                }
                case 58997: {
                    return 365;
                }
                case 59202: {
                    return 7682;
                }
                case 59203: {
                    return 266;
                }
                case 59204: {
                    return 7690;
                }
                case 59205: {
                    return 278;
                }
                case 59206: {
                    return 7710;
                }
                case 59207: {
                    return 288;
                }
                case 59208: {
                    return 7714;
                }
                case 59209: {
                    return 304;
                }
                case 59213: {
                    return 7744;
                }
                case 59214: {
                    return 7748;
                }
                case 59216: {
                    return 7766;
                }
                case 59218: {
                    return 7768;
                }
                case 59219: {
                    return 7776;
                }
                case 59220: {
                    return 7786;
                }
                case 59223: {
                    return 7814;
                }
                case 59224: {
                    return 7818;
                }
                case 59225: {
                    return 7822;
                }
                case 59226: {
                    return 379;
                }
                case 59234: {
                    return 7683;
                }
                case 59235: {
                    return 267;
                }
                case 59236: {
                    return 7691;
                }
                case 59237: {
                    return 279;
                }
                case 59238: {
                    return 7711;
                }
                case 59239: {
                    return 289;
                }
                case 59240: {
                    return 7715;
                }
                case 59245: {
                    return 7745;
                }
                case 59246: {
                    return 7749;
                }
                case 59248: {
                    return 7767;
                }
                case 59250: {
                    return 7769;
                }
                case 59251: {
                    return 7777;
                }
                case 59252: {
                    return 7787;
                }
                case 59255: {
                    return 7815;
                }
                case 59256: {
                    return 7819;
                }
                case 59257: {
                    return 7823;
                }
                case 59258: {
                    return 380;
                }
                case 59457: {
                    return 196;
                }
                case 59461: {
                    return 203;
                }
                case 59464: {
                    return 7718;
                }
                case 59465: {
                    return 207;
                }
                case 59471: {
                    return 214;
                }
                case 59477: {
                    return 220;
                }
                case 59479: {
                    return 7812;
                }
                case 59480: {
                    return 7820;
                }
                case 59481: {
                    return 376;
                }
                case 59489: {
                    return 228;
                }
                case 59493: {
                    return 235;
                }
                case 59496: {
                    return 7719;
                }
                case 59497: {
                    return 239;
                }
                case 59503: {
                    return 246;
                }
                case 59508: {
                    return 7831;
                }
                case 59509: {
                    return 252;
                }
                case 59511: {
                    return 7813;
                }
                case 59512: {
                    return 7821;
                }
                case 59513: {
                    return 255;
                }
                case 59713: {
                    return 461;
                }
                case 59715: {
                    return 268;
                }
                case 59716: {
                    return 270;
                }
                case 59717: {
                    return 282;
                }
                case 59719: {
                    return 486;
                }
                case 59721: {
                    return 463;
                }
                case 59723: {
                    return 488;
                }
                case 59724: {
                    return 317;
                }
                case 59726: {
                    return 327;
                }
                case 59727: {
                    return 465;
                }
                case 59730: {
                    return 344;
                }
                case 59731: {
                    return 352;
                }
                case 59732: {
                    return 356;
                }
                case 59733: {
                    return 467;
                }
                case 59738: {
                    return 381;
                }
                case 59745: {
                    return 462;
                }
                case 59747: {
                    return 269;
                }
                case 59748: {
                    return 271;
                }
                case 59749: {
                    return 283;
                }
                case 59751: {
                    return 487;
                }
                case 59753: {
                    return 464;
                }
                case 59754: {
                    return 496;
                }
                case 59755: {
                    return 489;
                }
                case 59756: {
                    return 318;
                }
                case 59758: {
                    return 328;
                }
                case 59759: {
                    return 466;
                }
                case 59762: {
                    return 345;
                }
                case 59763: {
                    return 353;
                }
                case 59764: {
                    return 357;
                }
                case 59765: {
                    return 468;
                }
                case 59770: {
                    return 382;
                }
                case 59969: {
                    return 197;
                }
                case 60001: {
                    return 229;
                }
                case 60021: {
                    return 367;
                }
                case 60023: {
                    return 7832;
                }
                case 60025: {
                    return 7833;
                }
                case 60077: {
                    return 366;
                }
                case 61007: {
                    return 336;
                }
                case 61013: {
                    return 368;
                }
                case 61039: {
                    return 337;
                }
                case 61045: {
                    return 369;
                }
                case 61472: {
                    return 184;
                }
                case 61507: {
                    return 199;
                }
                case 61508: {
                    return 7696;
                }
                case 61511: {
                    return 290;
                }
                case 61512: {
                    return 7720;
                }
                case 61515: {
                    return 310;
                }
                case 61516: {
                    return 315;
                }
                case 61518: {
                    return 325;
                }
                case 61522: {
                    return 342;
                }
                case 61523: {
                    return 350;
                }
                case 61524: {
                    return 354;
                }
                case 61539: {
                    return 231;
                }
                case 61540: {
                    return 7697;
                }
                case 61543: {
                    return 291;
                }
                case 61544: {
                    return 7721;
                }
                case 61547: {
                    return 311;
                }
                case 61548: {
                    return 316;
                }
                case 61550: {
                    return 326;
                }
                case 61554: {
                    return 343;
                }
                case 61555: {
                    return 351;
                }
                case 61556: {
                    return 355;
                }
                case 61761: {
                    return 260;
                }
                case 61765: {
                    return 280;
                }
                case 61769: {
                    return 302;
                }
                case 61775: {
                    return 490;
                }
                case 61781: {
                    return 370;
                }
                case 61793: {
                    return 261;
                }
                case 61797: {
                    return 281;
                }
                case 61801: {
                    return 303;
                }
                case 61807: {
                    return 491;
                }
                case 61813: {
                    return 371;
                }
                case 62017: {
                    return 7840;
                }
                case 62018: {
                    return 7684;
                }
                case 62020: {
                    return 7692;
                }
                case 62021: {
                    return 7864;
                }
                case 62024: {
                    return 7716;
                }
                case 62025: {
                    return 7882;
                }
                case 62027: {
                    return 7730;
                }
                case 62028: {
                    return 7734;
                }
                case 62029: {
                    return 7746;
                }
                case 62030: {
                    return 7750;
                }
                case 62031: {
                    return 7884;
                }
                case 62034: {
                    return 7770;
                }
                case 62035: {
                    return 7778;
                }
                case 62036: {
                    return 7788;
                }
                case 62037: {
                    return 7908;
                }
                case 62038: {
                    return 7806;
                }
                case 62039: {
                    return 7816;
                }
                case 62041: {
                    return 7924;
                }
                case 62042: {
                    return 7826;
                }
                case 62049: {
                    return 7841;
                }
                case 62050: {
                    return 7685;
                }
                case 62052: {
                    return 7693;
                }
                case 62053: {
                    return 7865;
                }
                case 62056: {
                    return 7717;
                }
                case 62057: {
                    return 7883;
                }
                case 62059: {
                    return 7731;
                }
                case 62060: {
                    return 7735;
                }
                case 62061: {
                    return 7747;
                }
                case 62062: {
                    return 7751;
                }
                case 62063: {
                    return 7885;
                }
                case 62066: {
                    return 7771;
                }
                case 62067: {
                    return 7779;
                }
                case 62068: {
                    return 7789;
                }
                case 62069: {
                    return 7909;
                }
                case 62070: {
                    return 7807;
                }
                case 62071: {
                    return 7817;
                }
                case 62073: {
                    return 7925;
                }
                case 62074: {
                    return 7827;
                }
                case 62293: {
                    return 7794;
                }
                case 62325: {
                    return 7795;
                }
                case 62529: {
                    return 7680;
                }
                case 62561: {
                    return 7681;
                }
                case 63816: {
                    return 7722;
                }
                case 63848: {
                    return 7723;
                }
            }
            return -1;
        }
    }

    private static class Encoder
    extends CharsetEncoder {
        private Encoder(AnselCharset ansel) {
            super(ansel, 1.5f, 2.0f);
        }

        public boolean isLegalReplacement(byte[] repl) {
            return true;
        }

        public boolean canEncode(char c) {
            if (c < '\u0080') {
                return true;
            }
            return this.unicode2ansel(c) > -1;
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            int pos;
            CoderResult rc = CoderResult.UNDERFLOW;
            int limit = in.limit();
            for (pos = in.position(); pos < limit; ++pos) {
                char c = in.get(pos);
                if (c < '\u0080') {
                    if (out.remaining() < 1) {
                        rc = CoderResult.OVERFLOW;
                        break;
                    }
                    out.put((byte)c);
                    continue;
                }
                int ansel = this.unicode2ansel(c);
                if (ansel == -1) {
                    LOG.warning("Can't encode character  '+" + Integer.toHexString(c).toUpperCase() + "' in Ansel charset. Position " + pos + " in: \"" + in.toString() + "\"");
                    rc = CoderResult.unmappableForLength(1);
                    break;
                }
                if (ansel < 256) {
                    if (out.remaining() < 1) {
                        rc = CoderResult.OVERFLOW;
                        break;
                    }
                    out.put((byte)ansel);
                    continue;
                }
                if (out.remaining() < 2) {
                    rc = CoderResult.OVERFLOW;
                    break;
                }
                out.put((byte)(ansel >> 8));
                out.put((byte)(ansel & 0xFF));
            }
            in.position(pos);
            return rc;
        }

        private int unicode2ansel(int unicode) {
            switch (unicode) {
                case 161: {
                    return 198;
                }
                case 163: {
                    return 185;
                }
                case 169: {
                    return 195;
                }
                case 174: {
                    return 170;
                }
                case 176: {
                    return 192;
                }
                case 177: {
                    return 171;
                }
                case 183: {
                    return 168;
                }
                case 184: {
                    return 61472;
                }
                case 191: {
                    return 197;
                }
                case 192: {
                    return 57665;
                }
                case 193: {
                    return 57921;
                }
                case 194: {
                    return 58177;
                }
                case 195: {
                    return 58433;
                }
                case 196: {
                    return 59457;
                }
                case 197: {
                    return 59969;
                }
                case 198: {
                    return 165;
                }
                case 199: {
                    return 61507;
                }
                case 200: {
                    return 57669;
                }
                case 201: {
                    return 57925;
                }
                case 202: {
                    return 58181;
                }
                case 203: {
                    return 59461;
                }
                case 204: {
                    return 57673;
                }
                case 205: {
                    return 57929;
                }
                case 206: {
                    return 58185;
                }
                case 207: {
                    return 59465;
                }
                case 208: {
                    return 163;
                }
                case 209: {
                    return 58446;
                }
                case 210: {
                    return 57679;
                }
                case 211: {
                    return 57935;
                }
                case 212: {
                    return 58191;
                }
                case 213: {
                    return 58447;
                }
                case 214: {
                    return 59471;
                }
                case 216: {
                    return 162;
                }
                case 217: {
                    return 57685;
                }
                case 218: {
                    return 57941;
                }
                case 219: {
                    return 58197;
                }
                case 220: {
                    return 59477;
                }
                case 221: {
                    return 57945;
                }
                case 222: {
                    return 164;
                }
                case 223: {
                    return 207;
                }
                case 224: {
                    return 57697;
                }
                case 225: {
                    return 57953;
                }
                case 226: {
                    return 58209;
                }
                case 227: {
                    return 58465;
                }
                case 228: {
                    return 59489;
                }
                case 229: {
                    return 60001;
                }
                case 230: {
                    return 181;
                }
                case 231: {
                    return 61539;
                }
                case 232: {
                    return 57701;
                }
                case 233: {
                    return 57957;
                }
                case 234: {
                    return 58213;
                }
                case 235: {
                    return 59493;
                }
                case 236: {
                    return 57705;
                }
                case 237: {
                    return 57961;
                }
                case 238: {
                    return 58217;
                }
                case 239: {
                    return 59497;
                }
                case 240: {
                    return 186;
                }
                case 241: {
                    return 58478;
                }
                case 242: {
                    return 57711;
                }
                case 243: {
                    return 57967;
                }
                case 244: {
                    return 58223;
                }
                case 245: {
                    return 58479;
                }
                case 246: {
                    return 59503;
                }
                case 248: {
                    return 178;
                }
                case 249: {
                    return 57717;
                }
                case 250: {
                    return 57973;
                }
                case 251: {
                    return 58229;
                }
                case 252: {
                    return 59509;
                }
                case 253: {
                    return 57977;
                }
                case 254: {
                    return 180;
                }
                case 255: {
                    return 59513;
                }
                case 256: {
                    return 58689;
                }
                case 257: {
                    return 58721;
                }
                case 258: {
                    return 58945;
                }
                case 259: {
                    return 58977;
                }
                case 260: {
                    return 61761;
                }
                case 261: {
                    return 61793;
                }
                case 262: {
                    return 57923;
                }
                case 263: {
                    return 57955;
                }
                case 264: {
                    return 58179;
                }
                case 265: {
                    return 58211;
                }
                case 266: {
                    return 59203;
                }
                case 267: {
                    return 59235;
                }
                case 268: {
                    return 59715;
                }
                case 269: {
                    return 59747;
                }
                case 270: {
                    return 59716;
                }
                case 271: {
                    return 59748;
                }
                case 272: {
                    return 163;
                }
                case 273: {
                    return 179;
                }
                case 274: {
                    return 58693;
                }
                case 275: {
                    return 58725;
                }
                case 276: {
                    return 58949;
                }
                case 277: {
                    return 58981;
                }
                case 278: {
                    return 59205;
                }
                case 279: {
                    return 59237;
                }
                case 280: {
                    return 61765;
                }
                case 281: {
                    return 61797;
                }
                case 282: {
                    return 59717;
                }
                case 283: {
                    return 59749;
                }
                case 284: {
                    return 58183;
                }
                case 285: {
                    return 58215;
                }
                case 286: {
                    return 58951;
                }
                case 287: {
                    return 58983;
                }
                case 288: {
                    return 59207;
                }
                case 289: {
                    return 59239;
                }
                case 290: {
                    return 61511;
                }
                case 291: {
                    return 61543;
                }
                case 292: {
                    return 58184;
                }
                case 293: {
                    return 58216;
                }
                case 296: {
                    return 58441;
                }
                case 297: {
                    return 58473;
                }
                case 298: {
                    return 58697;
                }
                case 299: {
                    return 58729;
                }
                case 300: {
                    return 58953;
                }
                case 301: {
                    return 58985;
                }
                case 302: {
                    return 61769;
                }
                case 303: {
                    return 61801;
                }
                case 304: {
                    return 59209;
                }
                case 305: {
                    return 184;
                }
                case 308: {
                    return 58186;
                }
                case 309: {
                    return 58218;
                }
                case 310: {
                    return 61515;
                }
                case 311: {
                    return 61547;
                }
                case 313: {
                    return 57932;
                }
                case 314: {
                    return 57964;
                }
                case 315: {
                    return 61516;
                }
                case 316: {
                    return 61548;
                }
                case 317: {
                    return 59724;
                }
                case 318: {
                    return 59756;
                }
                case 321: {
                    return 161;
                }
                case 322: {
                    return 177;
                }
                case 323: {
                    return 57934;
                }
                case 324: {
                    return 57966;
                }
                case 325: {
                    return 61518;
                }
                case 326: {
                    return 61550;
                }
                case 327: {
                    return 59726;
                }
                case 328: {
                    return 59758;
                }
                case 332: {
                    return 58703;
                }
                case 333: {
                    return 58735;
                }
                case 334: {
                    return 58959;
                }
                case 335: {
                    return 58991;
                }
                case 336: {
                    return 61007;
                }
                case 337: {
                    return 61039;
                }
                case 338: {
                    return 166;
                }
                case 339: {
                    return 182;
                }
                case 340: {
                    return 57938;
                }
                case 341: {
                    return 57970;
                }
                case 342: {
                    return 61522;
                }
                case 343: {
                    return 61554;
                }
                case 344: {
                    return 59730;
                }
                case 345: {
                    return 59762;
                }
                case 346: {
                    return 57939;
                }
                case 347: {
                    return 57971;
                }
                case 348: {
                    return 58195;
                }
                case 349: {
                    return 58227;
                }
                case 350: {
                    return 61523;
                }
                case 351: {
                    return 61555;
                }
                case 352: {
                    return 59731;
                }
                case 353: {
                    return 59763;
                }
                case 354: {
                    return 61524;
                }
                case 355: {
                    return 61556;
                }
                case 356: {
                    return 59732;
                }
                case 357: {
                    return 59764;
                }
                case 360: {
                    return 58453;
                }
                case 361: {
                    return 58485;
                }
                case 362: {
                    return 58709;
                }
                case 363: {
                    return 58741;
                }
                case 364: {
                    return 58965;
                }
                case 365: {
                    return 58997;
                }
                case 366: {
                    return 60077;
                }
                case 367: {
                    return 60021;
                }
                case 368: {
                    return 61013;
                }
                case 369: {
                    return 61045;
                }
                case 370: {
                    return 61781;
                }
                case 371: {
                    return 61813;
                }
                case 372: {
                    return 58199;
                }
                case 373: {
                    return 58231;
                }
                case 374: {
                    return 58201;
                }
                case 375: {
                    return 58233;
                }
                case 376: {
                    return 59481;
                }
                case 377: {
                    return 57946;
                }
                case 378: {
                    return 57978;
                }
                case 379: {
                    return 59226;
                }
                case 380: {
                    return 59258;
                }
                case 381: {
                    return 59738;
                }
                case 382: {
                    return 59770;
                }
                case 416: {
                    return 172;
                }
                case 417: {
                    return 188;
                }
                case 431: {
                    return 173;
                }
                case 432: {
                    return 189;
                }
                case 461: {
                    return 59713;
                }
                case 462: {
                    return 59745;
                }
                case 463: {
                    return 59721;
                }
                case 464: {
                    return 59753;
                }
                case 465: {
                    return 59727;
                }
                case 466: {
                    return 59759;
                }
                case 467: {
                    return 59733;
                }
                case 468: {
                    return 59765;
                }
                case 482: {
                    return 58789;
                }
                case 483: {
                    return 58805;
                }
                case 486: {
                    return 59719;
                }
                case 487: {
                    return 59751;
                }
                case 488: {
                    return 59723;
                }
                case 489: {
                    return 59755;
                }
                case 490: {
                    return 61775;
                }
                case 491: {
                    return 61807;
                }
                case 496: {
                    return 59754;
                }
                case 500: {
                    return 57927;
                }
                case 501: {
                    return 57959;
                }
                case 508: {
                    return 58021;
                }
                case 509: {
                    return 58037;
                }
                case 697: {
                    return 167;
                }
                case 698: {
                    return 183;
                }
                case 702: {
                    return 174;
                }
                case 703: {
                    return 176;
                }
                case 768: {
                    return 225;
                }
                case 769: {
                    return 226;
                }
                case 770: {
                    return 227;
                }
                case 771: {
                    return 228;
                }
                case 772: {
                    return 229;
                }
                case 774: {
                    return 230;
                }
                case 775: {
                    return 231;
                }
                case 777: {
                    return 224;
                }
                case 778: {
                    return 234;
                }
                case 779: {
                    return 238;
                }
                case 780: {
                    return 233;
                }
                case 784: {
                    return 239;
                }
                case 787: {
                    return 254;
                }
                case 789: {
                    return 237;
                }
                case 796: {
                    return 248;
                }
                case 803: {
                    return 242;
                }
                case 804: {
                    return 243;
                }
                case 805: {
                    return 244;
                }
                case 806: {
                    return 247;
                }
                case 807: {
                    return 240;
                }
                case 808: {
                    return 241;
                }
                case 814: {
                    return 249;
                }
                case 818: {
                    return 246;
                }
                case 819: {
                    return 245;
                }
                case 7680: {
                    return 62529;
                }
                case 7681: {
                    return 62561;
                }
                case 7682: {
                    return 59202;
                }
                case 7683: {
                    return 59234;
                }
                case 7684: {
                    return 62018;
                }
                case 7685: {
                    return 62050;
                }
                case 7690: {
                    return 59204;
                }
                case 7691: {
                    return 59236;
                }
                case 7692: {
                    return 62020;
                }
                case 7693: {
                    return 62052;
                }
                case 7696: {
                    return 61508;
                }
                case 7697: {
                    return 61540;
                }
                case 7710: {
                    return 59206;
                }
                case 7711: {
                    return 59238;
                }
                case 7712: {
                    return 58695;
                }
                case 7713: {
                    return 58727;
                }
                case 7714: {
                    return 59208;
                }
                case 7715: {
                    return 59240;
                }
                case 7716: {
                    return 62024;
                }
                case 7717: {
                    return 62056;
                }
                case 7718: {
                    return 59464;
                }
                case 7719: {
                    return 59496;
                }
                case 7720: {
                    return 61512;
                }
                case 7721: {
                    return 61544;
                }
                case 7722: {
                    return 63816;
                }
                case 7723: {
                    return 63848;
                }
                case 7728: {
                    return 57931;
                }
                case 7729: {
                    return 57963;
                }
                case 7730: {
                    return 62027;
                }
                case 7731: {
                    return 62059;
                }
                case 7734: {
                    return 62028;
                }
                case 7735: {
                    return 62060;
                }
                case 7742: {
                    return 57933;
                }
                case 7743: {
                    return 57965;
                }
                case 7744: {
                    return 59213;
                }
                case 7745: {
                    return 59245;
                }
                case 7746: {
                    return 62029;
                }
                case 7747: {
                    return 62061;
                }
                case 7748: {
                    return 59214;
                }
                case 7749: {
                    return 59246;
                }
                case 7750: {
                    return 62030;
                }
                case 7751: {
                    return 62062;
                }
                case 7764: {
                    return 57936;
                }
                case 7765: {
                    return 57968;
                }
                case 7766: {
                    return 59216;
                }
                case 7767: {
                    return 59248;
                }
                case 7768: {
                    return 59218;
                }
                case 7769: {
                    return 59250;
                }
                case 7770: {
                    return 62034;
                }
                case 7771: {
                    return 62066;
                }
                case 7776: {
                    return 59219;
                }
                case 7777: {
                    return 59251;
                }
                case 7778: {
                    return 62035;
                }
                case 7779: {
                    return 62067;
                }
                case 7786: {
                    return 59220;
                }
                case 7787: {
                    return 59252;
                }
                case 7788: {
                    return 62036;
                }
                case 7789: {
                    return 62068;
                }
                case 7794: {
                    return 62293;
                }
                case 7795: {
                    return 62325;
                }
                case 7804: {
                    return 58454;
                }
                case 7805: {
                    return 58486;
                }
                case 7806: {
                    return 62038;
                }
                case 7807: {
                    return 62070;
                }
                case 7808: {
                    return 57687;
                }
                case 7809: {
                    return 57719;
                }
                case 7810: {
                    return 57943;
                }
                case 7811: {
                    return 57975;
                }
                case 7812: {
                    return 59479;
                }
                case 7813: {
                    return 59511;
                }
                case 7814: {
                    return 59223;
                }
                case 7815: {
                    return 59255;
                }
                case 7816: {
                    return 62039;
                }
                case 7817: {
                    return 62071;
                }
                case 7818: {
                    return 59224;
                }
                case 7819: {
                    return 59256;
                }
                case 7820: {
                    return 59480;
                }
                case 7821: {
                    return 59512;
                }
                case 7822: {
                    return 59225;
                }
                case 7823: {
                    return 59257;
                }
                case 7824: {
                    return 58202;
                }
                case 7825: {
                    return 58234;
                }
                case 7826: {
                    return 62042;
                }
                case 7827: {
                    return 62074;
                }
                case 7831: {
                    return 59508;
                }
                case 7832: {
                    return 60023;
                }
                case 7833: {
                    return 60025;
                }
                case 7840: {
                    return 62017;
                }
                case 7841: {
                    return 62049;
                }
                case 7842: {
                    return 57409;
                }
                case 7843: {
                    return 57441;
                }
                case 7864: {
                    return 62021;
                }
                case 7865: {
                    return 62053;
                }
                case 7866: {
                    return 57413;
                }
                case 7867: {
                    return 57445;
                }
                case 7868: {
                    return 58437;
                }
                case 7869: {
                    return 58469;
                }
                case 7880: {
                    return 57417;
                }
                case 7881: {
                    return 57449;
                }
                case 7882: {
                    return 62025;
                }
                case 7883: {
                    return 62057;
                }
                case 7884: {
                    return 62031;
                }
                case 7885: {
                    return 62063;
                }
                case 7886: {
                    return 57423;
                }
                case 7887: {
                    return 57455;
                }
                case 7908: {
                    return 62037;
                }
                case 7909: {
                    return 62069;
                }
                case 7910: {
                    return 57429;
                }
                case 7911: {
                    return 57461;
                }
                case 7922: {
                    return 57689;
                }
                case 7923: {
                    return 57721;
                }
                case 7924: {
                    return 62041;
                }
                case 7925: {
                    return 62073;
                }
                case 7926: {
                    return 57433;
                }
                case 7927: {
                    return 57465;
                }
                case 7928: {
                    return 58457;
                }
                case 7929: {
                    return 58489;
                }
                case 8204: {
                    return 142;
                }
                case 8205: {
                    return 141;
                }
                case 8467: {
                    return 193;
                }
                case 8471: {
                    return 194;
                }
                case 9837: {
                    return 169;
                }
                case 9839: {
                    return 196;
                }
                case 65056: {
                    return 235;
                }
                case 65057: {
                    return 236;
                }
                case 65058: {
                    return 250;
                }
                case 65059: {
                    return 251;
                }
            }
            return -1;
        }
    }
}

