/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.GedcomException;
import genj.gedcom.Options;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.FrenchRCalendar;
import genj.gedcom.time.GregorianCalendar;
import genj.gedcom.time.HebrewCalendar;
import genj.gedcom.time.JulianCalendar;
import genj.util.DirectAccessTokenizer;
import genj.util.Resources;
import genj.util.WordBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class PointInTime
implements Comparable {
    public static final int FORMAT_GEDCOM = 0;
    public static final int FORMAT_SHORT = 1;
    public static final int FORMAT_LONG = 2;
    public static final int FORMAT_NUMERIC = 3;
    static final Resources resources = Resources.get(PointInTime.class);
    public static final int UNKNOWN = Integer.MAX_VALUE;
    public static final GregorianCalendar GREGORIAN = new GregorianCalendar();
    public static final JulianCalendar JULIAN = new JulianCalendar();
    public static final HebrewCalendar HEBREW = new HebrewCalendar();
    public static final FrenchRCalendar FRENCHR = new FrenchRCalendar();
    public static final Calendar[] CALENDARS = new Calendar[]{GREGORIAN, JULIAN, HEBREW, FRENCHR};
    protected Calendar calendar = GREGORIAN;
    private int day = Integer.MAX_VALUE;
    private int month = Integer.MAX_VALUE;
    private int year = Integer.MAX_VALUE;
    private int jd = Integer.MAX_VALUE;
    private static DateFormat NUMERICDATEFORMAT = PointInTime.initNumericDateFormat();

    public PointInTime() {
    }

    public PointInTime(Calendar cal) {
        this.calendar = cal;
    }

    public PointInTime(int d, int m, int y) {
        this(d, m, y, GREGORIAN);
    }

    public PointInTime(int d, int m, int y, Calendar cal) {
        this.day = d;
        this.month = m;
        this.year = y;
        this.calendar = cal;
        this.jd = Integer.MAX_VALUE;
    }

    public PointInTime(String yyyymmdd) throws GedcomException {
        if (yyyymmdd == null || yyyymmdd.length() != 8) {
            throw new GedcomException(resources.getString("pit.noyyyymmdd", yyyymmdd));
        }
        try {
            this.year = Integer.parseInt(yyyymmdd.substring(0, 4));
            this.month = Integer.parseInt(yyyymmdd.substring(4, 6)) - 1;
            this.day = Integer.parseInt(yyyymmdd.substring(6, 8)) - 1;
        }
        catch (NumberFormatException e) {
            throw new GedcomException(resources.getString("pit.noyyyymmdd", yyyymmdd));
        }
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public static PointInTime getNow() {
        java.util.Calendar now = java.util.Calendar.getInstance();
        return new PointInTime(now.get(5) - 1, now.get(2), now.get(1));
    }

    public static PointInTime getPointInTime(String string) {
        PointInTime result = new PointInTime(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, GREGORIAN);
        result.set(string);
        return result;
    }

    public static PointInTime getPointInTime(long millis) {
        long julian = 2440588L + millis / 24L / 60L / 60L / 1000L;
        return GREGORIAN.toPointInTime((int)julian);
    }

    public long getTimeMillis() throws GedcomException {
        return ((long)this.getJulianDay() - 2440588L) * 24L * 60L * 60L * 1000L;
    }

    public PointInTime getPointInTime(Calendar cal) throws GedcomException {
        if (this.calendar == cal) {
            return this;
        }
        PointInTime result = new PointInTime();
        result.set(this);
        result.set(cal);
        return result;
    }

    public int getJulianDay() throws GedcomException {
        if (this.jd == Integer.MAX_VALUE) {
            this.jd = this.calendar.toJulianDay(this);
        }
        return this.jd;
    }

    public void reset() {
        this.set(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public String getDayOfWeek(boolean localize) throws GedcomException {
        return this.calendar.getDayOfWeek(this, localize);
    }

    public void set(Calendar cal) throws GedcomException {
        if (this.day == Integer.MAX_VALUE && this.month == Integer.MAX_VALUE && this.year == Integer.MAX_VALUE) {
            this.calendar = cal;
            return;
        }
        if (!this.isValid()) {
            throw new GedcomException(resources.getString("pit.invalid"));
        }
        if (!this.isComplete()) {
            throw new GedcomException(resources.getString("pit.incomplete"));
        }
        int jd = this.getJulianDay();
        this.set(cal.toPointInTime(jd));
    }

    public void set(int d, int m, int y) {
        this.set(d, m, y, this.calendar);
    }

    public void set(int d, int m, int y, Calendar cal) {
        this.day = d;
        this.month = m;
        this.year = y;
        this.calendar = cal;
        this.jd = Integer.MAX_VALUE;
    }

    public void set(PointInTime other) {
        this.calendar = other.calendar;
        this.set(other.getDay(), other.getMonth(), other.getYear());
    }

    public boolean set(String txt) {
        String third;
        String second;
        DirectAccessTokenizer tokens;
        String first;
        txt = txt.trim();
        this.calendar = GREGORIAN;
        if (txt.startsWith("@#")) {
            int i = txt.indexOf("@", 1);
            if (i < 0) {
                return false;
            }
            String esc = txt.substring(0, i + 1);
            txt = txt.substring(i + 1);
            for (int c = 0; c < CALENDARS.length; ++c) {
                Calendar cal = CALENDARS[c];
                if (!cal.escape.equalsIgnoreCase(esc)) continue;
                this.calendar = cal;
                break;
            }
        }
        if ((first = (tokens = new DirectAccessTokenizer(txt, " ", true)).get(0)) == null) {
            this.reset();
            return true;
        }
        int cont = 1;
        if ((second = tokens.get(cont++)) == null) {
            try {
                this.set(Integer.MAX_VALUE, Integer.MAX_VALUE, this.calendar.getYear(first));
            }
            catch (Throwable t) {
                return false;
            }
            return this.getYear() != Integer.MAX_VALUE;
        }
        if ((third = tokens.get(cont++)) == null) {
            try {
                if (this.calendar == FRENCHR) {
                    this.set(Integer.MAX_VALUE, Integer.MAX_VALUE, this.calendar.getYear(first + ' ' + second));
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.set(Integer.MAX_VALUE, this.calendar.parseMonth(first), this.calendar.getYear(second));
            }
            catch (Throwable t) {
                return false;
            }
            return this.getYear() != Integer.MAX_VALUE && this.getMonth() != Integer.MAX_VALUE;
        }
        third = txt.substring(tokens.getStart());
        try {
            this.set(Integer.parseInt(first) - 1, this.calendar.parseMonth(second), this.calendar.getYear(third));
        }
        catch (Throwable t) {
            return false;
        }
        return this.getYear() != Integer.MAX_VALUE && this.getMonth() != Integer.MAX_VALUE && this.getDay() != Integer.MAX_VALUE;
    }

    public boolean isGregorian() {
        return this.getCalendar() == GREGORIAN;
    }

    public boolean isComplete() {
        return this.year != Integer.MAX_VALUE && this.month != Integer.MAX_VALUE && this.day != Integer.MAX_VALUE;
    }

    public boolean isValid() {
        if (this.jd != Integer.MAX_VALUE) {
            return true;
        }
        if (this.day == Integer.MAX_VALUE && this.month == Integer.MAX_VALUE && this.year == Integer.MAX_VALUE) {
            return false;
        }
        try {
            this.jd = this.calendar.toJulianDay(this);
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
        return this.jd != Integer.MAX_VALUE;
    }

    public int compareTo(Object o) {
        return this.compareTo((PointInTime)o);
    }

    public int compareTo(PointInTime other) {
        boolean v1 = this.isValid();
        boolean v2 = other.isValid();
        if (!v1 && !v2) {
            return 0;
        }
        if (!v2) {
            return 1;
        }
        if (!v1) {
            return -1;
        }
        try {
            return this.getJulianDay() - other.getJulianDay();
        }
        catch (GedcomException e) {
            return 0;
        }
    }

    public String getValue() {
        return this.getValue(new WordBuffer()).toString();
    }

    public WordBuffer getValue(WordBuffer buffer) {
        if (this.calendar != GREGORIAN) {
            buffer.append(this.calendar.escape);
        }
        this.toString(buffer, 0);
        return buffer;
    }

    public String toString() {
        return this.toString(new WordBuffer()).toString();
    }

    public WordBuffer toString(WordBuffer buffer) {
        return this.toString(buffer, Options.getInstance().dateFormat);
    }

    private static DateFormat initNumericDateFormat() {
        DateFormat result = DateFormat.getDateInstance(3);
        try {
            String pattern = ((SimpleDateFormat)DateFormat.getDateInstance(3)).toPattern();
            int yyyy = pattern.indexOf("yyyy");
            if (yyyy < 0) {
                result = new SimpleDateFormat(pattern.replaceAll("yy", "yyyy"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static void localeChangedNotify() {
        NUMERICDATEFORMAT = PointInTime.initNumericDateFormat();
    }

    public WordBuffer toString(WordBuffer buffer, int format) {
        if (format == 3) {
            if (this.calendar == GREGORIAN && this.isComplete()) {
                java.util.Calendar c = java.util.Calendar.getInstance();
                c.set(this.year, this.month, this.day + 1);
                buffer.append(NUMERICDATEFORMAT.format(c.getTime()));
                return buffer;
            }
            format = 1;
        }
        if (!this.isValid()) {
            if (format != 0) {
                buffer.append("?");
            }
            return buffer;
        }
        if (this.year != Integer.MAX_VALUE) {
            if (this.month != Integer.MAX_VALUE) {
                if (this.day != Integer.MAX_VALUE) {
                    buffer.append(new Integer(this.day + 1));
                }
                buffer.append(format == 0 ? this.calendar.getMonth(this.month) : this.calendar.getDisplayMonth(this.month, format == 1));
            }
            buffer.append(format == 0 ? this.calendar.getYear(this.year) : this.calendar.getDisplayYear(this.year));
            if (format != 0 && this.calendar == JULIAN) {
                buffer.append("(j)");
            }
        }
        return buffer;
    }
}

