/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.time.GregorianCalendar;
import genj.gedcom.time.PointInTime;

public class JulianCalendar
extends GregorianCalendar {
    protected JulianCalendar() {
        super("@#DJULIAN@", "julian", "images/Julian.gif");
    }

    protected boolean isLeap(int year) {
        return year % 4 == 0;
    }

    protected int toJulianDay(int day, int month, int year) {
        if (year < 0) {
            ++year;
        }
        int y = year;
        int m = month + 1;
        int d = day + 1;
        if (m < 2) {
            --y;
            m += 12;
        }
        int E = (int)(365.25 * (double)(y + 4716));
        int F = (int)(30.6001 * (double)(m + 1));
        int JD = d + E + F - 1524;
        return JD;
    }

    protected PointInTime toPointInTime(int julianDay) {
        int Z = julianDay;
        int B = Z + 1524;
        int C = (int)(((double)B - 122.1) / 365.25);
        int D = (int)(365.25 * (double)C);
        int E = (int)((double)(B - D) / 30.6001);
        int F = (int)(30.6001 * (double)E);
        int d = B - D - F;
        int m = E - 1 <= 12 ? E - 1 : E - 13;
        int y = C - (m < 3 ? 4715 : 4716);
        return new PointInTime(d - 1, m - 1, y <= 0 ? y - 1 : y, this);
    }
}

