/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyVisitor;
import genj.gedcom.PropertyXRef;
import java.util.Collection;
import java.util.Stack;
import java.util.StringTokenizer;

public class TagPath {
    private String name = null;
    private String[] tags;
    private int[] qualifiers;
    private int len;
    private int hash = 0;
    public static final char SEPARATOR = ':';
    public static final String SEPARATOR_STRING = String.valueOf(':');
    private static final char SELECTOR = '#';

    public TagPath(String path) throws IllegalArgumentException {
        this(path, null);
    }

    public TagPath(String path, String name) throws IllegalArgumentException {
        this.name = name;
        StringTokenizer tokens = new StringTokenizer(path, SEPARATOR_STRING, false);
        this.len = tokens.countTokens();
        if (this.len == 0 || path.charAt(0) == ':' || path.charAt(path.length() - 1) == ':') {
            throw new IllegalArgumentException("No valid path '" + path + "'");
        }
        this.tags = new String[this.len];
        this.qualifiers = new int[this.len];
        for (int i = 0; i < this.len; ++i) {
            String tag = tokens.nextToken().trim();
            if (tag.length() == 0) {
                throw new IllegalArgumentException("Empty tag in '" + path + "' is not valid");
            }
            this.set(i, tag);
        }
    }

    private void set(int pos, String tag) {
        int qualifier = -1;
        int separator = tag.indexOf(35);
        if (separator > 0) {
            try {
                qualifier = Integer.parseInt(tag.substring(separator + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal tag qualifier in '" + tag + "'");
            }
            tag = tag.substring(0, separator);
        }
        this.tags[pos] = tag;
        this.qualifiers[pos] = qualifier;
        this.hash += tag.hashCode();
    }

    public TagPath(TagPath other) {
        this(other, other.len);
    }

    public TagPath(TagPath other, int length) {
        this.len = length;
        this.tags = other.tags;
        this.qualifiers = other.qualifiers;
        for (int i = 0; i < this.len; ++i) {
            this.hash += this.tags[i].hashCode();
        }
    }

    public TagPath(TagPath other, String tag) {
        this.len = other.len + 1;
        this.tags = new String[this.len];
        this.qualifiers = new int[this.len];
        System.arraycopy(other.tags, 0, this.tags, 0, other.len);
        System.arraycopy(other.qualifiers, 0, this.qualifiers, 0, other.len);
        this.tags[this.len - 1] = tag;
        this.qualifiers[this.len - 1] = -1;
        this.hash = other.hash + tag.hashCode();
    }

    TagPath(Stack path) throws IllegalArgumentException {
        this.len = path.size();
        this.tags = new String[this.len];
        this.qualifiers = new int[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.set(i, path.pop().toString());
        }
    }

    public boolean startsWith(TagPath prefix) {
        if (prefix.len > this.len) {
            return false;
        }
        for (int i = 0; i < prefix.len; ++i) {
            if (this.tags[i].equals(prefix.tags[i]) && this.qualifiers[i] == prefix.qualifiers[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TagPath)) {
            return false;
        }
        TagPath other = (TagPath)obj;
        if (other.len != this.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.tags[i].equals(other.tags[i]) && this.qualifiers[i] == other.qualifiers[i]) continue;
            return false;
        }
        return true;
    }

    public String get(int which) {
        return this.tags[which];
    }

    public String getFirst() {
        return this.get(0);
    }

    public String getLast() {
        return this.get(this.len - 1);
    }

    public int length() {
        return this.len;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.len; ++i) {
            if (i > 0) {
                result.append(':');
            }
            result.append(this.tags[i]);
            if (this.qualifiers[i] < 0) continue;
            result.append('#');
            result.append(this.qualifiers[i]);
        }
        return result.toString();
    }

    public int hashCode() {
        return this.hash;
    }

    public String getName() {
        if (this.name == null) {
            int i = this.length() - 1;
            String tag = this.get(i);
            while (i > 1 && !Character.isLetter(tag.charAt(0))) {
                tag = this.get(--i);
            }
            this.name = Gedcom.getName(tag);
            if (i > 1) {
                this.name = this.name + " - " + Gedcom.getName(this.get(i - 1));
            }
        }
        return this.name;
    }

    public static TagPath get(Property prop) {
        String p = prop.getTag();
        while (!(prop instanceof Entity)) {
            prop = prop.getParent();
            p = prop.getTag() + ":" + p;
        }
        return new TagPath(p);
    }

    public static TagPath[] toArray(Collection c) {
        return c.toArray(new TagPath[c.size()]);
    }

    public static TagPath[] toArray(String[] paths) {
        TagPath[] result = new TagPath[paths.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new TagPath(paths[i]);
        }
        return result;
    }

    public void iterate(Property root, PropertyVisitor visitor) {
        String tag = this.get(0);
        char c = tag.charAt(0);
        if (c == '.' || c == '*') {
            this.iterate(0, root, visitor);
        } else if (tag.equals(root.getTag())) {
            this.iterate(1, root, visitor);
        }
    }

    private boolean iterate(int pos, Property prop, PropertyVisitor visitor) {
        String tag;
        while (true) {
            if (pos == this.length()) {
                return visitor.leaf(prop);
            }
            tag = this.get(pos);
            if (tag.equals("..")) {
                if ((prop = prop.getParent()) == null) {
                    return false;
                }
            } else if (!tag.equals(".")) {
                if (!tag.equals("*")) break;
                if (!(prop instanceof PropertyXRef) || ((PropertyXRef)prop).getTarget() == null) {
                    return false;
                }
                prop = ((PropertyXRef)prop).getTarget();
            }
            ++pos;
        }
        if (!visitor.recursion(prop, tag)) {
            return false;
        }
        int qualifier = this.qualifiers[pos];
        int c = 0;
        for (int i = 0; i < prop.getNoOfProperties(); ++i) {
            Property child = prop.getProperty(i);
            if (!tag.equals(child.getTag()) || qualifier >= 0 && qualifier != c++ || this.iterate(pos + 1, child, visitor)) continue;
            return false;
        }
        return true;
    }
}

