/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.util.swing.ImageIcon;
import java.util.ArrayList;
import java.util.List;

public abstract class PropertyXRef
extends Property {
    private PropertyXRef target = null;
    private String value = "";

    protected PropertyXRef() {
    }

    void beforeDelNotify() {
        if (this.target != null) {
            PropertyXRef other = this.target;
            Property pother = other.getParent();
            this.unlink();
            pother.delProperty(other);
        }
        super.beforeDelNotify();
    }

    public Entity getTargetEntity() {
        return this.target == null ? null : this.target.getEntity();
    }

    protected Entity getCandidate() throws GedcomException {
        if (this.target != null) {
            throw new IllegalArgumentException("Already linked");
        }
        Entity entity = this.getGedcom().getEntity(this.getTargetType(), this.value);
        if (entity == null) {
            throw new GedcomException(resources.getString("error.notfound", new String[]{Gedcom.getName(this.getTargetType()), this.value}));
        }
        return entity;
    }

    protected boolean isCandidate(Entity entity) {
        if (this.target != null) {
            return false;
        }
        return this.value.length() == 0 || entity.getId().equals(this.value);
    }

    public String getValue() {
        return this.target != null ? '@' + this.target.getEntity().getId() + '@' : '@' + this.value + '@';
    }

    public boolean isValid() {
        return this.target != null;
    }

    public abstract void link() throws GedcomException;

    protected void link(PropertyXRef target) {
        if (this.target != null) {
            throw new IllegalArgumentException("can't link while target!=null");
        }
        if (target == null) {
            throw new IllegalArgumentException("can't link to targe null");
        }
        this.target = target;
        target.target = this;
        this.propagateXRefLinked(this, target);
    }

    public void unlink() {
        if (this.target == null) {
            throw new IllegalArgumentException("can't unlink without target");
        }
        PropertyXRef old = this.target;
        this.target.target = null;
        this.target = null;
        this.propagateXRefUnlinked(this, old);
    }

    public String getDisplayValue() {
        if (this.target == null) {
            return this.getValue();
        }
        return this.target.getEntity().toString();
    }

    protected String getForeignDisplayValue() {
        Entity entity = this.getEntity();
        Property parent = this.getParent();
        String by = parent != entity ? entity.toString() + " - " + parent.getPropertyName() : entity.toString();
        return resources.getString("foreign.xref", by);
    }

    public PropertyXRef getTarget() {
        return this.target;
    }

    public void setValue(String set) {
        if (this.target != null) {
            return;
        }
        String old = this.getParent() == null ? null : this.getValue();
        this.value = set.replace('@', ' ').trim();
        if (old != null) {
            this.propagatePropertyChanged(this, old);
        }
    }

    Property init(MetaProperty meta, String value) throws GedcomException {
        meta.assertTag(this.getTag());
        value = value.trim();
        if (!value.startsWith("@") || !value.endsWith("@")) {
            throw new GedcomException(resources.getString("error.norefvalue", new String[]{value, Gedcom.getName(this.getTag())}));
        }
        return super.init(meta, value);
    }

    public String toString() {
        Entity e = this.getTargetEntity();
        if (e == null) {
            return super.toString();
        }
        return e.toString();
    }

    public abstract String getTargetType();

    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        String key = "prop." + this.getTag().toLowerCase() + ".veto";
        if (resources.contains(key)) {
            return resources.getString(key);
        }
        return resources.getString("prop.xref.veto");
    }

    public static Entity[] getReferences(Entity ent) {
        ArrayList<Entity> result = new ArrayList<Entity>(10);
        List ps = ent.getProperties(PropertyXRef.class);
        for (int p = 0; p < ps.size(); ++p) {
            PropertyXRef px = (PropertyXRef)ps.get(p);
            PropertyXRef target = px.getTarget();
            if (target == null) continue;
            result.add(target.getEntity());
        }
        return result.toArray(new Entity[result.size()]);
    }

    public ImageIcon getImage(boolean checkValid) {
        return this.overlay(super.getImage(false));
    }

    protected ImageIcon overlay(ImageIcon img) {
        ImageIcon overlay = this.target != null ? MetaProperty.IMG_LINK : MetaProperty.IMG_ERROR;
        return img.getOverLayed(overlay);
    }

    public void setPrivate(boolean set, boolean recursively) {
    }

    public int compareTo(Object o) {
        if (!(o instanceof PropertyXRef)) {
            return super.compareTo(o);
        }
        PropertyXRef that = (PropertyXRef)o;
        if (this.getTargetEntity() == null || that.getTargetEntity() == null) {
            return super.compareTo(that);
        }
        return this.compare(this.getTargetEntity().toString(), that.getTargetEntity().toString());
    }
}

