/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;

public class PropertySex
extends Property {
    private static final String TAG = "SEX";
    private static final ImageIcon IMG_UNKNOWN = Grammar.V55.getMeta(new TagPath("INDI:SEX")).getImage();
    private static final ImageIcon IMG_MALE = Grammar.V55.getMeta(new TagPath("INDI:SEX")).getImage("male");
    private static final ImageIcon IMG_FEMALE = Grammar.V55.getMeta(new TagPath("INDI:SEX")).getImage("female");
    public static final String TXT_SEX = Gedcom.getResources().getString("prop.sex");
    public static final String TXT_MALE = Gedcom.getResources().getString("prop.sex.male");
    public static final String TXT_FEMALE = Gedcom.getResources().getString("prop.sex.female");
    public static final String TXT_UNKNOWN = Gedcom.getResources().getString("prop.sex.unknown");
    public static final int UNKNOWN = 0;
    public static final int MALE = 1;
    public static final int FEMALE = 2;
    private int sex = 0;
    private String sexAsString;

    public PropertySex() {
    }

    public PropertySex(String sex) {
        this.setValue(sex);
    }

    public static ImageIcon getImage(int sex) {
        switch (sex) {
            case 1: {
                return IMG_MALE;
            }
            case 2: {
                return IMG_FEMALE;
            }
        }
        return IMG_UNKNOWN;
    }

    public ImageIcon getImage(boolean checkValid) {
        if (checkValid && !this.isValid()) {
            return super.getImage(true);
        }
        switch (this.sex) {
            case 1: {
                return IMG_MALE;
            }
            case 2: {
                return IMG_FEMALE;
            }
        }
        return super.getImage(checkValid);
    }

    public boolean isValid() {
        return this.sexAsString == null;
    }

    public static String getLabelForSex(int which) {
        switch (which) {
            case 1: {
                return Gedcom.getResources().getString("prop.sex.male");
            }
            case 2: {
                return Gedcom.getResources().getString("prop.sex.female");
            }
        }
        return Gedcom.getResources().getString("prop.sex.unknown");
    }

    public int getSex() {
        return this.sex;
    }

    public String getTag() {
        return TAG;
    }

    Property init(MetaProperty meta, String value) throws GedcomException {
        meta.assertTag(TAG);
        return super.init(meta, value);
    }

    public String getValue() {
        if (this.sexAsString != null) {
            return this.sexAsString;
        }
        if (this.sex == 1) {
            return "M";
        }
        if (this.sex == 2) {
            return "F";
        }
        return "";
    }

    public String getDisplayValue() {
        return PropertySex.getLabelForSex(this.sex);
    }

    public void setSex(int newSex) {
        String old = this.getValue();
        this.sexAsString = null;
        this.sex = newSex;
        this.propagatePropertyChanged(this, old);
    }

    public void setValue(String newValue) {
        String old = this.getValue();
        if (newValue.trim().length() > 1) {
            this.sexAsString = newValue;
        } else if (newValue.length() == 0) {
            this.sexAsString = null;
            this.sex = 0;
        } else {
            switch (newValue.charAt(0)) {
                case 'F': 
                case 'f': {
                    this.sex = 2;
                    this.sexAsString = null;
                    break;
                }
                case 'M': 
                case 'm': {
                    this.sex = 1;
                    this.sexAsString = null;
                    break;
                }
                default: {
                    this.sexAsString = newValue;
                }
            }
        }
        this.propagatePropertyChanged(this, old);
    }

    public static boolean isSex(int tst) {
        return tst == 1 || tst == 2;
    }

    public static int calcOppositeSex(int from, int fallback) {
        if (from == 1) {
            return 2;
        }
        if (from == 2) {
            return 1;
        }
        return fallback;
    }

    public static int calcOppositeSex(Indi from, int fallback) {
        if (from == null) {
            return fallback;
        }
        return PropertySex.calcOppositeSex(from.getSex(), fallback);
    }
}

