/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyChoiceValue;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;

public class PropertyRelationship
extends PropertyChoiceValue {
    private TagPath anchor = null;

    public String getValue() {
        String value = super.getValue();
        TagPath anchor = this.getAnchor();
        if (anchor != null && anchor.length() > 0) {
            value = value + '@' + anchor.toString();
        }
        return value;
    }

    public String getDisplayValue() {
        return super.getValue();
    }

    public void setValue(String value) {
        int i = value.lastIndexOf(64);
        if (i >= 0) {
            try {
                this.anchor = new TagPath(value.substring(i + 1));
                if (!this.getAnchor().equals(this.anchor)) {
                    PropertyAssociation asso = (PropertyAssociation)this.getParent();
                    PropertyXRef target = asso.getTarget();
                    asso.unlink();
                    target.getParent().delProperty(target);
                    asso.link();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            value = value.substring(0, i);
        }
        super.setValue(value);
    }

    Property getTarget() {
        Property parent = this.getParent();
        if (parent instanceof PropertyAssociation) {
            return ((PropertyAssociation)parent).getTarget();
        }
        return null;
    }

    TagPath getAnchor() {
        Property panchor;
        Property target = this.getTarget();
        if (target != null && !((panchor = target.getParent()) instanceof Entity) && panchor != null) {
            TagPath result = panchor.getPath(false);
            return panchor.getEntity().getProperty(result) == panchor ? result : panchor.getPath(true);
        }
        return this.anchor;
    }
}

