/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertyChoiceValue;
import genj.gedcom.TagPath;
import genj.util.DirectAccessTokenizer;
import genj.util.ReferenceSet;
import genj.util.swing.ImageIcon;
import java.util.List;
import java.util.Set;

public class PropertyPlace
extends PropertyChoiceValue {
    private static final boolean USE_SPACES = Options.getInstance().isUseSpacedPlaces;
    public static final ImageIcon IMAGE = Grammar.V55.getMeta(new TagPath("INDI:BIRT:PLAC")).getImage();
    public static final String JURISDICTION_SEPARATOR = ",";
    private static final String JURISDICTION_RESOURCE_PREFIX = "prop.plac.jurisdiction.";
    public static final String TAG = "PLAC";
    public static final String FORM = "FORM";

    protected String trim(String value) {
        String jurisdiction;
        StringBuffer buf = new StringBuffer(value.length());
        DirectAccessTokenizer jurisdictions = new DirectAccessTokenizer(value, JURISDICTION_SEPARATOR);
        int i = 0;
        while ((jurisdiction = jurisdictions.get(i, true)) != null) {
            if (i > 0) {
                buf.append(JURISDICTION_SEPARATOR);
                if (USE_SPACES) {
                    buf.append(' ');
                }
            }
            buf.append(jurisdiction);
            ++i;
        }
        return buf.toString().intern();
    }

    protected boolean remember(String theOld, String theNew) {
        String jurisdiction;
        if (!super.remember(theOld, theNew)) {
            return false;
        }
        Gedcom gedcom = this.getGedcom();
        DirectAccessTokenizer jurisdictions = new DirectAccessTokenizer(theOld, JURISDICTION_SEPARATOR);
        int i = 0;
        while ((jurisdiction = jurisdictions.get(i, true)) != null) {
            if (jurisdiction.length() > 0) {
                gedcom.getReferenceSet("PLAC." + i).remove(jurisdiction, this);
            }
            ++i;
        }
        jurisdictions = new DirectAccessTokenizer(theNew, JURISDICTION_SEPARATOR);
        i = 0;
        while ((jurisdiction = jurisdictions.get(i, true)) != null) {
            if (jurisdiction.length() > 0) {
                gedcom.getReferenceSet("PLAC." + i).add(jurisdiction.intern(), this);
            }
            ++i;
        }
        return true;
    }

    public String getHierarchy() {
        String result = "";
        Property pformat = this.getProperty(FORM);
        if (pformat != null) {
            result = pformat.getValue();
        } else {
            Gedcom ged = this.getGedcom();
            if (ged != null) {
                result = ged.getPlaceFormat();
            }
        }
        return result;
    }

    public void setHierarchy(boolean global, String format) {
        if (!global) {
            throw new IllegalArgumentException("non-global n/a");
        }
        this.getGedcom().setPlaceFormat(format);
        this.propagatePropertyChanged(this, this.getValue());
    }

    public PropertyPlace[] getSameChoices(int hierarchyLevel) {
        String jurisdiction = this.getJurisdiction(hierarchyLevel);
        if (jurisdiction == null) {
            return null;
        }
        Set places = this.getGedcom().getReferenceSet("PLAC." + hierarchyLevel).getReferences(jurisdiction);
        return places.toArray(new PropertyPlace[places.size()]);
    }

    public String[] getAllJurisdictions(int hierarchyLevel, boolean sort) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new String[0];
        }
        return PropertyPlace.getAllJurisdictions(gedcom, hierarchyLevel, sort);
    }

    public static String[] getAllJurisdictions(Gedcom gedcom, int hierarchyLevel, boolean sort) {
        ReferenceSet refset = gedcom.getReferenceSet(hierarchyLevel < 0 ? TAG : "PLAC." + hierarchyLevel);
        List jurisdictions = refset.getKeys(sort ? gedcom.getCollator() : null);
        return jurisdictions.toArray(new String[jurisdictions.size()]);
    }

    public String getFirstAvailableJurisdiction() {
        DirectAccessTokenizer jurisdictions = new DirectAccessTokenizer(this.getValue(), JURISDICTION_SEPARATOR);
        String result = "";
        int i = 0;
        while (result.length() == 0) {
            result = jurisdictions.get(i, true);
            if (result == null) {
                return "";
            }
            ++i;
        }
        return result;
    }

    public String getJurisdiction(int hierarchyLevel) {
        return new DirectAccessTokenizer(this.getValue(), JURISDICTION_SEPARATOR).get(hierarchyLevel, true);
    }

    public String getCity() {
        int cityIndex = this.getCityIndex();
        if (cityIndex < 0) {
            return this.getFirstAvailableJurisdiction();
        }
        String city = new DirectAccessTokenizer(this.getValue(), JURISDICTION_SEPARATOR).get(cityIndex, true);
        return city != null ? city : "";
    }

    public String getValueStartingWithCity() {
        String result = this.getValue();
        int cityIndex = this.getCityIndex();
        if (cityIndex <= 0) {
            return result;
        }
        return new DirectAccessTokenizer(result, JURISDICTION_SEPARATOR).getSubstring(cityIndex);
    }

    private int getCityIndex() {
        String hierarchy = this.getHierarchy();
        if (hierarchy.length() == 0) {
            return -1;
        }
        Set cityKeys = Options.getInstance().placeHierarchyCityKeys;
        DirectAccessTokenizer hs = new DirectAccessTokenizer(hierarchy, JURISDICTION_SEPARATOR);
        int index = 0;
        while (hs.get(index) != null) {
            if (cityKeys.contains(hs.get(index, true).toLowerCase())) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

