/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.crypto.Enigma;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.MetaProperty;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.Submitter;
import genj.util.ReferenceSet;
import genj.util.WordBuffer;
import java.util.ArrayList;
import java.util.List;

public class PropertyName
extends Property {
    public static final String TAG = "NAME";
    private static final String KEY_LASTNAME = "NAME.last";
    private static final String KEY_FIRSTNAME = "NAME.first";
    private String lastName = "";
    private String firstName = "";
    private String suffix = "";
    private String nameAsString;

    public PropertyName() {
    }

    public PropertyName(String first, String last) {
        this.setName(first, last);
    }

    public PropertyName(String name) {
        this.setValue(name);
    }

    public int compareTo(Object o) {
        if (!(o instanceof PropertyName)) {
            return super.compareTo(o);
        }
        PropertyName that = (PropertyName)o;
        int result = this.compare(this.getLastName(), that.getLastName());
        if (result != 0) {
            return result;
        }
        return this.compare(this.getFirstName(), that.getFirstName());
    }

    public String getFirstName() {
        return this.firstName;
    }

    public boolean isValid() {
        if (!(this.getEntity() instanceof Indi) && !(this.getEntity() instanceof Submitter)) {
            return true;
        }
        return this.nameAsString == null;
    }

    public static String getLabelForFirstName() {
        return Gedcom.getResources().getString("prop.name.firstname");
    }

    public static String getLabelForLastName() {
        return Gedcom.getResources().getString("prop.name.lastname");
    }

    public static String getLabelForSuffix() {
        return Gedcom.getResources().getString("prop.name.suffix");
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getName() {
        if (this.nameAsString != null) {
            return this.nameAsString;
        }
        if (this.firstName.length() == 0) {
            return this.lastName;
        }
        return this.lastName + ", " + this.firstName;
    }

    public String getTag() {
        return TAG;
    }

    Property init(MetaProperty meta, String value) throws GedcomException {
        meta.assertTag(TAG);
        return super.init(meta, value);
    }

    public String getValue() {
        if (this.nameAsString != null) {
            return this.nameAsString;
        }
        WordBuffer wb = new WordBuffer();
        wb.append(this.firstName);
        if (this.lastName.length() > 0 || this.suffix.length() > 0) {
            wb.append("/" + this.lastName + "/");
        }
        if (this.suffix.length() > 0) {
            wb.append(this.suffix);
        }
        return wb.toString();
    }

    public String getDisplayValue() {
        if (this.nameAsString != null) {
            return this.nameAsString;
        }
        WordBuffer b = new WordBuffer();
        String last = this.getLastName();
        if (last.length() == 0) {
            last = "?";
        }
        b.append(last);
        b.append(this.getSuffix());
        b.setFiller(", ");
        b.append(this.getFirstName());
        return b.toString();
    }

    public PropertyName setName(String setLast) {
        return this.setName(this.firstName, setLast, this.suffix);
    }

    public PropertyName setName(String setFirst, String setLast) {
        return this.setName(setFirst, setLast, this.suffix);
    }

    public PropertyName setName(String setFirst, String setLast, String setSuffix) {
        return this.setName(setFirst, setLast, setSuffix, false);
    }

    public PropertyName setName(String first, String last, String suff, boolean replaceAllLastNames) {
        String old;
        String string = old = this.getParent() == null ? null : this.getValue();
        if (Options.getInstance().isUpperCaseNames) {
            last = last.toUpperCase();
        }
        first = first.trim().intern();
        last = last.trim().intern();
        suff = suff.trim();
        if (replaceAllLastNames) {
            Property[] others = this.getSameLastNames();
            for (int i = 0; i < others.length; ++i) {
                Property other = others[i];
                if (!(other instanceof PropertyName) || other == this) continue;
                ((PropertyName)other).setName(last);
            }
        }
        this.remember(first, last);
        this.nameAsString = null;
        this.lastName = last;
        this.firstName = first;
        this.suffix = suff;
        if (old != null) {
            this.propagatePropertyChanged(this, old);
        }
        return this;
    }

    void afterAddNotify() {
        super.afterAddNotify();
        this.remember(this.firstName, this.lastName);
    }

    void beforeDelNotify() {
        this.remember("", "");
        super.beforeDelNotify();
    }

    public void setValue(String newValue) {
        if (Enigma.isEncrypted(newValue)) {
            this.setName("", "", "");
            this.nameAsString = newValue;
            return;
        }
        if (newValue.indexOf(47) < 0) {
            this.setName(newValue, "", "");
            return;
        }
        String f = newValue.substring(0, newValue.indexOf(47)).trim();
        String l = newValue.substring(newValue.indexOf(47) + 1);
        if (l.indexOf(47) == -1) {
            this.setName("", "", "");
            this.nameAsString = newValue;
            return;
        }
        this.suffix = l.substring(l.indexOf(47) + 1);
        l = l.substring(0, l.indexOf(47));
        this.setName(f, l, this.suffix);
    }

    public List getLastNames(boolean sortByName) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new ArrayList(0);
        }
        return PropertyName.getLastNames(gedcom, sortByName);
    }

    public List getFirstNames(boolean sortByName) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new ArrayList(0);
        }
        return PropertyName.getFirstNames(gedcom, sortByName);
    }

    public static List getLastNames(Gedcom gedcom, boolean sortByName) {
        return gedcom.getReferenceSet(KEY_LASTNAME).getKeys(sortByName ? gedcom.getCollator() : null);
    }

    public static List getFirstNames(Gedcom gedcom, boolean sortByName) {
        return gedcom.getReferenceSet(KEY_FIRSTNAME).getKeys(sortByName ? gedcom.getCollator() : null);
    }

    public int getLastNameCount() {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return 0;
        }
        return PropertyName.getLastNameCount(gedcom, this.getLastName());
    }

    public static int getLastNameCount(Gedcom gedcom, String last) {
        return gedcom.getReferenceSet(KEY_LASTNAME).getReferences(last).size();
    }

    public Property[] getSameLastNames() {
        return PropertyName.toArray(this.getGedcom().getReferenceSet(KEY_LASTNAME).getReferences(this.getLastName()));
    }

    private void remember(String newFirst, String newLast) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return;
        }
        ReferenceSet refSet = gedcom.getReferenceSet(KEY_LASTNAME);
        if (this.lastName.length() > 0) {
            refSet.remove(this.lastName, this);
        }
        if (newLast.length() > 0) {
            refSet.add(newLast, this);
        }
        refSet = gedcom.getReferenceSet(KEY_FIRSTNAME);
        if (this.firstName.length() > 0) {
            refSet.remove(this.firstName, this);
        }
        if (newFirst.length() > 0) {
            refSet.add(newFirst, this);
        }
    }
}

