/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Options;
import genj.gedcom.Property;
import java.util.ArrayList;

public class PropertyMultilineValue
extends Property
implements MultiLineProperty {
    private String tag;
    private String lines = "";

    public String getTag() {
        return this.tag;
    }

    Property init(MetaProperty meta, String value) throws GedcomException {
        this.tag = meta.getTag();
        return super.init(meta, value);
    }

    public void setValue(String setValue) {
        String old = this.getValue();
        this.lines = setValue;
        this.propagatePropertyChanged(this, old);
    }

    public String getDisplayValue() {
        return this.getValue();
    }

    public String getValue() {
        return this.lines.toString();
    }

    public String[] getLines() {
        ArrayList<String> result = new ArrayList<String>();
        MultiLineProperty.Iterator it = this.getLineIterator();
        do {
            result.add(it.getValue());
        } while (it.next());
        return result.toArray(new String[result.size()]);
    }

    public MultiLineProperty.Iterator getLineIterator() {
        return new ConcContIterator(this.getTag(), this.lines);
    }

    public MultiLineProperty.Collector getLineCollector() {
        return new ConcContCollector();
    }

    private class ConcContCollector
    implements MultiLineProperty.Collector {
        private StringBuffer buffer;

        private ConcContCollector() {
            this.buffer = new StringBuffer(PropertyMultilineValue.this.lines.toString());
        }

        public boolean append(int indent, String tag, String value) {
            if (indent != 1) {
                return false;
            }
            boolean isCont = "CONT".equals(tag);
            boolean isConc = "CONC".equals(tag);
            if (!isConc && !isCont) {
                return false;
            }
            if (isCont) {
                this.buffer.append('\n');
            }
            this.buffer.append(value);
            return true;
        }

        public String getValue() {
            return this.buffer.toString();
        }
    }

    private static class ConcContIterator
    implements MultiLineProperty.Iterator {
        private String firstTag;
        private String currentTag;
        private String nextTag;
        private String value;
        private int start;
        private int end;
        private int valueLineBreak = Options.getInstance().getValueLineBreak();

        ConcContIterator(String top, String initValue) {
            this.firstTag = top;
            this.setValue(initValue);
        }

        public void setValue(String setValue) {
            this.value = setValue;
            this.currentTag = this.firstTag;
            this.nextTag = this.firstTag;
            this.start = 0;
            this.end = 0;
            this.next();
        }

        public int getIndent() {
            return this.currentTag == this.firstTag ? 0 : 1;
        }

        public String getTag() {
            return this.currentTag;
        }

        public String getValue() {
            return this.value.substring(this.start, this.end);
        }

        public boolean next() {
            if (this.end == this.value.length()) {
                return false;
            }
            this.start = this.end;
            this.currentTag = this.nextTag;
            this.end = this.value.length();
            if (this.currentTag != this.firstTag && this.value.charAt(this.start) == '\n') {
                ++this.start;
            }
            for (int i = this.start; i < this.end; ++i) {
                if (this.value.charAt(i) != '\n') continue;
                this.end = i;
                this.nextTag = "CONT";
                break;
            }
            if (this.end - this.start > this.valueLineBreak) {
                this.end = this.start + this.valueLineBreak;
                this.nextTag = "CONC";
                while (this.end < this.value.length() && this.end > this.start + 1 && (Character.isWhitespace(this.value.charAt(this.end - 1)) || Character.isWhitespace(this.value.charAt(this.end)))) {
                    --this.end;
                }
            }
            return this.start != this.value.length();
        }
    }
}

