/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;

public class PropertyHusband
extends PropertyXRef {
    public static final String TAG = "HUSB";
    public static final String LABEL_FATHER = Gedcom.resources.getString("HUSB.father");

    public PropertyHusband() {
    }

    protected PropertyHusband(String target) {
        this.setValue(target);
    }

    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.husb.veto");
    }

    public Indi getHusband() {
        return (Indi)this.getTargetEntity();
    }

    public String getTag() {
        return TAG;
    }

    public void link() throws GedcomException {
        PropertyFamilySpouse pfs;
        Fam fam;
        try {
            fam = (Fam)this.getEntity();
        }
        catch (ClassCastException ex) {
            throw new GedcomException(resources.getString("error.noenclosingfam"));
        }
        if (fam.getHusband() != null) {
            throw new GedcomException(resources.getString("error.already.spouse", new String[]{fam.getHusband().toString(), fam.toString()}));
        }
        Indi husband = (Indi)this.getCandidate();
        if (fam.getWife() == husband) {
            throw new GedcomException(resources.getString("error.already.spouse", new String[]{husband.toString(), fam.toString()}));
        }
        if (husband.isDescendantOf(fam)) {
            throw new GedcomException(resources.getString("error.already.descendant", new String[]{husband.toString(), fam.toString()}));
        }
        Property[] ps = husband.getProperties(new TagPath("INDI:FAMS"));
        for (int i = 0; i < ps.length; ++i) {
            pfs = (PropertyFamilySpouse)ps[i];
            if (!pfs.isCandidate(fam)) continue;
            this.link(pfs);
            return;
        }
        pfs = new PropertyFamilySpouse();
        husband.addProperty(pfs);
        this.link(pfs);
    }

    public String getTargetType() {
        return "INDI";
    }
}

