/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.IconValueAvailable;
import genj.gedcom.MetaProperty;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;

public class PropertyFile
extends Property
implements IconValueAvailable {
    public static final ImageIcon DEFAULT_IMAGE = Grammar.V55.getMeta(new TagPath("INDI:OBJE:FILE")).getImage();
    private static final String TAG = "FILE";
    private String file;
    private boolean isRelativeChecked = false;
    private Object valueAsIcon = null;

    public String getTag() {
        return TAG;
    }

    Property init(MetaProperty meta, String value) throws GedcomException {
        meta.assertTag(TAG);
        return super.init(meta, value);
    }

    public boolean addFile(File file) {
        this.setValue(file.getAbsolutePath(), true);
        return true;
    }

    public String getValue() {
        Gedcom gedcom;
        if (this.file == null) {
            return "";
        }
        if (!this.isRelativeChecked && (gedcom = this.getGedcom()) != null) {
            String relative = gedcom.getOrigin().calcRelativeLocation(this.file);
            if (relative != null) {
                this.file = relative;
            }
            this.isRelativeChecked = true;
        }
        return this.file;
    }

    public synchronized ImageIcon getValueAsIcon() {
        ImageIcon result;
        if (this.valueAsIcon instanceof SoftReference) {
            result = (ImageIcon)((SoftReference)this.valueAsIcon).get();
            if (result != null) {
                return result;
            }
            this.valueAsIcon = null;
        }
        if (this.valueAsIcon == null) {
            result = this.loadValueAsIcon();
            this.valueAsIcon = result != null ? new SoftReference<ImageIcon>(result) : new Object();
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ImageIcon loadValueAsIcon() {
        ImageIcon result = null;
        if (this.file != null && this.file.trim().length() > 0) {
            InputStream in = null;
            try {
                in = this.getGedcom().getOrigin().open(this.file);
                long size = in.available();
                result = new ImageIcon(this.file, in);
                int w = result.getIconWidth();
                int h = result.getIconHeight();
                if (w <= 0 || h <= 0) {
                    throw new IllegalArgumentException();
                }
                int max = PropertyFile.getMaxValueAsIconSize(false);
                if (max > 0 && size > (long)max) {
                    double ratio = (double)w / (double)h;
                    int maxarea = Math.max(1024, max / 4);
                    w = (int)Math.sqrt((double)maxarea * ratio);
                    h = (int)Math.sqrt((double)maxarea / ratio);
                    BufferedImage thumb = new BufferedImage(w, h, 1);
                    Graphics2D g = (Graphics2D)thumb.getGraphics();
                    g.drawImage(result.getImage(), 0, 0, w, h, null);
                    result = new ImageIcon(thumb);
                }
            }
            catch (Throwable t) {
                result = null;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return result;
    }

    public void setValue(String value) {
        String old = this.getValue();
        this.file = value.replace('\\', '/');
        this.isRelativeChecked = false;
        this.valueAsIcon = null;
        this.propagatePropertyChanged(this, old);
    }

    public void setValue(String value, boolean updateMeta) {
        Property form;
        this.setValue(value);
        Property media = this.getParent();
        if (!updateMeta || !media.getTag().equals("OBJE")) {
            return;
        }
        Property parent = this;
        if (!this.getMetaProperty().allows("FORM")) {
            if (!media.getMetaProperty().allows("FORM")) {
                return;
            }
            parent = media;
        }
        if ((form = parent.getProperty("FORM")) == null) {
            parent.addProperty("FORM", PropertyFile.getSuffix(this.file));
        } else {
            form.setValue(PropertyFile.getSuffix(this.file));
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.getGedcom().getOrigin().open(this.file);
    }

    public File getFile() {
        File result = this.getGedcom().getOrigin().getFile(this.file);
        if (result == null || !result.exists() || !result.isFile()) {
            return null;
        }
        return result;
    }

    public static int getMaxValueAsIconSize(boolean kb) {
        return (kb ? 1 : 1024) * Options.getInstance().getMaxImageFileSizeKB();
    }

    public String getSuffix() {
        return PropertyFile.getSuffix(this.file);
    }

    public static String getSuffix(String value) {
        int i;
        String result = "";
        if (value != null && (i = value.lastIndexOf(46)) >= 0) {
            result = value.substring(i + 1);
        }
        return result;
    }
}

