/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyXRef;
import java.util.List;

public class PropertyFamilyChild
extends PropertyXRef {
    public Boolean isBiological() {
        String parent = this.getParent().getTag();
        if ("ADOP".equals(parent)) {
            return Boolean.FALSE;
        }
        if ("BIRT".equals(parent)) {
            return Boolean.TRUE;
        }
        Property pedi = this.getProperty("PEDI");
        if (pedi != null) {
            String value = pedi.getValue();
            if ("birth".equals(value)) {
                return Boolean.TRUE;
            }
            if ("adopted".equals(value)) {
                return Boolean.FALSE;
            }
            if ("foster".equals(value)) {
                return Boolean.FALSE;
            }
            if ("sealing".equals(value)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected String getForeignDisplayValue() {
        Property adop = this.getParent();
        if (adop instanceof PropertyEvent && adop.getTag().equals("ADOP")) {
            return resources.getString("foreign.ADOP", this.getEntity().toString());
        }
        return super.getForeignDisplayValue();
    }

    public Fam getFamily() {
        return (Fam)this.getTargetEntity();
    }

    public String getTag() {
        return "FAMC";
    }

    public void link() throws GedcomException {
        Indi indi;
        try {
            indi = (Indi)this.getEntity();
        }
        catch (ClassCastException ex) {
            throw new GedcomException(resources.getString("error.noenclosingindi"));
        }
        Fam fam = (Fam)this.getCandidate();
        Indi father = fam.getHusband();
        Indi mother = fam.getWife();
        if (indi.isAncestorOf(fam)) {
            throw new GedcomException(resources.getString("error.already.ancestor", new String[]{indi.toString(), fam.toString()}));
        }
        List childs = fam.getProperties(PropertyChild.class);
        int j = childs.size();
        for (int i = 0; i < j; ++i) {
            PropertyChild prop = (PropertyChild)childs.get(i);
            if (!prop.isCandidate(indi)) continue;
            this.link(prop);
            return;
        }
        PropertyChild xref = new PropertyChild();
        fam.addProperty(xref);
        this.link(xref);
    }

    public String getTargetType() {
        return "FAM";
    }
}

