/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;

public class PropertyEvent
extends Property {
    private String tag;
    private boolean knownToHaveHappened;

    public PropertyDate getDate() {
        return this.getDate(true);
    }

    public PropertyDate getDate(boolean valid) {
        Property prop = this.getProperty("DATE", valid);
        if (prop == null) {
            return null;
        }
        return (PropertyDate)prop;
    }

    public String getDateAsString() {
        Property date = this.getProperty("DATE");
        return date != null ? date.getValue() : "";
    }

    public String getTag() {
        return this.tag;
    }

    Property init(MetaProperty meta, String value) throws GedcomException {
        this.tag = meta.getTag();
        if (value.toLowerCase().equals("y")) {
            this.knownToHaveHappened = true;
        }
        return super.init(meta, value);
    }

    public String getValue() {
        return this.knownToHaveHappened ? "Y" : "";
    }

    public void setValue(String value) {
        this.setKnownToHaveHappened(value.toLowerCase().equals("y"));
    }

    public static TagPath[] getTagPaths(Gedcom gedcom) {
        return gedcom.getGrammar().getAllPaths(null, PropertyEvent.class);
    }

    public Boolean isKnownToHaveHappened() {
        if (this.getTag().equals("EVEN")) {
            return null;
        }
        return new Boolean(this.knownToHaveHappened);
    }

    public void setKnownToHaveHappened(boolean set) {
        String old = this.getValue();
        this.knownToHaveHappened = set;
        this.propagatePropertyChanged(this, old);
    }
}

