/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.crypto.Enigma;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertySimpleValue;
import genj.util.ReferenceSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PropertyChoiceValue
extends PropertySimpleValue {
    protected boolean remember(String oldValue, String newValue) {
        Gedcom gedcom = this.getGedcom();
        if (this.isTransient || gedcom == null) {
            return false;
        }
        ReferenceSet refSet = gedcom.getReferenceSet(this.getTag());
        newValue = newValue.intern();
        if (Enigma.isEncrypted(oldValue)) {
            oldValue = "";
        }
        if (Enigma.isEncrypted(newValue)) {
            newValue = "";
        }
        if (oldValue.length() > 0) {
            refSet.remove(oldValue, this);
        }
        if (newValue.length() > 0) {
            refSet.add(newValue, this);
        }
        return true;
    }

    public String[] getChoices(boolean sort) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new String[0];
        }
        return PropertyChoiceValue.getChoices(gedcom, this.getTag(), sort);
    }

    public static String[] getChoices(Gedcom gedcom, String tag, boolean sort) {
        List choices = gedcom.getReferenceSet(tag).getKeys(sort ? gedcom.getCollator() : null);
        return choices.toArray(new String[choices.size()]);
    }

    public static Property[] getSameChoices(Gedcom gedcom, String tag, boolean sort) {
        ReferenceSet references = gedcom.getReferenceSet(tag);
        List choices = references.getKeys(sort ? gedcom.getCollator() : null);
        ArrayList result = new ArrayList(choices.size());
        Iterator it = choices.iterator();
        while (it.hasNext()) {
            String choice = (String)it.next();
            result.addAll(references.getReferences(choice));
        }
        return Property.toArray(result);
    }

    public Property[] getSameChoices() {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new Property[0];
        }
        ReferenceSet refSet = gedcom.getReferenceSet(this.getTag());
        return PropertyChoiceValue.toArray(refSet.getReferences(super.getValue()));
    }

    public void setValue(String value) {
        this.setValueInternal(value.intern());
    }

    public void setValue(String value, boolean global) {
        if (global) {
            Property[] others = this.getSameChoices();
            for (int i = 0; i < others.length; ++i) {
                Property other = others[i];
                if (!(other instanceof PropertyChoiceValue) || other == this) continue;
                ((PropertyChoiceValue)other).setValue(value);
            }
        }
        this.setValue(value);
    }

    private void setValueInternal(String value) {
        this.remember(super.getValue(), value);
        super.setValue(value);
    }

    void afterAddNotify() {
        super.afterAddNotify();
        this.remember("", super.getValue());
    }

    void beforeDelNotify() {
        this.remember(super.getValue(), "");
        super.beforeDelNotify();
    }
}

