/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import java.util.List;

public class PropertyChild
extends PropertyXRef {
    private static final TagPath PATH_FAMCHIL = new TagPath("FAM:CHIL");
    public static final ImageIcon IMG_MALE = Grammar.V55.getMeta(PATH_FAMCHIL).getImage("male");
    public static final ImageIcon IMG_FEMALE = Grammar.V55.getMeta(PATH_FAMCHIL).getImage("female");
    public static final ImageIcon IMG_UNKNOWN = Grammar.V55.getMeta(PATH_FAMCHIL).getImage();

    public PropertyChild() {
    }

    protected PropertyChild(String target) {
        this.setValue(target);
    }

    public Indi getChild() {
        return (Indi)this.getTargetEntity();
    }

    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.chil.veto");
    }

    public String getTag() {
        return "CHIL";
    }

    public void link() throws GedcomException {
        Fam fam;
        try {
            fam = (Fam)this.getEntity();
        }
        catch (ClassCastException ex) {
            throw new GedcomException(resources.getString("error.noenclosingfam"));
        }
        Indi father = fam.getHusband();
        Indi mother = fam.getWife();
        Gedcom gedcom = this.getGedcom();
        Indi child = (Indi)this.getCandidate();
        if (child.isAncestorOf(fam)) {
            throw new GedcomException(resources.getString("error.already.ancestor", new String[]{child.toString(), fam.toString()}));
        }
        List famcs = child.getProperties(PropertyFamilyChild.class);
        int j = famcs.size();
        for (int i = 0; i < j; ++i) {
            PropertyFamilyChild pfc = (PropertyFamilyChild)famcs.get(i);
            if (!pfc.isCandidate(fam)) continue;
            this.link(pfc);
            return;
        }
        PropertyFamilyChild pfc = new PropertyFamilyChild();
        child.addProperty(pfc);
        this.link(pfc);
    }

    public static String getLabelChildAlreadyinFamily(Indi child, Fam fam) {
        return resources.getString("error.already.child", new String[]{child.toString(), fam.toString()});
    }

    public String getTargetType() {
        return "INDI";
    }

    public ImageIcon getImage(boolean checkValid) {
        Indi child = this.getChild();
        if (child == null) {
            return super.getImage(checkValid);
        }
        switch (child.getSex()) {
            case 1: {
                return this.overlay(IMG_MALE);
            }
            case 2: {
                return this.overlay(IMG_FEMALE);
            }
        }
        return this.overlay(IMG_UNKNOWN);
    }
}

