/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.IconValueAvailable;
import genj.gedcom.Media;
import genj.gedcom.MetaProperty;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertySimpleValue;
import genj.util.Base64;
import genj.util.ByteArray;
import genj.util.swing.ImageIcon;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.logging.Level;

public class PropertyBlob
extends Property
implements MultiLineProperty,
IconValueAvailable {
    private static final String TAG = "BLOB";
    private Object content = "";
    private SoftReference icon;
    private boolean noIconAvailable;

    public byte[] getBlobData() {
        if (this.content instanceof byte[]) {
            return (byte[])this.content;
        }
        try {
            this.content = Base64.decode(this.content.toString());
        }
        catch (IllegalArgumentException e) {
            Gedcom.LOG.log(Level.WARNING, "Cannot convert blob base64 in " + this.getGedcom().getName() + "/" + this.getEntity() + "/" + this.getPath() + " into bytes (" + e.getMessage() + ")");
            return new byte[0];
        }
        return (byte[])this.content;
    }

    public String getTitle() {
        Entity e = this.getEntity();
        return e instanceof Media ? ((Media)e).getTitle() : this.getTag();
    }

    public String getTag() {
        return TAG;
    }

    Property init(MetaProperty meta, String value) throws GedcomException {
        meta.assertTag(TAG);
        return super.init(meta, value);
    }

    public String getValue() {
        if (this.content instanceof byte[]) {
            return ((byte[])this.content).length + " Raw Bytes";
        }
        return this.content.toString().length() + " Base64 Bytes";
    }

    public synchronized ImageIcon getValueAsIcon() {
        ImageIcon result;
        if (this.noIconAvailable) {
            return null;
        }
        if (this.icon != null && (result = (ImageIcon)this.icon.get()) != null) {
            return result;
        }
        byte[] bs = this.getBlobData();
        if (bs == null) {
            this.noIconAvailable = true;
            return null;
        }
        try {
            ImageIcon result2 = new ImageIcon(this.getTitle(), bs);
            this.icon = new SoftReference<ImageIcon>(result2);
            return result2;
        }
        catch (Throwable throwable) {
            this.noIconAvailable = true;
            return null;
        }
    }

    public MultiLineProperty.Collector getLineCollector() {
        return new BlobCollector();
    }

    public MultiLineProperty.Iterator getLineIterator() {
        if (this.content instanceof byte[]) {
            return new BlobIterator(Base64.encode((byte[])this.content));
        }
        return new BlobIterator(this.content.toString());
    }

    public void setValue(String value) {
        String old = this.getValue();
        this.content = value;
        this.icon = null;
        this.noIconAvailable = false;
        this.propagatePropertyChanged(this, old);
    }

    public boolean addFile(File file) {
        return this.load(file.getAbsolutePath(), true);
    }

    public boolean load(String file, boolean updateMeta) {
        String old = this.getValue();
        this.noIconAvailable = false;
        this.icon = null;
        if (file.length() != 0) {
            try {
                InputStream in = this.getGedcom().getOrigin().open(file);
                byte[] newContent = new ByteArray(in, in.available(), false).getBytes();
                in.close();
                this.content = newContent;
            }
            catch (Throwable t) {
                return false;
            }
        }
        this.propagatePropertyChanged(this, old);
        Property media = this.getParent();
        if (!updateMeta || !(media instanceof PropertyMedia) && !(media instanceof Media)) {
            return true;
        }
        Property format = media.getProperty("FORM");
        if (format == null) {
            format = media.addProperty(new PropertySimpleValue("FORM"));
        }
        format.setValue(PropertyFile.getSuffix(file));
        return true;
    }

    private static class BlobIterator
    implements MultiLineProperty.Iterator {
        private String base64;
        private int offset;
        private final int LINE = 72;

        public BlobIterator(String base64) {
            this.setValue(base64);
        }

        public void setValue(String base64) {
            this.base64 = base64;
            this.offset = 0;
        }

        public int getIndent() {
            return this.offset == 0 ? 0 : 1;
        }

        public String getTag() {
            return this.offset == 0 ? PropertyBlob.TAG : "CONT";
        }

        public String getValue() {
            return this.base64.substring(this.offset, Math.min(this.offset + 72, this.base64.length()));
        }

        public boolean next() {
            if (this.offset + 72 >= this.base64.length()) {
                return false;
            }
            this.offset += 72;
            return true;
        }
    }

    private class BlobCollector
    implements MultiLineProperty.Collector {
        private StringBuffer buffer = new StringBuffer(1024);

        private BlobCollector() {
            if (PropertyBlob.this.content instanceof String) {
                this.buffer.append(PropertyBlob.this.content);
            }
        }

        public boolean append(int indent, String tag, String value) {
            if (indent != 1) {
                return false;
            }
            if (!"CONT".equals(tag)) {
                return false;
            }
            this.buffer.append(value.trim());
            return true;
        }

        public String getValue() {
            return this.buffer.toString();
        }
    }
}

