/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.PropertySimpleValue;
import genj.gedcom.PropertyXRef;
import genj.util.WordBuffer;

public class PropertyAssociation
extends PropertyXRef {
    public String getDisplayValue() {
        Property place;
        PropertyXRef target = this.getTarget();
        if (target == null) {
            return super.getDisplayValue();
        }
        Property parent = target.getParent();
        if (target == null) {
            return super.getDisplayValue();
        }
        WordBuffer result = new WordBuffer(" - ");
        result.append(parent.getEntity());
        result.append(Gedcom.getName(parent.getTag()));
        Property date = parent.getProperty("DATE");
        if (date != null) {
            result.append(date);
        }
        if ((place = parent.getProperty("PLAC")) != null) {
            result.append(place);
        }
        return result.toString();
    }

    protected String getForeignDisplayValue() {
        Property rela = this.getProperty("RELA");
        if (rela != null && rela.getDisplayValue().length() > 0) {
            return rela.getDisplayValue() + ": " + this.getEntity().toString();
        }
        return super.getForeignDisplayValue();
    }

    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.asso.veto");
    }

    public String getTag() {
        return "ASSO";
    }

    public void link() throws GedcomException {
        Entity ent = this.getCandidate();
        PropertyForeignXRef fxref = new PropertyForeignXRef();
        try {
            PropertyRelationship rela = (PropertyRelationship)this.getProperty("RELA");
            ent.getProperty(rela.getAnchor()).addProperty(fxref);
        }
        catch (Throwable t) {
            ent.addProperty(fxref);
        }
        this.link(fxref);
        Property type = this.getProperty("TYPE");
        if (type == null) {
            type = this.addProperty(new PropertySimpleValue("TYPE"));
        }
        type.setValue(ent.getTag());
    }

    public String getTargetType() {
        if (!this.getMetaProperty().allows("TYPE")) {
            return "INDI";
        }
        Property type = this.getProperty("TYPE");
        if (type != null) {
            return type.getValue();
        }
        String prefix = this.getValue().substring(1, 2);
        for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
            if (!Gedcom.getEntityPrefix(Gedcom.ENTITIES[i]).startsWith(prefix)) continue;
            return Gedcom.ENTITIES[i];
        }
        return "INDI";
    }
}

