/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import java.text.Collator;
import javax.swing.ImageIcon;

public class PropertyAge
extends Property {
    public static final String TAG = "AGE";
    public static final ImageIcon IMG = Grammar.V55.getMeta(new TagPath("INDI:BIRT:AGE")).getImage();
    private Delta age = new Delta(0, 0, 0);
    private int younger_exactly_older = 0;
    private String ageAsString;
    public static String[] PHRASES = new String[]{"CHILD", "INFANT", "STILLBORN"};

    public boolean isValid() {
        Collator c = this.getGedcom().getCollator();
        if (this.ageAsString == null) {
            return true;
        }
        for (int i = 0; i < PHRASES.length; ++i) {
            if (c.compare(PHRASES[i], this.ageAsString) != 0) continue;
            return true;
        }
        return false;
    }

    void afterAddNotify() {
        super.afterAddNotify();
        this.updateAge();
    }

    public String getTag() {
        return TAG;
    }

    public static String getLabelForAge() {
        return Gedcom.getName(TAG);
    }

    Property init(MetaProperty meta, String value) throws GedcomException {
        meta.assertTag(TAG);
        return super.init(meta, value);
    }

    public String getValue() {
        if (this.ageAsString != null) {
            return this.ageAsString;
        }
        if (this.younger_exactly_older > 0) {
            return ">" + this.age.getValue();
        }
        if (this.younger_exactly_older < 0) {
            return "<" + this.age.getValue();
        }
        return this.age.getValue();
    }

    public void setValue(String newValue) {
        String old = this.getValue();
        if (newValue.startsWith(">")) {
            newValue = newValue.substring(1);
            this.younger_exactly_older = 1;
        } else if (newValue.startsWith("<")) {
            newValue = newValue.substring(1);
            this.younger_exactly_older = -1;
        }
        this.ageAsString = this.age.setValue(newValue) ? null : newValue;
        this.propagatePropertyChanged(this, old);
    }

    public boolean updateAge() {
        String old = this.getValue();
        Delta delta = Delta.get(this.getEarlier(), this.getLater());
        if (delta == null) {
            return false;
        }
        this.age = delta;
        this.younger_exactly_older = 0;
        this.ageAsString = null;
        this.propagatePropertyChanged(this, old);
        return true;
    }

    public int compareTo(Object o) {
        PropertyAge other = (PropertyAge)o;
        if (!this.isValid() || !other.isValid()) {
            return super.compareTo(o);
        }
        return this.age.compareTo(other.age);
    }

    public PointInTime getEarlier() {
        Entity e = this.getEntity();
        if (e instanceof Fam) {
            Property parent = this.getParent();
            if (parent.getTag().equals("HUSB")) {
                e = ((Fam)e).getHusband();
            }
            if (parent.getTag().equals("WIFE")) {
                e = ((Fam)e).getWife();
            }
        }
        if (!(e instanceof Indi)) {
            return null;
        }
        PropertyDate birth = ((Indi)e).getBirthDate();
        return birth != null ? birth.getStart() : null;
    }

    public PointInTime getLater() {
        Property parent = this.getParent();
        if (parent.getTag().equals("HUSB") || parent.getTag().equals("WIFE")) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PropertyEvent)) {
            return null;
        }
        PropertyDate date = ((PropertyEvent)parent).getDate();
        return date != null ? date.getStart() : null;
    }
}

