/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Options;
import genj.gedcom.PrivacyPolicy;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySimpleReadOnly;
import genj.gedcom.PropertySimpleValue;
import genj.gedcom.PropertyVisitor;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.ImageIcon;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Property
implements Comparable {
    protected static final String UNSUPPORTED_TAG = "Unsupported Tag";
    private static final Pattern FORMAT_PATTERN = Pattern.compile("\\{(.*?)\\$(.)(.*?)\\}");
    private Property parent = null;
    private List children = null;
    protected ImageIcon image;
    protected ImageIcon imageErr;
    protected boolean isTransient = false;
    private boolean isPrivate = false;
    protected static final Resources resources = Gedcom.resources;
    public static final String LABEL = resources.getString("prop");
    private MetaProperty meta = null;

    void afterAddNotify() {
    }

    void beforeDelNotify() {
        this.delProperties();
    }

    void propagateXRefLinked(PropertyXRef property1, PropertyXRef property2) {
        if (this.parent != null) {
            this.parent.propagateXRefLinked(property1, property2);
        }
    }

    void propagateXRefUnlinked(PropertyXRef property1, PropertyXRef property2) {
        if (this.parent != null) {
            this.parent.propagateXRefUnlinked(property1, property2);
        }
    }

    void propagatePropertyAdded(Property container, int pos, Property added) {
        if (this.parent != null) {
            this.parent.propagatePropertyAdded(container, pos, added);
        }
    }

    void propagatePropertyDeleted(Property container, int pos, Property deleted) {
        if (this.parent != null) {
            this.parent.propagatePropertyDeleted(container, pos, deleted);
        }
    }

    void propagatePropertyChanged(Property property, String oldValue) {
        if (this.parent != null) {
            this.parent.propagatePropertyChanged(property, oldValue);
        }
    }

    void propagatePropertyMoved(Property property, Property moved, int from, int to) {
        if (this.parent != null) {
            this.parent.propagatePropertyMoved(property, moved, from, to);
        }
    }

    public boolean addFile(File file) {
        if (!this.getMetaProperty().allows("FILE")) {
            if (!this.getMetaProperty().allows("OBJE")) {
                return false;
            }
            return this.addProperty("OBJE", "").addFile(file);
        }
        List pfiles = this.getProperties(PropertyFile.class);
        PropertyFile pfile = pfiles.isEmpty() ? (PropertyFile)this.addProperty("FILE", "") : (PropertyFile)pfiles.get(0);
        return pfile.addFile(file);
    }

    public Property addProperty(String tag, String value) {
        try {
            return this.addProperty(tag, value, -1);
        }
        catch (GedcomException e) {
            return this.addProperty(new PropertySimpleReadOnly(tag, value), -1);
        }
    }

    public Property addProperty(String tag, String value, int pos) throws GedcomException {
        return this.addProperty(this.getMetaProperty().getNested(tag, true).create(value), pos);
    }

    public Property addSimpleProperty(String tag, String value, int pos) {
        return this.addProperty(new PropertySimpleValue(tag, value), pos);
    }

    Property addProperty(Property prop) {
        return this.addProperty(prop, -1);
    }

    Property addProperty(Property child, int pos) {
        if (child.getParent() != null || child.getNoOfProperties() > 0) {
            throw new IllegalArgumentException("Can't add a property that is already contained or contains properties");
        }
        if (pos < 0) {
            MetaProperty meta = this.getMetaProperty();
            int index = meta.getNestedIndex(child.getTag());
            for (pos = 0; pos < this.getNoOfProperties() && meta.getNestedIndex(this.getProperty(pos).getTag()) <= index; ++pos) {
            }
        } else if (pos > this.getNoOfProperties()) {
            pos = this.getNoOfProperties();
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(pos, child);
        if (this.isTransient) {
            child.isTransient = true;
        }
        child.parent = this;
        this.propagatePropertyAdded(this, pos, child);
        child.afterAddNotify();
        return child;
    }

    public void delProperties() {
        if (this.children != null) {
            Property[] cs = this.children.toArray(new Property[this.children.size()]);
            for (int c = cs.length - 1; c >= 0; --c) {
                this.delProperty(cs[c]);
            }
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public void delProperties(String tag) {
        if (this.children != null) {
            Property[] cs = this.children.toArray(new Property[this.children.size()]);
            for (int c = 0; c < cs.length; ++c) {
                if (!cs[c].getTag().equals(tag)) continue;
                this.delProperty(cs[c]);
            }
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public void delProperty(Property deletee) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("no such child");
        }
        int pos = 0;
        while (this.children.get(pos) != deletee) {
            ++pos;
        }
        this.delProperty(pos);
    }

    public void delProperty(int pos) {
        if (this.children == null || pos < 0 || pos >= this.children.size()) {
            throw new IndexOutOfBoundsException("No property " + pos);
        }
        Property removed = (Property)this.children.get(pos);
        removed.beforeDelNotify();
        this.children.remove(pos);
        removed.parent = null;
        removed.meta = null;
        this.propagatePropertyDeleted(this, pos, removed);
    }

    public void moveProperties(List properties, int pos) {
        for (int i = 0; i < properties.size(); ++i) {
            Property prop = (Property)properties.get(i);
            pos = this.moveProperty(prop, pos);
        }
    }

    public int moveProperty(Property prop, int to) {
        return this.moveProperty(this.children.indexOf(prop), to);
    }

    public int moveProperty(int from, int to) {
        Property prop = (Property)this.children.remove(from);
        if (from < to) {
            --to;
        }
        this.children.add(to, prop);
        this.propagatePropertyMoved(this, prop, from, to);
        return to + 1;
    }

    public String getDeleteVeto() {
        return null;
    }

    public Entity getEntity() {
        return this.parent == null ? null : this.parent.getEntity();
    }

    public Gedcom getGedcom() {
        return this.parent != null ? this.parent.getGedcom() : null;
    }

    public ImageIcon getImage(boolean checkValid) {
        if (!checkValid || this.isValid()) {
            if (this.image == null) {
                this.image = this.getMetaProperty().getImage();
            }
            return this.image;
        }
        if (this.imageErr == null) {
            this.imageErr = this.getMetaProperty().getImage("err");
        }
        return this.imageErr;
    }

    public int getNoOfProperties() {
        return this.children == null ? 0 : this.children.size();
    }

    public Property getContaining(Class type) {
        for (Property prop = this; prop != null; prop = prop.getParent()) {
            if (!type.isAssignableFrom(prop.getClass())) continue;
            return prop;
        }
        return null;
    }

    public Property getParent() {
        return this.parent;
    }

    public TagPath getPathToContaining(Property rparent) {
        Stack result = new Stack();
        this.getPathToContaining(rparent, result);
        return new TagPath(result);
    }

    public TagPath getPathToNested(Property nested) {
        Stack result = new Stack();
        nested.getPathToContaining(this, result);
        return new TagPath(result);
    }

    private void getPathToContaining(Property containing, Stack result) {
        result.push(this.getTag());
        if (containing == this) {
            return;
        }
        if (this.parent == null) {
            throw new IllegalArgumentException("couldn't find containing " + containing);
        }
        this.parent.getPathToContaining(containing, result);
    }

    public TagPath getPath() {
        return this.getPath(false);
    }

    public TagPath getPath(boolean unique) {
        Stack<String> stack = new Stack<String>();
        String tag = this.getTag();
        for (Property parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (unique) {
                Property sibling;
                int qualifier = 0;
                int j = parent.getNoOfProperties();
                for (int i = 0; i < j && (sibling = parent.getProperty(i)) != this; ++i) {
                    if (!sibling.getTag().equals(tag)) continue;
                    ++qualifier;
                }
                stack.push(tag + "#" + qualifier);
            } else {
                stack.push(tag);
            }
            tag = parent.getTag();
        }
        stack.push(tag);
        return new TagPath(stack);
    }

    public boolean contains(Property prop) {
        if (this.children == null) {
            return false;
        }
        for (int c = 0; c < this.children.size(); ++c) {
            Property child = (Property)this.children.get(c);
            if (child != prop && !child.contains(prop)) continue;
            return true;
        }
        return false;
    }

    public boolean isContained(Property in) {
        Property parent = this.getParent();
        if (parent == in) {
            return true;
        }
        return parent == null ? false : parent.isContained(in);
    }

    public boolean hasProperties(List props) {
        return this.children == null ? false : this.children.containsAll(props);
    }

    public Property[] getProperties() {
        return this.children == null ? new Property[]{} : Property.toArray(this.children);
    }

    public List findProperties(Pattern tag, Pattern value) {
        ArrayList result = new ArrayList();
        if (value == null) {
            value = Pattern.compile(".*");
        }
        this.findPropertiesRecursively(result, tag, value, true);
        return result;
    }

    protected boolean findPropertiesRecursivelyTest(Pattern tag, Pattern value) {
        return tag.matcher(this.getTag()).matches() && value.matcher(this.getValue()).matches();
    }

    private void findPropertiesRecursively(Collection result, Pattern tag, Pattern value, boolean recursively) {
        if (this.findPropertiesRecursivelyTest(tag, value)) {
            result.add(this);
        }
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            if (!recursively) continue;
            this.getProperty(i).findPropertiesRecursively(result, tag, value, recursively);
        }
    }

    public Property[] getProperties(String tag) {
        return this.getProperties(tag, true);
    }

    public Property[] getProperties(String tag, boolean validOnly) {
        ArrayList<Property> result = new ArrayList<Property>(this.getNoOfProperties());
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (!prop.getTag().equals(tag) || validOnly && !prop.isValid()) continue;
            result.add(prop);
        }
        return Property.toArray(result);
    }

    public List getProperties(Class type) {
        ArrayList props = new ArrayList(10);
        this.getPropertiesRecursively(props, type);
        return props;
    }

    private void getPropertiesRecursively(List props, Class type) {
        for (int c = 0; c < this.getNoOfProperties(); ++c) {
            Property child = this.getProperty(c);
            if (type.isAssignableFrom(child.getClass())) {
                props.add(child);
            }
            child.getPropertiesRecursively(props, type);
        }
    }

    public int getPropertyPosition(Property prop) {
        if (this.children == null) {
            throw new IllegalArgumentException("no such property");
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != prop) continue;
            return i;
        }
        throw new IllegalArgumentException("no such property");
    }

    public Property getProperty(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("no property " + n);
        }
        return (Property)this.children.get(n);
    }

    public Property getProperty(String tag) {
        return this.getProperty(tag, true);
    }

    public Property getProperty(String tag, boolean validOnly) {
        if (tag.indexOf(58) > 0) {
            throw new IllegalArgumentException("Path not allowed");
        }
        if (this.children != null) {
            int j = this.children.size();
            for (int i = 0; i < j; ++i) {
                Property child = (Property)this.children.get(i);
                if (!child.getTag().equals(tag) || validOnly && !child.isValid()) continue;
                return child;
            }
        }
        return null;
    }

    public Property getPropertyByPath(String path) {
        return this.getProperty(new TagPath(path));
    }

    public Property getProperty(TagPath path) {
        final Property[] result = new Property[1];
        PropertyVisitor visitor = new PropertyVisitor(){

            protected boolean leaf(Property prop) {
                result[0] = prop;
                return false;
            }
        };
        path.iterate(this, visitor);
        return result[0];
    }

    public Property[] getProperties(TagPath path) {
        final ArrayList result = new ArrayList(10);
        PropertyVisitor visitor = new PropertyVisitor(){

            protected boolean leaf(Property prop) {
                result.add(prop);
                return true;
            }
        };
        path.iterate(this, visitor);
        return Property.toArray(result);
    }

    public abstract String getTag();

    Property init(MetaProperty meta, String value) throws GedcomException {
        this.meta = meta;
        this.setValue(value);
        return this;
    }

    public abstract String getValue();

    public String getDisplayValue() {
        return this.getValue();
    }

    public String getPropertyValue(String tag) {
        Property child = this.getProperty(tag);
        return child != null ? child.getValue() : "";
    }

    public String getPropertyDisplayValue(String tag) {
        Property child = this.getProperty(tag);
        return child != null ? child.getDisplayValue() : "";
    }

    public String toString() {
        return this.getDisplayValue();
    }

    public String getValue(TagPath path, String fallback) {
        Property prop = this.getProperty(path);
        return prop == null ? fallback : prop.getValue();
    }

    public Property setValue(TagPath path, final String value) {
        final Property[] result = new Property[1];
        PropertyVisitor visitor = new PropertyVisitor(){

            protected boolean leaf(Property prop) {
                if (prop instanceof PropertyXRef && ((PropertyXRef)prop).getTarget() != null) {
                    prop = prop.getParent().addProperty(prop.getTag(), "");
                }
                prop.setValue(value);
                result[0] = prop;
                return false;
            }

            protected boolean recursion(Property parent, String child) {
                if (parent.getProperty(child, false) == null) {
                    parent.addProperty(child, "");
                }
                return true;
            }
        };
        path.iterate(this, visitor);
        return result[0];
    }

    public abstract void setValue(String var1);

    public boolean isValid() {
        return true;
    }

    public int compareTo(Object that) {
        if (!(that instanceof Property)) {
            throw new ClassCastException("compareTo(" + that + ")");
        }
        return this.compare(this.getDisplayValue(), ((Property)that).getDisplayValue());
    }

    protected int compare(String s1, String s2) {
        Gedcom ged = this.getGedcom();
        if (ged != null) {
            return ged.getCollator().compare(s1, s2);
        }
        return s1.compareTo(s2);
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isReadOnly() {
        return false;
    }

    public final Property addDefaultProperties() {
        if (this.getEntity() == null) {
            throw new IllegalArgumentException("addDefaultProperties() while getEntity()==null!");
        }
        MetaProperty[] subs = this.getNestedMetaProperties(2);
        for (int s = 0; s < subs.length; ++s) {
            if (this.getProperty(subs[s].getTag()) != null) continue;
            this.addProperty(subs[s].getTag(), "").addDefaultProperties();
        }
        return this;
    }

    public MetaProperty getMetaProperty() {
        if (this.meta == null) {
            this.meta = this.getGedcom().getGrammar().getMeta(this.getPath());
        }
        return this.meta;
    }

    public MetaProperty[] getNestedMetaProperties(int filter) {
        return this.getMetaProperty().getAllNested(this, filter);
    }

    public static Property[] toArray(Collection ps) {
        return ps.toArray(new Property[ps.size()]);
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isSecret() {
        return this.isPrivate && this.getGedcom().getPassword() == "PASSWORD_UNKNOWN";
    }

    public void setPrivate(boolean set, boolean recursively) {
        if (recursively) {
            for (int c = 0; c < this.getNoOfProperties(); ++c) {
                Property child = this.getProperty(c);
                child.setPrivate(set, recursively);
            }
        }
        this.isPrivate = set;
        this.propagatePropertyChanged(this, this.getValue());
    }

    public String getPropertyInfo() {
        return this.getMetaProperty().getInfo();
    }

    public String getPropertyName() {
        return Gedcom.getName(this.getTag());
    }

    public static String getPropertyNames(Property[] properties, int limit) {
        WordBuffer result = new WordBuffer(", ");
        int i = 0;
        while (i < properties.length) {
            result.append(properties[i++].getPropertyName());
            if (i != limit) continue;
        }
        if (i < properties.length) {
            result.append("...");
        }
        return result.toString();
    }

    public static List normalize(List properties) {
        ArrayList<Property> result = new ArrayList<Property>(properties.size());
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            Property parent;
            Property prop = (Property)it.next();
            if (prop.isTransient()) continue;
            for (parent = prop.getParent(); parent != null && !properties.contains(parent); parent = parent.getParent()) {
            }
            if (parent != null) continue;
            result.add(prop);
        }
        return result;
    }

    public String format(String format) {
        return this.format(format, PrivacyPolicy.PUBLIC);
    }

    public String format(String format, PrivacyPolicy policy) {
        Matcher matcher = FORMAT_PATTERN.matcher(format);
        StringBuffer result = new StringBuffer(format.length() + 20);
        int masked = 0;
        int matches = 0;
        int cursor = 0;
        while (matcher.find()) {
            String value;
            Property prop;
            result.append(format.substring(cursor, matcher.start()));
            String prefix = matcher.group(1);
            char marker = format.charAt(matcher.start(2));
            String suffix = matcher.group(3);
            switch (marker) {
                case 'D': {
                    prop = this.getProperty("DATE");
                    value = prop instanceof PropertyDate && prop.isValid() ? prop.getDisplayValue() : "";
                    break;
                }
                case 'y': {
                    prop = this.getProperty("DATE");
                    value = prop instanceof PropertyDate && prop.isValid() ? Integer.toString(((PropertyDate)prop).getStart().getYear()) : "";
                    break;
                }
                case 'p': {
                    prop = this.getProperty("PLAC");
                    String string = value = prop instanceof PropertyPlace ? ((PropertyPlace)prop).getCity() : "";
                    if (value != null) break;
                    value = "";
                    break;
                }
                case 'P': {
                    prop = this.getProperty("PLAC");
                    value = prop instanceof PropertyPlace ? prop.getDisplayValue() : "";
                    break;
                }
                case 'v': {
                    prop = this;
                    value = this.getDisplayValue();
                    break;
                }
                case 'V': {
                    prop = this;
                    value = this.getValue();
                    break;
                }
                case 't': {
                    prop = null;
                    value = this.getTag();
                    break;
                }
                case 'T': {
                    prop = null;
                    value = Gedcom.getName(this.getTag());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown formatting marker " + marker);
                }
            }
            if (prop != null && policy.isPrivate(prop)) {
                String string = value = masked++ == 0 || prefix.trim().length() > 0 ? Options.getInstance().maskPrivate : "";
            }
            if (value.length() > 0) {
                result.append(prefix);
                result.append(value);
                result.append(suffix);
                if (prop != null) {
                    ++matches;
                }
            }
            cursor = matcher.end();
        }
        result.append(format.substring(cursor));
        return matches > 0 ? result.toString() : "";
    }

    public PropertyDate getWhen() {
        for (Property cursor = this; cursor != null; cursor = cursor.getParent()) {
            if (this instanceof PropertyDate) {
                return (PropertyDate)this;
            }
            if (!(this instanceof PropertyEvent)) continue;
            return ((PropertyEvent)this).getDate();
        }
        return null;
    }

    public void copyProperties(Property root, boolean useValues) throws GedcomException {
        Property copy = this.getProperty(root.getTag(), false);
        if (copy == null) {
            copy = this.addProperty(root.getTag(), useValues ? root.getValue() : "");
            if (useValues && copy instanceof PropertyXRef) {
                try {
                    ((PropertyXRef)copy).link();
                }
                catch (GedcomException e) {
                    throw new GedcomException("Can't copy '" + root.getTag() + " " + root.getDisplayValue() + "' to " + this.getPath() + ": " + e.getMessage());
                }
            }
        }
        int j = root.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property child = root.getProperty(i);
            if (child.isTransient()) continue;
            copy.copyProperties(child, useValues);
        }
    }
}

