/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Delta;

public class PrivacyPolicy {
    public static final PrivacyPolicy PUBLIC = new PrivacyPolicy(){

        public boolean isPrivate(Property prop) {
            return false;
        }
    };
    public static final PrivacyPolicy PRIVATE = new PrivacyPolicy(){

        public boolean isPrivate(Property prop) {
            return true;
        }
    };
    private boolean infoOfDeceasedIsPublic;
    private int yearsInfoIsPrivate;
    private String tagMarkingPrivate;

    private PrivacyPolicy() {
    }

    public PrivacyPolicy(boolean infoOfDeceasedIsPublic, int yearsInfoIsPrivate, String tagMarkingPrivate) {
        this.infoOfDeceasedIsPublic = infoOfDeceasedIsPublic;
        this.yearsInfoIsPrivate = Math.max(yearsInfoIsPrivate, 0);
        this.tagMarkingPrivate = tagMarkingPrivate == null || tagMarkingPrivate.length() == 0 ? null : tagMarkingPrivate;
    }

    public String getDisplayValue(Property prop) {
        return this.isPrivate(prop) ? Options.getInstance().maskPrivate : prop.getDisplayValue();
    }

    public String getDisplayValue(Property prop, String tag) {
        return (prop = prop.getProperty(tag)) == null ? "" : this.getDisplayValue(prop);
    }

    public boolean isPrivate(Property prop) {
        if (this.infoOfDeceasedIsPublic && this.isInfoOfDeceased(prop)) {
            return false;
        }
        if (this.tagMarkingPrivate != null && this.hasTagMarkingPrivate(prop)) {
            return true;
        }
        if (this.yearsInfoIsPrivate > 0 && this.isWithinPrivateYears(prop)) {
            return true;
        }
        return (prop = prop.getParent()) != null ? this.isPrivate(prop) : false;
    }

    private boolean isInfoOfDeceased(Property prop) {
        Entity e = prop.getEntity();
        if (e instanceof Indi) {
            return ((Indi)e).isDeceased();
        }
        if (e instanceof Fam) {
            Indi husband = ((Fam)e).getHusband();
            if (husband != null && !husband.isDeceased()) {
                return false;
            }
            Indi wife = ((Fam)e).getWife();
            return wife != null && wife.isDeceased();
        }
        return false;
    }

    private boolean hasTagMarkingPrivate(Property prop) {
        return this.getPropertyFor(prop, this.tagMarkingPrivate, Property.class) != null;
    }

    private boolean isWithinPrivateYears(Property prop) {
        PropertyDate date = (PropertyDate)this.getPropertyFor(prop, "DATE", PropertyDate.class);
        if (date == null) {
            return false;
        }
        Delta anniversary = date.getAnniversary();
        return anniversary != null && anniversary.getYears() < this.yearsInfoIsPrivate;
    }

    private Property getPropertyFor(Property prop, String tag, Class type) {
        int j = prop.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property child = prop.getProperty(i);
            if (!this.is(child, tag, type)) continue;
            return child;
        }
        return null;
    }

    private boolean is(Property prop, String tag, Class type) {
        return prop.getTag().equals(tag) && type.isAssignableFrom(prop.getClass());
    }
}

