/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.option.OptionProvider;
import genj.option.PropertyOption;
import genj.util.Resources;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Options
extends OptionProvider {
    private static final Resources RESOURCES = Resources.get(Options.class);
    private static final Options instance = new Options();
    public boolean isUseSpacedPlaces = true;
    public boolean isFillGapsInIDs = false;
    public boolean isUpperCaseNames = false;
    public boolean setWifeLastname = true;
    private int maxImageFileSizeKB = 128;
    private int valueLineBreak = 255;
    protected String txtMarriageSymbol = "+";
    protected int numberOfUndos = 10;
    protected Set placeHierarchyCityKeys = new HashSet<String>(Arrays.asList("city", "commune", "ville", "stadt"));
    public String maskPrivate = "...";
    protected int defaultEncoding = Gedcom.ENCODINGS.length - 1;
    public int dateFormat = 1;
    public static final String[] dateFormats = new String[]{RESOURCES.getString("option.dateFormat.gedcom"), RESOURCES.getString("option.dateFormat.short"), RESOURCES.getString("option.dateFormat.long"), RESOURCES.getString("option.dateFormat.numeric")};

    public static Options getInstance() {
        return instance;
    }

    public void setMaxImageFileSizeKB(int max) {
        this.maxImageFileSizeKB = Math.max(4, max);
    }

    public int getMaxImageFileSizeKB() {
        return this.maxImageFileSizeKB;
    }

    public int getValueLineBreak() {
        return this.valueLineBreak;
    }

    public void setValueLineBreak(int set) {
        this.valueLineBreak = Math.max(40, set);
    }

    public String getTxtMarriageSymbol() {
        return this.txtMarriageSymbol;
    }

    public void setTxtMarriageSymbol(String set) {
        this.txtMarriageSymbol = set != null && set.trim().length() > 0 ? ' ' + set.trim() + ' ' : " + ";
    }

    public int getNumberOfUndos() {
        return this.numberOfUndos;
    }

    public void setNumberOfUndos(int i) {
        this.numberOfUndos = Math.max(10, i);
    }

    public List getOptions() {
        return PropertyOption.introspect(instance);
    }

    public int getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(int setEncoding) {
        if (setEncoding >= 0 && setEncoding < Gedcom.ENCODINGS.length) {
            this.defaultEncoding = setEncoding;
        }
    }

    public static String[] getDefaultEncodings() {
        return Gedcom.ENCODINGS;
    }
}

