/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertySimpleValue;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class MetaProperty
implements Comparable {
    public static final int WHERE_NOT_HIDDEN = 1;
    public static final int WHERE_DEFAULT = 2;
    public static final int WHERE_CARDINALITY_ALLOWS = 4;
    private static Map name2images = new HashMap();
    public static final ImageIcon IMG_CUSTOM = MetaProperty.loadImage("Attribute.gif");
    public static final ImageIcon IMG_LINK = MetaProperty.loadImage("Association.gif");
    public static final ImageIcon IMG_UNKNOWN = MetaProperty.loadImage("Question.gif");
    public static final ImageIcon IMG_ERROR = MetaProperty.loadImage("Error.gif");
    public static final ImageIcon IMG_PRIVATE = MetaProperty.loadImage("Private.gif");
    private Grammar grammar;
    private String tag;
    private ImageIcon image;
    private String name;
    private String names;
    private Class type;
    private String info;
    boolean isInstantiated = false;
    private boolean isGrammar;
    private Map attrs;
    private Map tag2nested = new HashMap();
    List nested = new ArrayList();

    MetaProperty(Grammar grammar, String tag, Map attributes, boolean isGrammar) {
        this.grammar = grammar;
        this.tag = tag;
        this.attrs = attributes;
        this.isGrammar = isGrammar;
        MetaProperty spr = this.getSuper();
        if (spr != null) {
            this.copyAttributesFrom(spr);
        }
    }

    private void copyAttributesFrom(MetaProperty supr) {
        Iterator nested = new ArrayList(supr.nested).iterator();
        while (nested.hasNext()) {
            MetaProperty sub = (MetaProperty)nested.next();
            if ("0".equals(sub.attrs.get("inherit"))) continue;
            this.addNested(sub);
        }
        if (this.getAttribute("type") == null) {
            this.attrs.put("type", supr.getAttribute("type"));
        }
        if (this.getAttribute("img") == null) {
            this.attrs.put("img", supr.getAttribute("img"));
        }
        if (this.getAttribute("cardinality") == null) {
            this.attrs.put("cardinality", supr.getAttribute("cardinality"));
        }
    }

    public MetaProperty getSuper() {
        String path = (String)this.attrs.get("super");
        return path == null ? null : this.grammar.getMetaRecursively(new TagPath(path), false);
    }

    synchronized void addNested(MetaProperty sub) {
        if (sub == null) {
            throw new IllegalArgumentException("Nested meta can't be null");
        }
        this.tag2nested.put(sub.tag, sub);
        for (int i = 0; i < this.nested.size(); ++i) {
            MetaProperty other = (MetaProperty)this.nested.get(i);
            if (!other.tag.equals(sub.tag)) continue;
            sub.copyAttributesFrom(other);
            this.nested.set(i, sub);
            return;
        }
        this.nested.add(sub);
    }

    MetaProperty[] getAllNested(Property parent, int filter) {
        ArrayList<MetaProperty> result = new ArrayList<MetaProperty>(this.nested.size());
        for (int s = 0; s < this.nested.size(); ++s) {
            String isDefault;
            MetaProperty sub = (MetaProperty)this.nested.get(s);
            if ((filter & 2) != 0 && ((isDefault = sub.getAttribute("default")) == null || "0".equals(isDefault)) || (filter & 1) != 0 && sub.getAttribute("hide") != null || "0".equals(sub.getAttribute("xref")) && parent instanceof PropertyXRef || "1".equals(sub.getAttribute("xref")) && !(parent instanceof PropertyXRef) || (filter & 4) != 0 && sub.isSingleton() && parent.getProperty(sub.getTag()) != null) continue;
            result.add(sub);
        }
        return result.toArray(new MetaProperty[result.size()]);
    }

    String getAttribute(String key) {
        return (String)this.attrs.get(key);
    }

    void assertTag(String tag) throws GedcomException {
        if (!this.tag.equals(tag)) {
            throw new GedcomException("Tag should be " + tag + " but is " + this.tag);
        }
    }

    public boolean isEntity() {
        return Entity.class.isAssignableFrom(this.getType());
    }

    public boolean isSingleton() {
        String c = this.getAttribute("cardinality");
        return c != null && c.endsWith(":1");
    }

    public boolean isVersion(String version) {
        String v = this.getAttribute("gedcom");
        return v == null || v.equals(version);
    }

    public boolean isRequired() {
        String c = this.getAttribute("cardinality");
        return c != null && c.startsWith("1:");
    }

    public int compareTo(Object o) {
        MetaProperty other = (MetaProperty)o;
        return Collator.getInstance().compare(this.getName(), other.getName());
    }

    public boolean allows(String sub) {
        MetaProperty meta = (MetaProperty)this.tag2nested.get(sub);
        return meta == null ? false : meta.isGrammar;
    }

    public boolean allows(String sub, Class type) {
        MetaProperty meta = (MetaProperty)this.tag2nested.get(sub);
        return meta != null && type.isAssignableFrom(meta.getType());
    }

    public Property create(String value) throws GedcomException {
        Property result;
        try {
            result = (Property)this.getType().newInstance();
            result = result.init(this, value);
        }
        catch (GedcomException e) {
            throw e;
        }
        catch (Exception e) {
            Gedcom.LOG.log(Level.WARNING, "Couldn't instantiate property " + this.getType() + " with value '" + value, e);
            result = new PropertySimpleValue();
            ((PropertySimpleValue)result).init(this, value);
        }
        this.isInstantiated = true;
        return result;
    }

    public boolean isInstantiated() {
        return this.isInstantiated;
    }

    public ImageIcon getImage() {
        if (this.image == null) {
            String s = this.getAttribute("img");
            this.image = s == null ? (this.getTag().startsWith("_") ? IMG_CUSTOM : IMG_UNKNOWN) : MetaProperty.loadImage(s);
        }
        return this.image;
    }

    public ImageIcon getImage(String postfix) {
        String name = this.getAttribute("img." + postfix);
        if (name == null) {
            if ("err".equals(postfix)) {
                return IMG_ERROR;
            }
            return this.getImage();
        }
        return MetaProperty.loadImage(name.toString());
    }

    public String getTag() {
        return this.tag;
    }

    public Class getType() {
        if (this.type == null) {
            String attrType = this.getAttribute("type");
            if (attrType == null) {
                this.type = PropertySimpleValue.class;
            } else {
                try {
                    this.type = Class.forName("genj.gedcom." + attrType);
                }
                catch (Throwable t) {
                    Gedcom.LOG.log(Level.WARNING, "Property type genj.gedcom." + attrType + " couldn't be instantiated", t);
                    this.type = PropertySimpleValue.class;
                }
            }
        }
        return this.type;
    }

    public String getName() {
        return this.getName(false);
    }

    public String getCardinality() {
        return (String)this.attrs.get("cardinality");
    }

    public String getName(boolean plural) {
        String result;
        if (plural) {
            result = this.names;
            if (result == null) {
                result = Gedcom.getName(this.tag, true);
            }
            this.names = result;
        } else {
            result = this.name;
            if (result == null) {
                result = Gedcom.getName(this.tag, false);
            }
            this.name = result;
        }
        return result;
    }

    public String getInfo() {
        if (this.info == null) {
            this.info = Gedcom.getResources().getString(this.tag + ".info", false);
            if (this.info == null) {
                char c = this.tag.charAt(0);
                if (c != '_') {
                    c = '?';
                }
                this.info = Gedcom.getResources().getString(c + ".info");
            }
            this.info = this.getName() + ":\n" + this.info;
        }
        return this.info;
    }

    public MetaProperty getNestedRecursively(TagPath path, boolean persist) {
        String tag = path.get(0);
        if (!this.tag.equals(tag) && !".".equals(tag)) {
            throw new IllegalArgumentException();
        }
        return this.getNestedRecursively(path, 1, persist);
    }

    MetaProperty getNestedRecursively(TagPath path, int pos, boolean persist) {
        if (pos == path.length()) {
            return this;
        }
        return this.getNested(path.get(pos), persist).getNestedRecursively(path, pos + 1, persist);
    }

    public MetaProperty getNested(String tag, boolean persist) {
        if (tag == null || tag.length() == 0) {
            throw new IllegalArgumentException("tag can't be empty");
        }
        MetaProperty result = (MetaProperty)this.tag2nested.get(tag);
        if (result == null) {
            result = new MetaProperty(this.grammar, tag, new HashMap(), false);
            if (persist) {
                this.addNested(result);
            }
        }
        return result;
    }

    public int getNestedIndex(String subtag) {
        if (subtag.equals("CHAN")) {
            return Integer.MAX_VALUE;
        }
        for (int i = 0; i < this.nested.size(); ++i) {
            if (!((MetaProperty)this.nested.get(i)).getTag().equals(subtag)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private static ImageIcon loadImage(String name) {
        ImageIcon result = (ImageIcon)name2images.get(name);
        if (result == null) {
            try {
                while (true) {
                    try {
                        result = new ImageIcon(name, MetaProperty.class.getResourceAsStream("images/" + name));
                        name2images.put(name, result);
                    }
                    catch (IllegalStateException iae) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                Gedcom.LOG.log(Level.WARNING, "Unexpected problem reading " + name, t);
                return IMG_ERROR;
            }
        }
        return result;
    }
}

