/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertySex;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.util.swing.ImageIcon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Indi
extends Entity {
    private static final TagPath PATH_INDI = new TagPath("INDI");
    private static final TagPath PATH_INDIFAMS = new TagPath("INDI:FAMS");
    private static final TagPath PATH_INDIFAMC = new TagPath("INDI:FAMC");
    private static final TagPath PATH_INDIBIRTDATE = new TagPath("INDI:BIRT:DATE");
    private static final TagPath PATH_INDIDEATDATE = new TagPath("INDI:DEAT:DATE");
    public static final ImageIcon IMG_MALE = Grammar.V55.getMeta(PATH_INDI).getImage("male");
    public static final ImageIcon IMG_FEMALE = Grammar.V55.getMeta(PATH_INDI).getImage("female");
    public static final ImageIcon IMG_UNKNOWN = Grammar.V55.getMeta(PATH_INDI).getImage();

    public PropertyDate getBirthDate() {
        return this.getBirthDate(false);
    }

    public PropertyDate getBirthDate(boolean create) {
        PropertyDate date = (PropertyDate)this.getProperty(PATH_INDIBIRTDATE);
        if (null != date || !create) {
            return date;
        }
        return (PropertyDate)this.setValue(PATH_INDIBIRTDATE, "");
    }

    public PropertyDate getDeathDate() {
        return this.getDeathDate(false);
    }

    public PropertyDate getDeathDate(boolean create) {
        PropertyDate date = (PropertyDate)this.getProperty(PATH_INDIDEATDATE);
        if (null != date || !create) {
            return date;
        }
        return (PropertyDate)this.setValue(PATH_INDIDEATDATE, "");
    }

    public Indi[] getSiblings(boolean includeMe) {
        Fam fam = this.getFamilyWhereBiologicalChild();
        if (fam == null) {
            return new Indi[0];
        }
        ArrayList<Indi> result = new ArrayList<Indi>(fam.getNoOfChildren());
        Indi[] siblings = fam.getChildren();
        for (int s = 0; s < siblings.length; ++s) {
            if (!includeMe && siblings[s] == this) continue;
            result.add(siblings[s]);
        }
        return Indi.toIndiArray(result);
    }

    public Indi[] getYoungerSiblings() {
        Indi[] siblings = this.getSiblings(true);
        Arrays.sort(siblings, new PropertyComparator("INDI:BIRT:DATE"));
        ArrayList<Indi> result = new ArrayList<Indi>(siblings.length);
        for (int i = siblings.length - 1; i >= 0 && siblings[i] != this; --i) {
            result.add(0, siblings[i]);
        }
        return Indi.toIndiArray(result);
    }

    public PropertyMultilineValue getAddress() {
        Property[] rs = this.getProperties("RESI");
        for (int i = 0; i < rs.length; ++i) {
            PropertyDate date;
            PropertyMultilineValue address = (PropertyMultilineValue)rs[i].getProperty("ADDR");
            if (address == null || (date = (PropertyDate)rs[i].getProperty("DATE")) != null && date.isRange()) continue;
            return address;
        }
        return null;
    }

    public Indi[] getOlderSiblings() {
        Indi[] siblings = this.getSiblings(true);
        Arrays.sort(siblings, new PropertyComparator("INDI:BIRT:DATE"));
        ArrayList<Indi> result = new ArrayList<Indi>(siblings.length);
        int j = siblings.length;
        for (int i = 0; i < j && siblings[i] != this; ++i) {
            result.add(0, siblings[i]);
        }
        return Indi.toIndiArray(result);
    }

    public Indi[] getPartners() {
        Fam[] fs = this.getFamiliesWhereSpouse();
        ArrayList<Indi> l = new ArrayList<Indi>(fs.length);
        for (int f = 0; f < fs.length; ++f) {
            Indi p = fs[f].getOtherSpouse(this);
            if (p == null) continue;
            l.add(p);
        }
        Indi[] result = new Indi[l.size()];
        l.toArray(result);
        return result;
    }

    public Indi[] getChildren() {
        Fam[] fs = this.getFamiliesWhereSpouse();
        ArrayList<Indi> l = new ArrayList<Indi>(fs.length);
        for (int f = 0; f < fs.length; ++f) {
            Indi[] cs = fs[f].getChildren();
            for (int c = 0; c < cs.length; ++c) {
                if (l.contains(cs[c])) continue;
                l.add(cs[c]);
            }
        }
        Indi[] result = new Indi[l.size()];
        l.toArray(result);
        return result;
    }

    public String getBirthAsString() {
        PropertyDate p = this.getBirthDate();
        if (p == null) {
            return "";
        }
        return p.toString();
    }

    public String getDeathAsString() {
        PropertyDate p = this.getDeathDate();
        if (p == null) {
            return "";
        }
        return p.toString();
    }

    public Fam[] getFamiliesWhereSpouse() {
        ArrayList<Fam> result = new ArrayList<Fam>(this.getNoOfProperties());
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (!"FAMS".equals(prop.getTag()) || !prop.isValid()) continue;
            result.add(((PropertyFamilySpouse)prop).getFamily());
        }
        return Fam.toFamArray(result);
    }

    public Fam[] getFamiliesWhereChild() {
        List famcs = this.getProperties(PropertyFamilyChild.class);
        ArrayList<Entity> result = new ArrayList<Entity>(famcs.size());
        for (int i = 0; i < famcs.size(); ++i) {
            PropertyFamilyChild famc = (PropertyFamilyChild)famcs.get(i);
            if (!famc.isValid() || result.contains(famc)) continue;
            result.add(famc.getTargetEntity());
        }
        return Fam.toFamArray(result);
    }

    public Fam getFamilyWhereBiologicalChild() {
        Fam result = null;
        List famcs = this.getProperties(PropertyFamilyChild.class);
        for (int i = 0; i < famcs.size(); ++i) {
            PropertyFamilyChild famc = (PropertyFamilyChild)famcs.get(i);
            if (!famc.isValid()) continue;
            Boolean biological = famc.isBiological();
            if (Boolean.TRUE.equals(biological)) {
                return (Fam)famc.getTargetEntity();
            }
            if (biological != null || result != null) continue;
            result = (Fam)famc.getTargetEntity();
        }
        return result;
    }

    public String getFirstName() {
        PropertyName p = (PropertyName)this.getProperty("NAME", true);
        return p != null ? p.getFirstName() : "";
    }

    public String getLastName() {
        PropertyName p = (PropertyName)this.getProperty("NAME", true);
        return p != null ? p.getLastName() : "";
    }

    public String getNameSuffix() {
        PropertyName p = (PropertyName)this.getProperty("NAME", true);
        return p != null ? p.getSuffix() : "";
    }

    public void setName(String first, String last) {
        PropertyName p = (PropertyName)this.getProperty("NAME", true);
        if (p == null) {
            p = (PropertyName)this.addProperty(new PropertyName());
        }
        p.setName(first, last);
    }

    public String getName() {
        PropertyName p = (PropertyName)this.getProperty("NAME", true);
        if (p == null) {
            return "";
        }
        return p.isSecret() ? "" : p.getName();
    }

    public int getNoOfFams() {
        int result = 0;
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (!"FAMS".equals(prop.getTag()) || !prop.isValid()) continue;
            ++result;
        }
        return result;
    }

    public int getSex() {
        PropertySex p = (PropertySex)this.getProperty("SEX", true);
        return p != null ? p.getSex() : 0;
    }

    public void setSex(int sex) {
        PropertySex p = (PropertySex)this.getProperty("SEX", false);
        if (p != null && !p.isValid()) {
            return;
        }
        if (p == null) {
            p = (PropertySex)this.addProperty(new PropertySex());
        }
        p.setSex(sex);
    }

    public boolean isDescendantOf(Indi indi) {
        return indi.isAncestorOf(this);
    }

    public boolean isAncestorOf(Indi indi) {
        return this.recursiveIsAncestorOf(indi, new HashSet());
    }

    private boolean recursiveIsAncestorOf(Indi indi, Set visited) {
        if (visited.contains(indi)) {
            return false;
        }
        visited.add(indi);
        List famcs = indi.getProperties(PropertyFamilyChild.class);
        for (int i = 0; i < famcs.size(); ++i) {
            Indi mother;
            PropertyFamilyChild famc = (PropertyFamilyChild)famcs.get(i);
            if (!famc.isValid() || Boolean.FALSE.equals(famc.isBiological())) continue;
            Fam fam = famc.getFamily();
            Indi father = fam.getHusband();
            if (father != null) {
                if (father == this) {
                    return true;
                }
                if (this.recursiveIsAncestorOf(father, visited)) {
                    return true;
                }
            }
            if ((mother = fam.getWife()) == null) continue;
            if (mother == this) {
                return true;
            }
            if (!this.recursiveIsAncestorOf(mother, visited)) continue;
            return true;
        }
        return false;
    }

    public boolean isDescendantOf(Fam fam) {
        Indi[] children = fam.getChildren(false);
        for (int i = 0; i < children.length; ++i) {
            Indi child = children[i];
            if (child == this) {
                return true;
            }
            if (!child.isAncestorOf(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOf(Fam fam) {
        Indi wife;
        Indi husband = fam.getHusband();
        if (husband != null) {
            if (husband == this) {
                return true;
            }
            if (this.isAncestorOf(husband)) {
                return true;
            }
        }
        if ((wife = fam.getWife()) != null) {
            if (wife == this) {
                return true;
            }
            if (this.isAncestorOf(wife)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return super.toString(this.getName());
    }

    static Indi[] toIndiArray(Collection c) {
        return c.toArray(new Indi[c.size()]);
    }

    public ImageIcon getImage(boolean checkValid) {
        switch (this.getSex()) {
            case 1: {
                return IMG_MALE;
            }
            case 2: {
                return IMG_FEMALE;
            }
        }
        return IMG_UNKNOWN;
    }

    public String getAgeString(PointInTime pit) {
        Delta delta = this.getAge(pit);
        return delta != null ? delta.toString() : "";
    }

    public String getTag() {
        return "INDI";
    }

    public Delta getAge(PointInTime pit) {
        PropertyDate pbirth = this.getBirthDate();
        if (pbirth == null) {
            return null;
        }
        PointInTime start = pbirth.getStart();
        if (start.compareTo(pit) > 0) {
            return null;
        }
        Delta delta = Delta.get(pbirth.getStart(), pit);
        if (delta == null) {
            return null;
        }
        return delta;
    }

    public Indi getBiologicalFather() {
        Fam f = this.getFamilyWhereBiologicalChild();
        return f != null ? f.getHusband() : null;
    }

    public Indi getBiologicalMother() {
        Fam f = this.getFamilyWhereBiologicalChild();
        return f != null ? f.getWife() : null;
    }

    public boolean isDeceased() {
        PropertyEvent deat = (PropertyEvent)this.getProperty("DEAT");
        if (deat != null) {
            if (deat.isKnownToHaveHappened().booleanValue()) {
                return true;
            }
            Property date = deat.getProperty("DATE");
            if (date != null && date.isValid()) {
                return true;
            }
        }
        return false;
    }
}

