/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.MetaProperty;
import genj.gedcom.TagPath;
import genj.util.EnvironmentChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Grammar {
    private static final Logger LOG = Logger.getLogger("genj.gedcom");
    public static final Grammar V55 = new Grammar("contrib/LDS/gedcom-5-5.xml");
    public static final Grammar V551 = new Grammar("contrib/LDS/gedcom-5-5-1.xml");
    private String version;
    private Map tag2root = new HashMap();

    private Grammar(String descriptor) {
        SAXParser parser;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Throwable t) {
            Gedcom.LOG.log(Level.SEVERE, "couldn't setup SAX parser", t);
            throw new Error(t);
        }
        try {
            InputStream in = this.getClass().getResourceAsStream("/" + descriptor);
            if (in != null) {
                LOG.info("Loading grammar through classloader");
            } else {
                in = new FileInputStream(new File(EnvironmentChecker.getProperty((Object)this, "user.dir", ".", "current directory for grammar"), descriptor));
            }
            parser.parse(new InputSource(new InputStreamReader(in)), (DefaultHandler)new Parser());
        }
        catch (Throwable t) {
            Gedcom.LOG.log(Level.SEVERE, "couldn't parse grammar", t);
            throw new Error(t);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public TagPath[] getAllPaths(String etag, Class property) {
        return this.getPathsRecursively(etag, property);
    }

    private TagPath[] getPathsRecursively(String etag, Class property) {
        ArrayList result = new ArrayList();
        Iterator it = this.tag2root.values().iterator();
        while (it.hasNext()) {
            MetaProperty root = (MetaProperty)it.next();
            String tag = root.getTag();
            if (etag != null && !tag.equals(etag)) continue;
            this.getPathsRecursively(root, property, new TagPath(tag), result);
        }
        return TagPath.toArray(result);
    }

    private void getPathsRecursively(MetaProperty meta, Class property, TagPath path, Collection result) {
        if (!meta.isInstantiated) {
            return;
        }
        if (property.isAssignableFrom(meta.getType())) {
            result.add(path);
        }
        Iterator it = meta.nested.iterator();
        while (it.hasNext()) {
            MetaProperty nested = (MetaProperty)it.next();
            this.getPathsRecursively(nested, property, new TagPath(path, nested.getTag()), result);
        }
    }

    public MetaProperty getMeta(TagPath path) {
        return this.getMeta(path, true);
    }

    public MetaProperty getMeta(TagPath path, boolean persist) {
        return this.getMetaRecursively(path, persist);
    }

    MetaProperty getMetaRecursively(TagPath path, boolean persist) {
        String tag = path.get(0);
        MetaProperty root = (MetaProperty)this.tag2root.get(tag);
        if (root == null) {
            root = new MetaProperty(this, tag, new HashMap(), false);
            this.tag2root.put(tag, root);
        }
        return root.getNestedRecursively(path, 1, persist);
    }

    private class Parser
    extends DefaultHandler {
        private Stack stack = null;

        private Parser() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            MetaProperty meta;
            if (this.stack == null) {
                if (!"GEDCOM".equals(qName)) {
                    throw new RuntimeException("expected GEDCOM");
                }
                Grammar.this.version = attributes.getValue("version");
                if (Grammar.this.version == null) {
                    throw new RuntimeException("expected GEDCOM version");
                }
                this.stack = new Stack();
                return;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            int j = attributes.getLength();
            for (int i = 0; i < j; ++i) {
                properties.put(attributes.getQName(i), attributes.getValue(i));
            }
            try {
                meta = new MetaProperty(Grammar.this, qName, properties, true);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Problem instantiating meta property for " + qName + " with " + properties, t.getCause() != null ? t.getCause() : t);
                throw new Error("Can't parse Gedcom Grammar");
            }
            if (this.stack.isEmpty()) {
                meta.isInstantiated = true;
                Grammar.this.tag2root.put(qName, meta);
            } else {
                ((MetaProperty)this.stack.peek()).addNested(meta);
            }
            this.stack.push(meta);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("GEDCOM".equals(qName)) {
                this.stack = null;
            } else {
                this.stack.pop();
            }
        }
    }
}

