/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Note;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.util.Origin;
import genj.util.ReferenceSet;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Gedcom
implements Comparable {
    static final Logger LOG = Logger.getLogger("genj.gedcom");
    private static Random seed = new Random();
    static Resources resources = Resources.get(Gedcom.class);
    public static final String UNICODE = "UNICODE";
    public static final String ASCII = "ASCII";
    public static final String ANSEL = "ANSEL";
    public static final String UTF8 = "UTF-8";
    public static final String LATIN1 = "LATIN1";
    public static final String ANSI = "ANSI";
    public static final String[] ENCODINGS = new String[]{"ANSEL", "UNICODE", "ASCII", "LATIN1", "ANSI", "UTF-8"};
    public static final String[] LANGUAGES = new String[]{"Afrikaans", "Albanian", "Amharic", "Anglo-Saxon", "Arabic", "Armenian", "Assamese", "Belorusian", "Bengali", "Braj", "Bulgarian", "Burmese", "Cantonese", "Catalan", "Catalan_Spn", "Church-Slavic", "Czech", "Danish", "Dogri", "Dutch", "English", "Esperanto", "Estonian", "Faroese", "Finnish", "French", "Georgian", "German", "Greek", "Gujarati", "Hawaiian", "Hebrew", "Hindi", "Hungarian", "Icelandic", "Indonesian", "Italian", "Japanese", "Kannada", "Khmer", "Konkani", "Korean", "Lahnda", "Lao", "Latvian", "Lithuanian", "Macedonian", "Maithili", "Malayalam", "Mandrin", "Manipuri", "Marathi", "Mewari", "Navaho", "Nepali", "Norwegian", "Oriya", "Pahari", "Pali", "Panjabi", "Persian", "Polish", "Prakrit", "Pusto", "Portuguese", "Rajasthani", "Romanian", "Russian", "Sanskrit", "Serb", "Serbo_Croa", "Slovak", "Slovene", "Spanish", "Swedish", "Tagalog", "Tamil", "Telugu", "Thai", "Tibetan", "Turkish", "Ukrainian", "Urdu", "Vietnamese", "Wendic", "Yiddish"};
    public static final String INDI = "INDI";
    public static final String FAM = "FAM";
    public static final String OBJE = "OBJE";
    public static final String NOTE = "NOTE";
    public static final String SOUR = "SOUR";
    public static final String SUBM = "SUBM";
    public static final String REPO = "REPO";
    public static final String[] ENTITIES = new String[]{"INDI", "FAM", "OBJE", "NOTE", "SOUR", "SUBM", "REPO"};
    private static final Map E2PREFIX = new HashMap();
    private static final Map E2TYPE;
    private static final Map E2IMAGE;
    private static final ImageIcon image;
    private Submitter submitter;
    private Grammar grammar = Grammar.V55;
    private Origin origin;
    private int maxIDLength = 0;
    private LinkedList allEntities = new LinkedList();
    private Map tag2id2entity = new HashMap();
    private boolean isDirty = false;
    private List undoHistory = new ArrayList();
    private List redoHistory = new ArrayList();
    private Object writeSemaphore = new Object();
    private Lock lock = null;
    private List listeners = new ArrayList(10);
    private Map tags2refsets = new HashMap();
    private String encoding;
    private String language;
    private Locale cachedLocale;
    private Collator cachedCollator;
    private String placeFormat;
    private String password;
    public static final String PASSWORD_NOT_SET = "PASSWORD_NOT_SET";
    public static final String PASSWORD_UNKNOWN = "PASSWORD_UNKNOWN";

    public Gedcom() {
        this(null);
    }

    public Gedcom(Origin origin) {
        this.encoding = ENCODINGS[Math.min(ENCODINGS.length - 1, Options.getInstance().defaultEncoding)];
        this.language = null;
        this.cachedLocale = null;
        this.cachedCollator = null;
        this.placeFormat = "";
        this.password = PASSWORD_NOT_SET;
        this.origin = origin;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public Submitter getSubmitter() {
        if (this.submitter == null) {
            return (Submitter)this.getFirstEntity(SUBM);
        }
        return this.submitter;
    }

    public void setSubmitter(Submitter set) {
        if (set != null && !this.getEntityMap(SUBM).containsValue(set)) {
            throw new IllegalArgumentException("Submitter is not part of this gedcom");
        }
        final Submitter old = this.submitter;
        this.submitter = set;
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                Gedcom.this.setSubmitter(old);
            }
        });
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            GedcomListener gl = gls[l];
            if (!(gl instanceof GedcomMetaListener)) continue;
            try {
                ((GedcomMetaListener)gl).gedcomHeaderChanged(this);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGedcomListener(GedcomListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener can't be null");
        }
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.add(listener)) {
                throw new IllegalArgumentException("can't add gedcom listener " + listener + "twice");
            }
        }
        LOG.log(Level.FINER, "addGedcomListener() from " + new Throwable().getStackTrace()[1] + " (now " + this.listeners.size() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGedcomListener(GedcomListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
        LOG.log(Level.FINER, "removeGedcomListener() from " + new Throwable().getStackTrace()[1] + " (now " + this.listeners.size() + ")");
    }

    private List getCurrentUndoSet() {
        return (List)this.undoHistory.get(this.undoHistory.size() - 1);
    }

    protected void propagateXRefLinked(final PropertyXRef property1, PropertyXRef property2) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Property " + property1.getTag() + " and " + property2.getTag() + " linked");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                property1.unlink();
            }
        });
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            try {
                gls[l].gedcomPropertyChanged(this, property1);
                gls[l].gedcomPropertyChanged(this, property2);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    protected void propagateXRefUnlinked(final PropertyXRef property1, final PropertyXRef property2) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Property " + property1.getTag() + " and " + property2.getTag() + " unlinked");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                property1.link(property2);
            }
        });
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            try {
                gls[l].gedcomPropertyChanged(this, property1);
                gls[l].gedcomPropertyChanged(this, property2);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    protected void propagateEntityAdded(final Entity entity) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Entity " + entity.getId() + " added");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                Gedcom.this.deleteEntity(entity);
            }
        });
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            try {
                gls[l].gedcomEntityAdded(this, entity);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    protected void propagateEntityDeleted(final Entity entity) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Entity " + entity.getId() + " deleted");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() throws GedcomException {
                Gedcom.this.addEntity(entity);
            }
        });
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            try {
                gls[l].gedcomEntityDeleted(this, entity);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    protected void propagatePropertyAdded(Entity entity, final Property container, final int pos, Property added) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Property " + added.getTag() + " added to " + container.getTag() + " at position " + pos + " (entity " + entity.getId() + ")");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                container.delProperty(pos);
            }
        });
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            try {
                gls[l].gedcomPropertyAdded(this, container, pos, added);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    protected void propagatePropertyDeleted(Entity entity, final Property container, final int pos, final Property deleted) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Property " + deleted.getTag() + " deleted from " + container.getTag() + " at position " + pos + " (entity " + entity.getId() + ")");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                container.addProperty(deleted, pos);
            }
        });
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            try {
                gls[l].gedcomPropertyDeleted(this, container, pos, deleted);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    protected void propagatePropertyChanged(Entity entity, final Property property, final String oldValue) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Property " + property.getTag() + " changed in (entity " + entity.getId() + ")");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                property.setValue(oldValue);
            }
        });
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            try {
                gls[l].gedcomPropertyChanged(this, property);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    protected void propagatePropertyMoved(final Property property, final Property moved, final int from, final int to) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Property " + property.getTag() + " moved from " + from + " to " + to + " (entity " + property.getEntity().getId() + ")");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                property.moveProperty(moved, from < to ? from : from + 1);
            }
        });
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            try {
                gls[l].gedcomPropertyDeleted(this, property, from, moved);
                gls[l].gedcomPropertyAdded(this, property, to, moved);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    protected void propagateWriteLockAqcuired() {
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            GedcomListener gl = gls[l];
            if (!(gl instanceof GedcomMetaListener)) continue;
            try {
                ((GedcomMetaListener)gl).gedcomWriteLockAcquired(this);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    protected void propagateBeforeUnitOfWork() {
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            GedcomListener gl = gls[l];
            if (!(gl instanceof GedcomMetaListener)) continue;
            try {
                ((GedcomMetaListener)gl).gedcomBeforeUnitOfWork(this);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    protected void propagateAfterUnitOfWork() {
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            GedcomListener gl = gls[l];
            if (!(gl instanceof GedcomMetaListener)) continue;
            try {
                ((GedcomMetaListener)gl).gedcomAfterUnitOfWork(this);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    protected void propagateWriteLockReleased() {
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            GedcomListener gl = gls[l];
            if (!(gl instanceof GedcomMetaListener)) continue;
            try {
                ((GedcomMetaListener)gl).gedcomWriteLockReleased(this);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    protected void propagateEntityIDChanged(final Entity entity, final String old) throws GedcomException {
        Map id2entity = this.getEntityMap(entity.getTag());
        if (!id2entity.containsValue(entity)) {
            throw new GedcomException("Can't change ID of entity not part of this Gedcom instance");
        }
        String id = entity.getId();
        if (id == null || id.length() == 0) {
            throw new GedcomException("Need valid ID length");
        }
        if (this.getEntity(id) != null) {
            throw new GedcomException("Duplicate ID is not allowed");
        }
        id2entity.remove(old);
        id2entity.put(entity.getId(), entity);
        this.maxIDLength = Math.max(id.length(), this.maxIDLength);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Entity's ID changed from  " + old + " to " + entity.getId());
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() throws GedcomException {
                entity.setId(old);
            }
        });
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            try {
                gls[l].gedcomPropertyChanged(this, entity);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    private void addEntity(Entity entity) throws GedcomException {
        String id = entity.getId();
        if (id.length() > 0) {
            Map id2entity = this.getEntityMap(entity.getTag());
            if (id2entity.containsKey(id)) {
                throw new GedcomException(resources.getString("error.entity.dupe", id));
            }
            id2entity.put(id, entity);
        }
        this.allEntities.add(entity);
        entity.addNotify(this);
    }

    public Entity createEntity(String tag) throws GedcomException {
        return this.createEntity(tag, null);
    }

    public Entity createEntity(String tag, String id) throws GedcomException {
        Entity result;
        if (id == null) {
            id = this.getNextAvailableID(tag);
        }
        this.maxIDLength = Math.max(id.length(), this.maxIDLength);
        Class clazz = (Class)E2TYPE.get(tag);
        if (clazz != null) {
            if (id.length() == 0) {
                throw new GedcomException(resources.getString("entity.error.noid", tag));
            }
        } else {
            clazz = Entity.class;
        }
        try {
            result = (Entity)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Can't instantiate " + clazz);
        }
        result.init(tag, id);
        this.addEntity(result);
        return result;
    }

    public void deleteEntity(Entity which) {
        String id = which.getId();
        if (id.length() > 0) {
            Map id2entity = this.getEntityMap(which.getTag());
            if (!id2entity.containsKey(id)) {
                throw new IllegalArgumentException("Unknown entity with id " + which.getId());
            }
            id2entity.remove(id);
        }
        which.beforeDelNotify();
        this.allEntities.remove(which);
        if (this.submitter == which) {
            this.submitter = null;
        }
    }

    private Map getEntityMap(String tag) {
        HashMap id2entity = (HashMap)this.tag2id2entity.get(tag);
        if (id2entity == null) {
            id2entity = new HashMap();
            this.tag2id2entity.put(tag, id2entity);
        }
        return id2entity;
    }

    public Property[] getProperties(TagPath path) {
        ArrayList<Property> result = new ArrayList<Property>(100);
        Iterator it = this.getEntities(path.getFirst()).iterator();
        while (it.hasNext()) {
            Entity ent = (Entity)it.next();
            Property[] props = ent.getProperties(path);
            for (int i = 0; i < props.length; ++i) {
                result.add(props[i]);
            }
        }
        return Property.toArray(result);
    }

    public List getEntities() {
        return Collections.unmodifiableList(this.allEntities);
    }

    public Collection getEntities(String tag) {
        return Collections.unmodifiableCollection(this.getEntityMap(tag).values());
    }

    public Entity[] getEntities(String tag, String sortPath) {
        return this.getEntities(tag, sortPath != null && sortPath.length() > 0 ? new PropertyComparator(sortPath) : null);
    }

    public Entity[] getEntities(String tag, Comparator comparator) {
        Collection ents = this.getEntityMap(tag).values();
        Object[] result = ents.toArray(new Entity[ents.size()]);
        if (comparator != null) {
            Arrays.sort(result, comparator);
        } else {
            Arrays.sort(result);
        }
        return result;
    }

    public Entity getEntity(String id) {
        Iterator tags = this.tag2id2entity.keySet().iterator();
        while (tags.hasNext()) {
            Entity result = (Entity)this.getEntityMap((String)tags.next()).get(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Entity getEntity(String tag, String id) {
        return (Entity)this.getEntityMap(tag).get(id);
    }

    public static Class getEntityType(String tag) {
        Class result = (Class)E2TYPE.get(tag);
        if (result == null) {
            throw new IllegalArgumentException("no such type");
        }
        return result;
    }

    public Entity getFirstEntity(String tag) {
        Iterator it = this.allEntities.iterator();
        while (it.hasNext()) {
            Entity e = (Entity)it.next();
            if (!e.getTag().equals(tag)) continue;
            return e;
        }
        return null;
    }

    public String getNextAvailableID(String entity) {
        Map id2entity = this.getEntityMap(entity);
        int id = Options.getInstance().isFillGapsInIDs ? 1 : (id2entity.isEmpty() ? 1 : id2entity.size());
        StringBuffer buf = new StringBuffer(this.maxIDLength);
        block0: while (true) {
            buf.setLength(0);
            buf.append(Gedcom.getEntityPrefix(entity));
            buf.append(id);
            while (!id2entity.containsKey(buf.toString())) {
                if (buf.length() >= this.maxIDLength) break block0;
                buf.insert(1, '0');
            }
            ++id;
        }
        return Gedcom.getEntityPrefix(entity) + id;
    }

    public boolean hasChanged() {
        return this.isDirty || !this.undoHistory.isEmpty();
    }

    public void setUnchanged() {
        this.undoHistory.clear();
        this.isDirty = false;
        if (this.lock == null) {
            return;
        }
        GedcomListener[] gls = this.listeners.toArray(new GedcomListener[this.listeners.size()]);
        for (int l = 0; l < gls.length; ++l) {
            GedcomListener gl = gls[l];
            if (!(gl instanceof GedcomMetaListener)) continue;
            try {
                ((GedcomMetaListener)gl).gedcomHeaderChanged(this);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "exception in gedcom listener " + gls[l], t);
            }
        }
    }

    public boolean isWriteLocked() {
        return this.lock != null;
    }

    public void doMuteUnitOfWork(UnitOfWork uow) {
        try {
            this.doUnitOfWork(uow);
        }
        catch (GedcomException e) {
            LOG.log(Level.WARNING, "Unexpected gedcom exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnitOfWork(UnitOfWork uow) throws GedcomException {
        PropertyChange.Monitor updater;
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (this.lock != null) {
                throw new GedcomException("Cannot obtain write lock");
            }
            this.lock = new Lock(uow);
            updater = new PropertyChange.Monitor();
            this.addGedcomListener(updater);
            this.redoHistory.clear();
        }
        this.propagateWriteLockAqcuired();
        Throwable rethrow = null;
        try {
            uow.perform(this);
        }
        catch (Throwable t) {
            rethrow = t;
        }
        Object object2 = this.writeSemaphore;
        synchronized (object2) {
            if (!this.lock.undos.isEmpty()) {
                this.undoHistory.add(this.lock.undos);
                while (this.undoHistory.size() > Options.getInstance().getNumberOfUndos()) {
                    this.undoHistory.remove(0);
                    this.isDirty = true;
                }
            }
            this.propagateWriteLockReleased();
            this.lock = null;
            this.removeGedcomListener(updater);
        }
        if (rethrow != null) {
            if (rethrow instanceof GedcomException) {
                throw (GedcomException)rethrow;
            }
            throw new RuntimeException(rethrow);
        }
    }

    public boolean canUndo() {
        return !this.undoHistory.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoUnitOfWork() {
        if (this.undoHistory.isEmpty()) {
            throw new IllegalArgumentException("undo n/a");
        }
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (this.lock != null) {
                throw new IllegalStateException("Cannot obtain write lock");
            }
            this.lock = new Lock();
        }
        this.propagateWriteLockAqcuired();
        List todo = (List)this.undoHistory.remove(this.undoHistory.size() - 1);
        for (int i = todo.size() - 1; i >= 0; --i) {
            Undo undo = (Undo)todo.remove(i);
            try {
                undo.undo();
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Unexpected throwable during undo()", t);
            }
        }
        Object object2 = this.writeSemaphore;
        synchronized (object2) {
            this.redoHistory.add(this.lock.undos);
            this.propagateWriteLockReleased();
            this.lock = null;
        }
    }

    public boolean canRedo() {
        return !this.redoHistory.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoUnitOfWork() {
        if (this.redoHistory.isEmpty()) {
            throw new IllegalArgumentException("redo n/a");
        }
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (this.lock != null) {
                throw new IllegalStateException("Cannot obtain write lock");
            }
            this.lock = new Lock();
        }
        this.propagateWriteLockAqcuired();
        List todo = (List)this.redoHistory.remove(this.redoHistory.size() - 1);
        for (int i = todo.size() - 1; i >= 0; --i) {
            Undo undo = (Undo)todo.remove(i);
            try {
                undo.undo();
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Unexpected throwable during undo()", t);
            }
        }
        Object object2 = this.writeSemaphore;
        synchronized (object2) {
            this.undoHistory.add(this.lock.undos);
            this.propagateWriteLockReleased();
            this.lock = null;
        }
    }

    ReferenceSet getReferenceSet(String tag) {
        ReferenceSet result = (ReferenceSet)this.tags2refsets.get(tag);
        if (result == null) {
            result = new ReferenceSet();
            this.tags2refsets.put(tag, result);
            String defaults = resources.getString(tag + ".vals", false);
            if (defaults != null) {
                StringTokenizer tokens = new StringTokenizer(defaults, ",");
                while (tokens.hasMoreElements()) {
                    result.add(tokens.nextToken().trim(), null);
                }
            }
        }
        return result;
    }

    public String getName() {
        return this.origin == null ? null : this.origin.getName();
    }

    public static String getName(String tag) {
        return Gedcom.getName(tag, false);
    }

    public static String getName(String tag, boolean plural) {
        String name;
        if (plural && (name = resources.getString(tag + ".s.name", false)) != null) {
            return name;
        }
        name = resources.getString(tag + ".name", false);
        return name != null ? name : tag;
    }

    public static String getEntityPrefix(String tag) {
        String result = (String)E2PREFIX.get(tag);
        if (result == null) {
            result = "X";
        }
        return result;
    }

    public static ImageIcon getImage() {
        return image;
    }

    public static ImageIcon getEntityImage(String tag) {
        ImageIcon result = (ImageIcon)E2IMAGE.get(tag);
        if (result == null) {
            result = Grammar.V55.getMeta(new TagPath(tag)).getImage();
            E2IMAGE.put(tag, result);
        }
        return result;
    }

    public static Resources getResources() {
        return resources;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String set) {
        for (int e = 0; e < ENCODINGS.length; ++e) {
            if (!ENCODINGS[e].equals(set)) continue;
            this.encoding = set;
            return;
        }
    }

    public String getPlaceFormat() {
        return this.placeFormat;
    }

    public void setPlaceFormat(String set) {
        this.placeFormat = set.trim();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String set) {
        this.language = set;
    }

    public void setPassword(String set) {
        if (set == null) {
            throw new IllegalArgumentException("Password can't be null");
        }
        this.password = set;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean hasPassword() {
        return this.password != PASSWORD_NOT_SET && this.password != PASSWORD_UNKNOWN;
    }

    public boolean contains(Entity entity) {
        return this.getEntityMap(entity.getTag()).containsValue(entity);
    }

    public Locale getLocale() {
        if (this.cachedLocale == null) {
            if (this.language != null) {
                Locale[] locales = Locale.getAvailableLocales();
                for (int i = 0; i < locales.length; ++i) {
                    if (!locales[i].getDisplayLanguage(Locale.ENGLISH).equalsIgnoreCase(this.language)) continue;
                    this.cachedLocale = new Locale(locales[i].getLanguage(), Locale.getDefault().getCountry());
                    break;
                }
            }
            if (this.cachedLocale == null) {
                this.cachedLocale = Locale.getDefault();
            }
        }
        return this.cachedLocale;
    }

    public Collator getCollator() {
        if (this.cachedCollator == null) {
            this.cachedCollator = Collator.getInstance(this.getLocale());
            this.cachedCollator.setStrength(0);
        }
        return this.cachedCollator;
    }

    public int compareTo(Object other) {
        Gedcom that = (Gedcom)other;
        return this.getName().compareTo(that.getName());
    }

    static {
        E2PREFIX.put(INDI, "I");
        E2PREFIX.put(FAM, "F");
        E2PREFIX.put(OBJE, "M");
        E2PREFIX.put(NOTE, "N");
        E2PREFIX.put(SOUR, "S");
        E2PREFIX.put(SUBM, "B");
        E2PREFIX.put(REPO, "R");
        E2TYPE = new HashMap();
        E2TYPE.put(INDI, Indi.class);
        E2TYPE.put(FAM, Fam.class);
        E2TYPE.put(OBJE, Media.class);
        E2TYPE.put(NOTE, Note.class);
        E2TYPE.put(SOUR, Source.class);
        E2TYPE.put(SUBM, Submitter.class);
        E2TYPE.put(REPO, Repository.class);
        E2IMAGE = new HashMap();
        image = new ImageIcon(Gedcom.class, "images/Gedcom.gif");
    }

    private class Lock
    implements UnitOfWork {
        UnitOfWork uow;
        List undos = new ArrayList();

        Lock() {
            this.uow = this;
        }

        Lock(UnitOfWork uow) {
            this.uow = uow;
        }

        public void perform(Gedcom gedcom) {
        }

        void addChange(Undo run) {
            this.undos.add(run);
        }
    }

    private abstract class Undo {
        private Undo() {
        }

        abstract void undo() throws GedcomException;
    }
}

