/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyWife;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class Fam
extends Entity {
    public static final TagPath PATH_FAMMARRDATE = new TagPath("FAM:MARR:DATE");
    public static final TagPath PATH_FAMMARRPLAC = new TagPath("FAM:MARR:PLAC");
    public static final TagPath PATH_FAMDIVDATE = new TagPath("FAM:DIV:DATE");
    public static final TagPath PATH_FAMDIVPLAC = new TagPath("FAM:MARR:PLAC");
    private static final Comparator SORT_SIBLINGS = new PropertyComparator("INDI:BIRT:DATE");

    public Indi getChild(int which) {
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (!"CHIL".equals(prop.getTag()) || !prop.isValid()) continue;
            if (which == 0) {
                return ((PropertyChild)prop).getChild();
            }
            --which;
        }
        throw new IllegalArgumentException("no such child");
    }

    public Indi[] getChildren() {
        return this.getChildren(true);
    }

    public Indi[] getChildren(boolean sorted) {
        ArrayList<Indi> children = new ArrayList<Indi>(this.getNoOfProperties());
        List childs = this.getProperties(PropertyChild.class);
        int j = childs.size();
        for (int i = 0; i < j; ++i) {
            PropertyChild prop = (PropertyChild)childs.get(i);
            Indi child = prop.getChild();
            if (!prop.isValid() || children.contains(child)) continue;
            children.add(child);
        }
        Indi[] result = Indi.toIndiArray(children);
        if (sorted) {
            Arrays.sort(result, SORT_SIBLINGS);
        }
        return result;
    }

    public Indi getHusband() {
        Property husb = this.getProperty("HUSB", true);
        if (husb instanceof PropertyHusband) {
            return ((PropertyHusband)husb).getHusband();
        }
        return null;
    }

    public int getNoOfChildren() {
        int result = 0;
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (prop.getClass() != (class$genj$gedcom$PropertyChild == null ? Fam.class$("genj.gedcom.PropertyChild") : class$genj$gedcom$PropertyChild) || !prop.isValid()) continue;
            ++result;
        }
        return result;
    }

    public int getNoOfSpouses() {
        int result = 0;
        if (this.getHusband() != null) {
            ++result;
        }
        if (this.getWife() != null) {
            ++result;
        }
        return result;
    }

    public Indi getSpouse(int which) {
        Indi wife;
        Indi husband = this.getHusband();
        if (husband != null) {
            if (which == 0) {
                return husband;
            }
            --which;
        }
        if ((wife = this.getWife()) != null) {
            if (which == 0) {
                return wife;
            }
            --which;
        }
        throw new IllegalArgumentException("No such spouse");
    }

    public Indi getOtherSpouse(Indi spouse) {
        Indi wife = this.getWife();
        if (wife == spouse) {
            return this.getHusband();
        }
        return wife;
    }

    public Indi getWife() {
        Property wife = this.getProperty("WIFE", true);
        if (wife instanceof PropertyWife) {
            return ((PropertyWife)wife).getWife();
        }
        return null;
    }

    public PropertyXRef setHusband(Indi husband) throws GedcomException {
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (!"HUSB".equals(prop.getTag()) || !prop.isValid()) continue;
            this.delProperty(prop);
            break;
        }
        if (husband == null) {
            return null;
        }
        PropertyHusband ph = new PropertyHusband(husband.getId());
        this.addProperty(ph);
        try {
            ph.link();
        }
        catch (GedcomException ex) {
            this.delProperty(ph);
            throw ex;
        }
        if (husband.getSex() != 1) {
            husband.setSex(1);
        }
        return ph;
    }

    public PropertyXRef setWife(Indi wife) throws GedcomException {
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (!"WIFE".equals(prop.getTag()) || !prop.isValid()) continue;
            this.delProperty(prop);
            break;
        }
        if (wife == null) {
            return null;
        }
        PropertyWife pw = new PropertyWife(wife.getId());
        this.addProperty(pw);
        try {
            pw.link();
        }
        catch (GedcomException ex) {
            this.delProperty(pw);
            throw ex;
        }
        if (wife.getSex() != 2) {
            wife.setSex(2);
        }
        return pw;
    }

    public PropertyXRef setSpouse(Indi spouse) throws GedcomException {
        PropertyXRef HUSBorWIFE;
        Indi husband = this.getHusband();
        Indi wife = this.getWife();
        if (husband != null && wife != null) {
            throw new GedcomException(resources.getString("error.already.spouses", this));
        }
        switch (spouse.getSex()) {
            default: {
                HUSBorWIFE = husband != null ? this.setWife(spouse) : this.setHusband(spouse);
                break;
            }
            case 1: {
                HUSBorWIFE = this.setHusband(spouse);
                if (husband == null) break;
                this.setWife(husband);
                break;
            }
            case 2: {
                HUSBorWIFE = this.setWife(spouse);
                if (wife == null) break;
                this.setHusband(wife);
            }
        }
        return HUSBorWIFE;
    }

    public PropertyXRef addChild(Indi newChild) throws GedcomException {
        PropertyChild pc = new PropertyChild(newChild.getId());
        this.addProperty(pc);
        try {
            pc.link();
        }
        catch (GedcomException ex) {
            this.delProperty(pc);
            throw ex;
        }
        return pc;
    }

    static Fam[] toFamArray(Collection c) {
        return c.toArray(new Fam[c.size()]);
    }

    public String toString() {
        Indi wife;
        StringBuffer result = new StringBuffer();
        Indi husband = this.getHusband();
        if (husband != null) {
            result.append(husband.toString());
            result.append(Options.getInstance().getTxtMarriageSymbol());
        }
        if ((wife = this.getWife()) != null) {
            result.append(wife.toString());
        }
        return super.toString(result);
    }

    public PropertyDate getMarriageDate() {
        return this.getMarriageDate(false);
    }

    public PropertyDate getMarriageDate(boolean create) {
        PropertyDate date = (PropertyDate)this.getProperty(PATH_FAMMARRDATE);
        if (null != date || !create) {
            return date;
        }
        this.setValue(PATH_FAMMARRDATE, "");
        return (PropertyDate)this.getProperty(PATH_FAMMARRDATE);
    }

    public PropertyDate getDivorceDate() {
        return (PropertyDate)this.getProperty(PATH_FAMDIVDATE);
    }

    public void swapSpouses() throws GedcomException {
        Indi husband = this.getHusband();
        Indi wife = this.getWife();
        this.setWife(null);
        this.setHusband(null);
        if (wife != null) {
            this.setHusband(wife);
        }
        if (husband != null) {
            this.setWife(husband);
        }
    }
}

