/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyXRef;

public class Entity
extends Property {
    private Gedcom gedcom;
    private String id;
    private String tag;
    private String value;

    void addNotify(Gedcom ged) {
        this.gedcom = ged;
        ged.propagateEntityAdded(this);
    }

    void beforeDelNotify() {
        this.delProperties();
        this.gedcom.propagateEntityDeleted(this);
        this.gedcom = null;
    }

    public PropertyChange getLastChange() {
        return (PropertyChange)this.getProperty("CHAN");
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    public Entity getEntity() {
        return this;
    }

    public void setId(String set) throws GedcomException {
        String old = this.id;
        this.id = set;
        if (this.gedcom != null) {
            try {
                this.gedcom.propagateEntityIDChanged(this, old);
            }
            catch (Throwable t) {
                this.id = old;
            }
        }
    }

    public String getId() {
        return this.id;
    }

    void init(String setTag, String setId) {
        this.tag = setTag;
        this.id = setId;
    }

    public String toString() {
        return this.toString(new StringBuffer());
    }

    protected String toString(String prefix) {
        return this.toString(new StringBuffer(prefix));
    }

    protected String toString(StringBuffer prefix) {
        if (prefix.length() == 0) {
            prefix.append(this.getTag());
        }
        prefix.append(" (");
        prefix.append(this.getId());
        prefix.append(')');
        return prefix.toString();
    }

    public String getTag() {
        return this.tag;
    }

    public String getValue() {
        return this.value != null ? this.value : "";
    }

    public void setValue(String set) {
        this.value = set;
    }

    public int compareTo(Object o) {
        try {
            Entity other = (Entity)o;
            return this.getID() - other.getID();
        }
        catch (Throwable throwable) {
            return super.compareTo(o);
        }
    }

    private int getID() throws NumberFormatException {
        int start;
        int end = this.id.length() - 1;
        for (start = 0; start <= end && !Character.isDigit(this.id.charAt(start)); ++start) {
        }
        while (end >= start && !Character.isDigit(this.id.charAt(end))) {
            --end;
        }
        if (end < start) {
            throw new NumberFormatException();
        }
        return Integer.parseInt(this.id.substring(start, end + 1));
    }

    public String format(String propertyTag, String format) {
        Property p = this.getProperty(propertyTag);
        return p != null ? p.format(format) : "";
    }

    void propagateXRefLinked(PropertyXRef property1, PropertyXRef property2) {
        if (this.gedcom != null) {
            this.gedcom.propagateXRefLinked(property1, property2);
        }
    }

    void propagateXRefUnlinked(PropertyXRef property1, PropertyXRef property2) {
        if (this.gedcom != null) {
            this.gedcom.propagateXRefUnlinked(property1, property2);
        }
    }

    void propagatePropertyAdded(Property container, int pos, Property added) {
        if (this.gedcom != null) {
            this.gedcom.propagatePropertyAdded(this, container, pos, added);
        }
    }

    void propagatePropertyDeleted(Property container, int pos, Property deleted) {
        if (this.gedcom != null) {
            this.gedcom.propagatePropertyDeleted(this, container, pos, deleted);
        }
    }

    void propagatePropertyChanged(Property property, String oldValue) {
        if (this.gedcom != null) {
            this.gedcom.propagatePropertyChanged(this, property, oldValue);
        }
    }

    void propagatePropertyMoved(Property property, Property moved, int from, int to) {
        if (this.gedcom != null) {
            this.gedcom.propagatePropertyMoved(property, moved, from, to);
        }
    }
}

