/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.util.swing.ImageIcon;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class Context
implements Comparable {
    private Gedcom gedcom;
    private List entities = new ArrayList();
    private List properties = new ArrayList();
    private Class entityType = null;
    private Class propertyType = null;
    private ImageIcon img = null;
    private String txt = null;

    public Context(Context context) {
        this.gedcom = context.gedcom;
        this.entities.addAll(context.entities);
        this.properties.addAll(context.properties);
        this.entityType = context.entityType;
        this.propertyType = context.propertyType;
        this.img = context.img;
        this.txt = context.txt;
    }

    public Context(Gedcom ged) {
        if (ged == null) {
            throw new IllegalArgumentException("gedcom for context can't be null");
        }
        this.gedcom = ged;
    }

    public Context(Property prop) {
        this(prop.getGedcom());
        this.addProperty(prop);
    }

    public Context(Entity entity) {
        this(entity.getGedcom());
        this.addEntity(entity);
    }

    public void addEntity(Entity e) {
        if (e.getGedcom() != this.gedcom) {
            throw new IllegalArgumentException("entity's gedcom can't be different");
        }
        this.entities.remove(e);
        this.entityType = this.entityType != null && this.entityType != e.getClass() ? Entity.class : e.getClass();
        this.entities.add(e);
    }

    public void addEntities(Entity[] es) {
        for (int i = 0; i < es.length; ++i) {
            this.addEntity(es[i]);
        }
    }

    public void removeEntities(Collection rem) {
        this.entities.removeAll(rem);
        ListIterator iterator = this.properties.listIterator();
        while (iterator.hasNext()) {
            Property prop = (Property)iterator.next();
            if (!rem.contains(prop.getEntity())) continue;
            iterator.remove();
        }
    }

    public void addProperty(Property p) {
        this.addEntity(p.getEntity());
        if (p instanceof Entity) {
            return;
        }
        if (p.getGedcom() != this.gedcom) {
            throw new IllegalArgumentException("property's gedcom can't be different");
        }
        this.properties.remove(p);
        this.propertyType = this.propertyType != null && this.propertyType != p.getClass() ? Property.class : p.getClass();
        this.properties.add(p);
    }

    public void addProperties(Property[] ps) {
        for (int i = 0; i < ps.length; ++i) {
            this.addProperty(ps[i]);
        }
    }

    public void removeProperties(Collection rem) {
        this.properties.removeAll(rem);
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    public Entity getEntity() {
        return this.entities.isEmpty() ? null : (Entity)this.entities.get(0);
    }

    public Property getProperty() {
        return this.properties.isEmpty() ? null : (Property)this.properties.get(0);
    }

    public Entity[] getEntities() {
        if (this.entityType == null) {
            return new Entity[0];
        }
        return this.entities.toArray((Entity[])Array.newInstance(this.entityType, this.entities.size()));
    }

    public Property[] getProperties() {
        if (this.propertyType == null) {
            return new Property[0];
        }
        return this.properties.toArray((Property[])Array.newInstance(this.propertyType, this.properties.size()));
    }

    public String getText() {
        if (this.txt != null) {
            return this.txt;
        }
        if (this.properties.size() == 1) {
            Property prop = (Property)this.properties.get(0);
            this.txt = Gedcom.getName(prop.getTag()) + "/" + prop.getEntity();
        } else {
            this.txt = !this.properties.isEmpty() ? Property.getPropertyNames(Property.toArray(this.properties), 5) : (this.entities.size() == 1 ? this.entities.get(0).toString() : (!this.entities.isEmpty() ? Entity.getPropertyNames(Property.toArray(this.entities), 5) : this.gedcom.getName()));
        }
        return this.txt;
    }

    public Context setText(String text) {
        this.txt = text;
        return this;
    }

    public ImageIcon getImage() {
        if (this.img != null) {
            return this.img;
        }
        this.img = this.properties.size() == 1 ? ((Property)this.properties.get(0)).getImage(false) : (this.entities.size() == 1 ? ((Entity)this.entities.get(0)).getImage(false) : Gedcom.getImage());
        return this.img;
    }

    public Context setImage(ImageIcon set) {
        this.img = set;
        return this;
    }

    public void addContext(Context context) {
        if (context.getGedcom() != this.getGedcom()) {
            throw new IllegalArgumentException();
        }
        this.addProperties(context.getProperties());
        this.addEntities(context.getEntities());
    }

    public int compareTo(Object o) {
        Context that = (Context)o;
        if (this.txt == null) {
            return -1;
        }
        if (that.txt == null) {
            return 1;
        }
        return this.txt.compareTo(that.txt);
    }
}

