/*
 * Decompiled with CFR 0.152.
 */
package genj.fo;

import genj.fo.Document;
import genj.fo.Format;
import genj.util.EnvironmentChecker;
import genj.util.Registry;
import genj.util.swing.FileChooserWidget;
import genj.util.swing.NestedBlockLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FormatOptionsWidget
extends JPanel {
    private Action validAction;
    private Document doc;
    private FileChooserWidget chooseFile;
    private JComboBox chooseFormat;

    public FormatOptionsWidget(Document document, Registry registry) {
        this.setLayout(new NestedBlockLayout("<col><row><label/><file wx=\"1\"/></row><row><label/><format wx=\"1\"/></row></col>"));
        this.doc = document;
        this.chooseFile = new FileChooserWidget();
        String file = registry.get("file", (String)null);
        if (file != null) {
            File f = new File(file);
            this.chooseFile.setFile(f);
            this.chooseFile.setDirectory(f.getParent());
        }
        this.add(new JLabel("File"));
        this.add(this.chooseFile);
        this.chooseFormat = new JComboBox<Format>(Format.getFormats());
        this.chooseFormat.setSelectedItem(Format.getFormat(registry.get("format", (String)null)));
        this.chooseFormat.setEditable(false);
        this.add(new JLabel("Format"));
        this.add(this.chooseFormat);
        this.chooseFile.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FormatOptionsWidget.this.validateOptions(false);
            }
        });
        this.chooseFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FormatOptionsWidget.this.validateOptions(true);
            }
        });
    }

    public void remember(Registry registry) {
        registry.put("format", this.getFormat().getFormat());
        registry.put("file", this.getFile().getAbsolutePath());
    }

    public Format getFormat() {
        return (Format)this.chooseFormat.getSelectedItem();
    }

    public File getFile() {
        Format format;
        File result = this.chooseFile.getFile();
        if (result.getPath().length() == 0) {
            return null;
        }
        if (result.getParentFile() == null) {
            result = new File(EnvironmentChecker.getProperty((Object)this, "user.home", ".", "home directory for report output"), result.getPath());
        }
        if ((format = this.getFormat()).getFileExtension() == null) {
            return result;
        }
        String path = result.getPath();
        Format[] formats = Format.getFormats();
        for (int f = 0; f < formats.length; ++f) {
            String suffix = "." + formats[f].getFileExtension();
            if (!path.endsWith(suffix)) continue;
            path = path.substring(0, path.length() - suffix.length());
        }
        return new File(path + "." + format.getFileExtension());
    }

    public void connect(Action validAction) {
        this.validAction = validAction;
        this.validateOptions(true);
    }

    private void validateOptions(boolean updateFilename) {
        Format format = this.getFormat();
        boolean valid = true;
        if (format.getFileExtension() != null && this.chooseFile.isEmpty()) {
            valid = false;
        }
        this.chooseFile.setEnabled(format.getFileExtension() != null);
        if (!format.supports(this.doc)) {
            valid = false;
        }
        if (updateFilename) {
            this.chooseFile.setFile(this.getFile());
        }
        this.validAction.setEnabled(valid);
    }
}

