/*
 * Decompiled with CFR 0.152.
 */
package genj.entity;

import genj.entity.EntityView;
import genj.renderer.BlueprintList;
import genj.renderer.BlueprintManager;
import genj.view.Settings;
import genj.view.ViewManager;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;

public class EntityViewSettings
extends JTabbedPane
implements Settings {
    private EntityView entityView;
    private BlueprintList blueprintList;
    private JCheckBox checkAntialiasing = new JCheckBox(EntityView.resources.getString("antialiasing"));

    public void init(ViewManager manager) {
        Box main = new Box(1);
        this.checkAntialiasing.setToolTipText(EntityView.resources.getString("antialiasing.tip"));
        main.add(this.checkAntialiasing);
        this.blueprintList = new BlueprintList(BlueprintManager.getInstance());
        this.add(EntityView.resources.getString("page.main"), main);
        this.add(EntityView.resources.getString("page.blueprints"), this.blueprintList);
    }

    public void setView(JComponent view) {
        this.entityView = (EntityView)view;
        this.blueprintList.setGedcom(this.entityView.gedcom);
    }

    private Integer wrap(int type) {
        return new Integer(type);
    }

    private int unwrap(Object type) {
        return (Integer)type;
    }

    public void apply() {
        this.entityView.setAntialiasing(this.checkAntialiasing.isSelected());
        this.entityView.setBlueprints(this.blueprintList.getSelection());
    }

    public void reset() {
        this.checkAntialiasing.setSelected(this.entityView.isAntialiasing());
        this.blueprintList.setSelection(this.entityView.getBlueprints());
    }

    public JComponent getEditor() {
        return this;
    }
}

