/*
 * Decompiled with CFR 0.152.
 */
package genj.entity;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Property;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.EntityRenderer;
import genj.util.Registry;
import genj.util.Resources;
import genj.view.ContextProvider;
import genj.view.ContextSelectionEvent;
import genj.view.ToolBarSupport;
import genj.view.ViewContext;
import genj.view.ViewManager;
import genj.window.WindowBroadcastEvent;
import genj.window.WindowBroadcastListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import spin.Spin;

public class EntityView
extends JPanel
implements WindowBroadcastListener,
ToolBarSupport,
ContextProvider {
    static final Resources resources = Resources.get(EntityView.class);
    private static final Blueprint BLUEPRINT_SELECT = new Blueprint(resources.getString("html.select"));
    private Registry registry;
    private EntityRenderer renderer = null;
    Gedcom gedcom = null;
    private Entity entity = null;
    private Map type2blueprint = new HashMap();
    private boolean isAntialiasing = false;
    private GedcomListener callback = new GedcomListenerAdapter(){

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (EntityView.this.entity == entity) {
                EntityView.this.setEntity(gedcom.getFirstEntity("INDI"));
            }
            EntityView.this.repaint();
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            if (property.getEntity() == EntityView.this.entity) {
                EntityView.this.repaint();
            }
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
            this.gedcomPropertyChanged(gedcom, property);
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property removed) {
            this.gedcomPropertyChanged(gedcom, property);
        }
    };
    ViewManager viewManager;

    public EntityView(String title, Gedcom ged, Registry reg, ViewManager manager) {
        this.viewManager = manager;
        this.registry = reg;
        this.gedcom = ged;
        BlueprintManager bpm = BlueprintManager.getInstance();
        for (int t = 0; t < Gedcom.ENTITIES.length; ++t) {
            String tag = Gedcom.ENTITIES[t];
            this.type2blueprint.put(tag, bpm.getBlueprint(ged.getOrigin(), tag, this.registry.get("blueprint." + tag, "")));
        }
        this.isAntialiasing = this.registry.get("antial", false);
        Entity entity = this.gedcom.getEntity(this.registry.get("entity", (String)null));
        if (entity == null) {
            entity = this.gedcom.getFirstEntity("INDI");
        }
        if (entity != null) {
            this.setEntity(entity);
        }
    }

    public ViewContext getContext() {
        return this.entity == null ? new ViewContext(this.gedcom) : new ViewContext(this.entity);
    }

    public Dimension getPreferredSize() {
        return new Dimension(256, 160);
    }

    public void addNotify() {
        super.addNotify();
        this.gedcom.addGedcomListener((GedcomListener)Spin.over(this.callback));
    }

    public void removeNotify() {
        super.removeNotify();
        this.gedcom.removeGedcomListener((GedcomListener)Spin.over(this.callback));
        for (int t = 0; t < Gedcom.ENTITIES.length; ++t) {
            String tag = Gedcom.ENTITIES[t];
            this.registry.put("blueprint." + tag, this.getBlueprint(tag).getName());
        }
        this.registry.put("antial", this.isAntialiasing);
        if (this.entity != null) {
            this.registry.put("entity", this.entity.getId());
        }
    }

    protected void paintComponent(Graphics g) {
        Rectangle bounds = this.getBounds();
        g.setColor(Color.white);
        g.fillRect(0, 0, bounds.width, bounds.height);
        g.setColor(Color.black);
        if (this.renderer == null) {
            return;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isAntialiasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.renderer.render(g, this.entity, new Rectangle(0, 0, bounds.width, bounds.height));
    }

    public void populate(JToolBar bar) {
    }

    Blueprint getBlueprint(String tag) {
        Blueprint result = (Blueprint)this.type2blueprint.get(tag);
        if (result == null) {
            result = BlueprintManager.getInstance().getBlueprint(this.gedcom.getOrigin(), tag, "");
            this.type2blueprint.put(tag, result);
        }
        return result;
    }

    void setBlueprints(Map setType2Blueprints) {
        this.type2blueprint = setType2Blueprints;
        this.setEntity(this.entity);
    }

    Map getBlueprints() {
        return this.type2blueprint;
    }

    public boolean handleBroadcastEvent(WindowBroadcastEvent event) {
        Entity e;
        ContextSelectionEvent cse = ContextSelectionEvent.narrow(event, this.gedcom);
        if (cse != null && (e = cse.getContext().getEntity()) != null) {
            this.setEntity(e);
        }
        return true;
    }

    public void setEntity(Entity e) {
        Blueprint blueprint = e == null ? BLUEPRINT_SELECT : this.getBlueprint(e.getTag());
        this.renderer = new EntityRenderer(blueprint);
        this.entity = e;
        this.repaint();
    }

    public void setAntialiasing(boolean set) {
        this.isAntialiasing = set;
        this.repaint();
    }

    public boolean isAntialiasing() {
        return this.isAntialiasing;
    }
}

