/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.common.AbstractPropertyTableModel;
import genj.common.PropertyTableWidget;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.Registry;
import java.awt.BorderLayout;
import java.awt.Dimension;

public class SpousesBean
extends PropertyBean {
    private static final String COLS_KEY = "bean.spouses.cols";
    private PropertyTableWidget table;

    void initialize(Registry setRegistry) {
        super.initialize(setRegistry);
        this.table = new PropertyTableWidget();
        this.table.setPreferredSize(new Dimension(64, 64));
        this.setLayout(new BorderLayout());
        this.add("Center", this.table);
    }

    public void addNotify() {
        super.addNotify();
        this.table.setColumnLayout(this.registry.get(COLS_KEY, (String)null));
    }

    public void removeNotify() {
        this.registry.put(COLS_KEY, this.table.getColumnLayout());
        super.removeNotify();
    }

    boolean accepts(Property prop) {
        return prop instanceof Fam;
    }

    public void setPropertyImpl(Property fam) {
        this.table.setModel(fam != null ? new SpousesInFamily((Fam)fam) : null);
    }

    public Property getProperty() {
        return null;
    }

    private static class SpousesInFamily
    extends AbstractPropertyTableModel {
        private static final TagPath[] PATHS = new TagPath[]{new TagPath("INDI"), new TagPath("INDI:NAME"), new TagPath("INDI:BIRT:DATE"), new TagPath("INDI:BIRT:PLAC")};
        private Fam fam;

        private SpousesInFamily(Fam fam) {
            this.fam = fam;
        }

        public Gedcom getGedcom() {
            return this.fam.getGedcom();
        }

        public int getNumCols() {
            return PATHS.length;
        }

        public int getNumRows() {
            return this.fam.getNoOfSpouses();
        }

        public TagPath getPath(int col) {
            return PATHS[col];
        }

        public Property getProperty(int row) {
            return this.fam.getSpouse(row);
        }
    }
}

