/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.renderer.BlueprintManager;
import genj.renderer.EntityRenderer;
import genj.util.ChangeSupport;
import genj.util.Registry;
import genj.util.Resources;
import genj.view.ContextProvider;
import genj.view.ViewContext;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

public abstract class PropertyBean
extends JPanel
implements ContextProvider {
    protected static final Resources resources = Resources.get(PropertyBean.class);
    private Property property;
    protected Registry registry;
    protected JComponent defaultFocus = null;
    protected ChangeSupport changeSupport = new ChangeSupport(this);

    void initialize(Registry setRegistry) {
        this.registry = setRegistry;
    }

    abstract boolean accepts(Property var1);

    public final void setProperty(Property prop) {
        this.property = prop;
        this.setPropertyImpl(prop);
        this.changeSupport.setChanged(false);
    }

    protected abstract void setPropertyImpl(Property var1);

    public ViewContext getContext() {
        return this.property == null || this.property.getEntity() == null ? null : new ViewContext(this.property);
    }

    public Property getProperty() {
        return this.property;
    }

    public boolean hasChanged() {
        return this.changeSupport.hasChanged();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void commit() {
        this.commit(this.property);
    }

    public void commit(Property property) {
        this.property = property;
        this.changeSupport.setChanged(false);
    }

    public boolean isEditable() {
        return true;
    }

    private void makeVisible() {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c.getParent() instanceof JTabbedPane)) continue;
            ((JTabbedPane)c.getParent()).setSelectedComponent(c);
            return;
        }
    }

    public boolean requestFocusInWindow() {
        this.makeVisible();
        if (this.defaultFocus != null) {
            return this.defaultFocus.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public void requestFocus() {
        this.makeVisible();
        if (this.defaultFocus != null) {
            this.defaultFocus.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public class Preview
    extends JComponent {
        private Entity entity;
        private EntityRenderer renderer;

        protected Preview() {
            this.setBorder(new EmptyBorder(4, 4, 4, 4));
        }

        protected void paintComponent(Graphics g) {
            Insets insets = this.getInsets();
            Rectangle box = new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            g.setColor(Color.WHITE);
            g.fillRect(box.x, box.y, box.width, box.height);
            if (this.renderer != null && this.entity != null) {
                this.renderer.render(g, this.entity, box);
            }
        }

        protected void setEntity(Entity ent) {
            this.entity = ent;
            if (this.entity != null) {
                this.renderer = new EntityRenderer(BlueprintManager.getInstance().getBlueprint(this.entity.getGedcom().getOrigin(), this.entity.getTag(), "Edit"));
            }
            this.repaint();
        }
    }
}

