/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.Options;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.util.DirectAccessTokenizer;
import genj.util.GridBagHelper;
import genj.util.Registry;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.window.WindowManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlaceBean
extends PropertyBean {
    private GridBagHelper gh = new GridBagHelper(this);
    private int rows = 0;
    private JCheckBox global = new JCheckBox();
    private Property[] sameChoices = new Property[0];

    void initialize(Registry setRegistry) {
        super.initialize(setRegistry);
        this.changeSupport.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                String confirm = PlaceBean.this.getGlobalConfirmMessage();
                PlaceBean.this.global.setVisible(confirm != null);
                PlaceBean.this.global.setToolTipText(confirm);
            }
        });
        this.global.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowManager wm = WindowManager.getInstance(PlaceBean.this);
                if (wm != null && PlaceBean.this.global.isSelected()) {
                    int rc = wm.openDialog(null, PropertyBean.resources.getString("choice.global.enable"), 3, PlaceBean.this.getGlobalConfirmMessage(), Action2.yesNo(), (Component)PlaceBean.this);
                    PlaceBean.this.global.setSelected(rc == 0);
                }
            }
        });
    }

    private String getCommitValue() {
        boolean hierarchy = Options.getInstance().isSplitJurisdictions && ((PropertyPlace)this.getProperty()).getHierarchy().length() > 0;
        StringBuffer result = new StringBuffer();
        int n = this.getComponentCount();
        int j = 0;
        for (int c = 0; c < n; ++c) {
            Component comp = this.getComponent(c);
            if (!(comp instanceof ChoiceWidget)) continue;
            String jurisdiction = ((ChoiceWidget)comp).getText().trim();
            if (hierarchy) {
                jurisdiction = jurisdiction.replaceAll(",", ";");
            }
            if (j++ > 0) {
                result.append(",");
            }
            result.append(jurisdiction);
        }
        return result.toString();
    }

    public void commit(Property property) {
        super.commit(property);
        ((PropertyPlace)property).setValue(this.getCommitValue(), this.global.isSelected());
        this.setProperty(property);
    }

    boolean accepts(Property prop) {
        return prop instanceof PropertyPlace;
    }

    public void setPropertyImpl(Property prop) {
        PropertyPlace place = (PropertyPlace)prop;
        if (place == null) {
            return;
        }
        this.sameChoices = place.getSameChoices();
        this.removeAll();
        this.rows = 0;
        this.defaultFocus = null;
        String value = place.isSecret() ? "" : place.getValue();
        String hierarchy = place.getHierarchy();
        if (!Options.getInstance().isSplitJurisdictions || hierarchy.length() == 0) {
            this.createChoice(null, value, place.getAllJurisdictions(-1, true), hierarchy);
        } else {
            DirectAccessTokenizer format = new DirectAccessTokenizer(hierarchy, ",");
            DirectAccessTokenizer jurisdictions = new DirectAccessTokenizer(value, ",");
            int i = 0;
            while (format.get(i) != null || jurisdictions.get(i) != null) {
                this.createChoice(format.get(i, true), jurisdictions.get(i, true), place.getAllJurisdictions(i, true), null);
                ++i;
            }
        }
        this.global.setVisible(false);
        this.global.setSelected(false);
        this.gh.add(this.global, 2, this.rows);
        this.gh.addFiller(1, ++this.rows);
    }

    private void createChoice(String label, String value, String[] values, String tip) {
        ++this.rows;
        if (label != null) {
            this.gh.add(new JLabel(label, 4), 0, this.rows, 1, 1, 1);
        }
        ChoiceWidget choice = new ChoiceWidget();
        choice.setIgnoreCase(true);
        choice.setEditable(true);
        choice.setValues(values);
        choice.setText(value);
        choice.addChangeListener(this.changeSupport);
        if (tip != null && tip.length() > 0) {
            choice.setToolTipText(tip);
        }
        this.gh.add(choice, 1, this.rows, 1, 1, 17);
        if (this.defaultFocus == null) {
            this.defaultFocus = choice;
        }
    }

    private String getGlobalConfirmMessage() {
        if (this.sameChoices.length < 2) {
            return null;
        }
        return resources.getString("choice.global.confirm", new String[]{"" + this.sameChoices.length, this.sameChoices[0].getDisplayValue(), this.getCommitValue()});
    }
}

