/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.common.AbstractPropertyTableModel;
import genj.common.PropertyTableWidget;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyWife;
import genj.gedcom.TagPath;
import genj.util.Registry;
import java.awt.BorderLayout;
import java.awt.Dimension;

public class ParentsBean
extends PropertyBean {
    private static final String COLS_KEY = "bean.parents.cols";
    private PropertyTableWidget table;

    void initialize(Registry setRegistry) {
        super.initialize(setRegistry);
        this.table = new PropertyTableWidget();
        this.table.setPreferredSize(new Dimension(64, 64));
        this.setLayout(new BorderLayout());
        this.add("Center", this.table);
    }

    public void addNotify() {
        super.addNotify();
        this.table.setColumnLayout(this.registry.get(COLS_KEY, (String)null));
    }

    public void removeNotify() {
        this.registry.put(COLS_KEY, this.table.getColumnLayout());
        super.removeNotify();
    }

    boolean accepts(Property prop) {
        return prop instanceof Indi;
    }

    public void setPropertyImpl(Property indi) {
        this.table.setModel(indi != null ? new ParentsOfChild((Indi)indi) : null);
    }

    public Property getProperty() {
        return null;
    }

    private static class ParentsOfChild
    extends AbstractPropertyTableModel {
        private static final TagPath[] PATHS = new TagPath[]{new TagPath("FAM"), new TagPath("FAM:HUSB:*:..", PropertyHusband.LABEL_FATHER), new TagPath("FAM:HUSB:*:..:NAME"), new TagPath("FAM:WIFE:*:..", PropertyWife.LABEL_MOTHER), new TagPath("FAM:WIFE:*:..:NAME")};
        private Indi child;
        private Fam[] familiesWhereChild;

        private ParentsOfChild(Indi child) {
            this.child = child;
            this.familiesWhereChild = child.getFamiliesWhereChild();
        }

        public Gedcom getGedcom() {
            return this.child.getGedcom();
        }

        public int getNumCols() {
            return PATHS.length;
        }

        public int getNumRows() {
            return this.familiesWhereChild.length;
        }

        public TagPath getPath(int col) {
            return PATHS[col];
        }

        public Property getProperty(int row) {
            return this.familiesWhereChild[row];
        }
    }
}

